/**************************************************************************//**
 * \file       clSDS_Method_NaviGetHouseNumberRange.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviGetHouseNumberRange_h
#define clSDS_Method_NaviGetHouseNumberRange_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "asf/core/Proxy.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/StringUtils.h"


class clSDS_Method_NaviGetHouseNumberRange
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternCallbackIF
{
   public:
      virtual ~clSDS_Method_NaviGetHouseNumberRange();
      clSDS_Method_NaviGetHouseNumberRange(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> naviProxy);

      void onSdsGetHouseNumberPatternError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternError >& error);
      void onSdsGetHouseNumberPatternResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternResponse >& response);

      tVoid vSendHouseNumberRange();

   private:
      struct stHouseNumberRange
      {
         std::string minHouseNr;
         std::string maxHouseNr;
         std::vector< std::string> patternlist;
      };
      stHouseNumberRange _oHouseNumberRange;
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      tVoid vGetHouseNumberRangeFromNavi(stHouseNumberRange& houseNrRange);
      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _navigationProxy;
};


#endif
