/**************************************************************************//**
 * \file       clSDS_Method_NaviGetContactListEntries.cpp
 *
 * clSDS_Method_NaviGetContactListEntries method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetContactListEntries.h"
#include "external/sds2hmi_fi.h"
#include "application/NaviVoiceTagHandler.h"


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NaviGetContactListEntries::~clSDS_Method_NaviGetContactListEntries()
{
   _pNaviVoiceTag = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NaviGetContactListEntries::clSDS_Method_NaviGetContactListEntries(ahl_tclBaseOneThreadService* pService,
      NaviVoiceTagHandler* pNaviVoiceTagHandler)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVIGETCONTACTLISTENTRIES, pService)
   , _pNaviVoiceTag(pNaviVoiceTagHandler)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_NaviGetContactListEntries::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult oResult;

   if (oMessage.nListEntryType.enType == sds2hmi_fi_tcl_e8_NAV_ListType::FI_EN_PERSISTANT_DEST
         && oMessage.nSelectionType.enType == sds2hmi_fi_tcl_e8_GEN_SelectionType::FI_EN_BYUSW)
   {
      sds2hmi_fi_tcl_HMIElementDescription hmiDescription;
      hmiDescription.DescriptorValue = _pNaviVoiceTag->getDestinationMemoryName(oMessage.nReferenceID).c_str();
      hmiDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_UNKNOWN;
      oResult.tDestListEntries.push_back(hmiDescription);
   }
   vSendMethodResult(oResult);
}
