/**************************************************************************//**
 * \file       clSDS_Method_NavDataUnRegisterDirectNDSUse.cpp
 *
 * clSDS_Method_NavDataUnRegisterDirectNDSUse method implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NavDataUnRegisterDirectNDSUse.h"
#include "external/sds2hmi_fi.h"
#include "SdsAdapter_Trace.h"

#define FI_S_IMPORT_INTERFACE_FI_TYPES
#include "fi_if.h"


using namespace org::bosch::cm::navigation::NavigationSDSService;


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NavDataUnRegisterDirectNDSUse::clSDS_Method_NavDataUnRegisterDirectNDSUse(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr< NavigationSDSServiceProxy> naviSDSProxy)

   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVDATAUNREGISTERDIRECTNDSUSE, pService)
   , _naviSDSProxy(naviSDSProxy)
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NavDataUnRegisterDirectNDSUse::~clSDS_Method_NavDataUnRegisterDirectNDSUse()
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_NavDataUnRegisterDirectNDSUse::vMethodStart(amt_tclServiceData* pInMsg)
{
   sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart oMessage;
   vGetDataFromAmt(pInMsg, oMessage);
   unsigned long datasetId = oMessage.DataSetId;
   NdsDatasetUser datasetUser = NdsDatasetUser__NDS_DATASET_USER__SDS;
   _naviSDSProxy->sendSdsDatasetUserDeregistrationRequest(*this, datasetUser, datasetId);
}


/**************************************************************************//**
*
******************************************************************************/

void clSDS_Method_NavDataUnRegisterDirectNDSUse::onSdsDatasetUserDeregistrationError(const ::boost::shared_ptr< NavigationSDSServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SdsDatasetUserDeregistrationError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/

void clSDS_Method_NavDataUnRegisterDirectNDSUse::onSdsDatasetUserDeregistrationResponse(const ::boost::shared_ptr< NavigationSDSServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SdsDatasetUserDeregistrationResponse >& /*response*/)
{
   vSendMethodResult();
   notifydataSetDeRegistrationObservers();
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NavDataUnRegisterDirectNDSUse::addDataSetDeRegistrationObserver(NaviDataSetDeRegistrationObserver* pObserver)
{
   if (pObserver != NULL)
   {
      _dataSetDeRegistrationObservers.push_back(pObserver);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NavDataUnRegisterDirectNDSUse::notifydataSetDeRegistrationObservers()
{
   for (size_t i = 0; i < _dataSetDeRegistrationObservers.size(); ++i)
   {
      _dataSetDeRegistrationObservers.at(i)->onNaviDataSetDeRegistration();
   }
}
