/**************************************************************************//**
 * \file       clSDS_Method_NavDataRegisterDirectNDSUse.h
 *
 * clSDS_Method_NavDataRegisterDirectNDSUse method implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NavDataRegisterDirectNDSUse_h
#define clSDS_Method_NavDataRegisterDirectNDSUse_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "external/sds2hmi_fi.h"

#include "Sds2HmiServer/functions/clSDS_Method_NavDataUnRegisterDirectNDSUse.h"
#include "application/NaviDataSetDeRegistrationObserver.h"

class NaviGlobalDataForSdsObserver;


class clSDS_Method_NavDataRegisterDirectNDSUse
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::NavStatusCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::GetGlobalDataForSdsCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationCallbackIF
   , public NaviDataSetDeRegistrationObserver

{
   public:
      clSDS_Method_NavDataRegisterDirectNDSUse(ahl_tclBaseOneThreadService* pService,
            ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> pNaviProxy,
            ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > pSds2NaviProxy,
            clSDS_Method_NavDataUnRegisterDirectNDSUse* pMethodNavDataRegisterDirectNDSUse);

      virtual ~clSDS_Method_NavDataRegisterDirectNDSUse();

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      void onNaviDataSetDeRegistration();

      void onNavStatusError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavStatusError >& error);
      void onNavStatusUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavStatusUpdate >& update);

      void onGetGlobalDataForSdsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetGlobalDataForSdsError >& error);
      void onGetGlobalDataForSdsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetGlobalDataForSdsResponse >& response);

      void onSdsDatasetUserRegistrationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationError >& error);
      void  onSdsDatasetUserRegistrationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationResponse >& response);

      void setSdsProducts(
         const ::std::string& device,
         const ::std::string& persistentDataSetId,
         const ::std::vector<org::bosch::cm::navigation::NavigationSDSService::SdsProducts>& naviSdsProductsList);
      void setUpdateRegionSpecifierRelationList(
         const ::std::vector <org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations>& updateRegionSpecifierRelationsList);
      bool getUpdateRegionSpecifierValues(
         uint16 regionSpecifier,
         org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations& currentValue);
      void clearsdsProducts();
      void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void addGlobalDataForSdsObserver(NaviGlobalDataForSdsObserver* pObserver);
      void notifyGlobalDataForSdsObservers();
      void verifyAndSendResult();

   private:
      sds2hmi_fi_tclString _device;
      sds2hmi_fi_tclString _persistentDataSetId;
      ::std::vector<sds2hmi_fi_tcl_SDSProduct> _sdsProductsList;
      ::std::vector <org::bosch::cm::navigation::NavigationSDSService::UpdateRegionSpecifierRelations> _regionSpecifierRelationList;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      std::vector<NaviGlobalDataForSdsObserver*> _globalDataForSdsObservers;
      clSDS_Method_NavDataUnRegisterDirectNDSUse* _pMethodNavDataUnRegisterDirectNDSUse;
      bool _globalDataResponseReceived;
      bool _datasetRegistrationSuccess;
};


#endif
