/**************************************************************************//**
 * \file       clSDS_Method_NavDataGetStreetAvailability.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NavDataGetStreetAvailability_h
#define clSDS_Method_NavDataGetStreetAvailability_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"


class clSDS_Method_NavDataGetStreetAvailability
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsCallbackIF
{
   public:
      virtual ~clSDS_Method_NavDataGetStreetAvailability();
      clSDS_Method_NavDataGetStreetAvailability(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > pSds2NaviProxy);

      virtual void onGetCityHasStreetsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsError >& error);
      virtual void onGetCityHasStreetsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsResponse >& response);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _sds2NaviProxy;
      void requestStreetAvailability(std::vector<sds2hmi_fi_tcl_NDSID> cityNdsIdList);
      void sendStreetAvailabilityResult(std::vector< org::bosch::cm::navigation::NavigationSDSService::CityNamedObjectIdHasStreets >& cityHasStreetList);

      sds2hmi_fi_tcl_e8_NDSFeatureType _ndsFeatureType;
};


#endif
