/**************************************************************************//**
 * \file       clSDS_Method_NavDataGetStreetAvailability.cpp
 *
 * clSDS_Method_NavDataGetStreetAvailability method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NavDataGetStreetAvailability.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_NavDataGetStreetAvailability.cpp.trc.h"
#endif


using namespace org::bosch::cm::navigation::NavigationSDSService;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NavDataGetStreetAvailability::~clSDS_Method_NavDataGetStreetAvailability()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NavDataGetStreetAvailability::clSDS_Method_NavDataGetStreetAvailability(ahl_tclBaseOneThreadService* pService,
      ::boost::shared_ptr< NavigationSDSServiceProxy > pSds2NaviProxy)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVDATAGETSTREETAVAILABILITY, pService)
   , _sds2NaviProxy(pSds2NaviProxy)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NavDataGetStreetAvailability::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   requestStreetAvailability(oMessage.CityIdList);
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NavDataGetStreetAvailability::requestStreetAvailability(
   std::vector<sds2hmi_fi_tcl_NDSID> cityNdsIdList)
{
   std::vector<sds2hmi_fi_tcl_NDSID>::iterator it = cityNdsIdList.begin();
   std::vector< GlobalNamedObjectId > cityNdsIds;

   while (it != cityNdsIdList.end())
   {
      GlobalNamedObjectId cityObjectId;
      GlobalUpdateRegionId globalUpdateRegionId;

      globalUpdateRegionId.setUpdateRegionId(it->u16UpdateRegionId);
      cityObjectId.setGlobalUpdateRegionId(globalUpdateRegionId);

      globalUpdateRegionId.setProductId(it->u32ProductId);
      cityObjectId.setGlobalUpdateRegionId(globalUpdateRegionId);

      globalUpdateRegionId.setSupplierId(it->u8SupplierId);
      cityObjectId.setGlobalUpdateRegionId(globalUpdateRegionId);

      cityObjectId.setNamedObjectId(it->u32NDSId);

      _ndsFeatureType = it->eNDSFeatureType;

      cityNdsIds.push_back(cityObjectId);

      ++it;
   }

   _sds2NaviProxy->sendGetCityHasStreetsRequest(*this, cityNdsIds);
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NavDataGetStreetAvailability::onGetCityHasStreetsResponse(
   const ::boost::shared_ptr< NavigationSDSServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< GetCityHasStreetsResponse >& response)
{
   std::vector< CityNamedObjectIdHasStreets > cityHasStreetList;

   cityHasStreetList = response->getCityNamedObjectIdHasStreetsList();

   sendStreetAvailabilityResult(cityHasStreetList);
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NavDataGetStreetAvailability::onGetCityHasStreetsError(
   const ::boost::shared_ptr< NavigationSDSServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< GetCityHasStreetsError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_NavDataGetStreetAvailability::sendStreetAvailabilityResult(
   std::vector< CityNamedObjectIdHasStreets >& cityHasStreetList)
{
   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult result;

   sds2hmi_fi_tcl_StreetAvailability streetAvailability;

   std::vector< CityNamedObjectIdHasStreets >::iterator it = cityHasStreetList.begin();

   while (it != cityHasStreetList.end())
   {
      streetAvailability.City_Id.u16UpdateRegionId = it->getGlobalNamedObjectId().getGlobalUpdateRegionId().getUpdateRegionId();
      streetAvailability.City_Id.u32ProductId = it->getGlobalNamedObjectId().getGlobalUpdateRegionId().getProductId();
      streetAvailability.City_Id.u8SupplierId = it->getGlobalNamedObjectId().getGlobalUpdateRegionId().getSupplierId();
      streetAvailability.City_Id.u32NDSId = it->getGlobalNamedObjectId().getNamedObjectId();
      streetAvailability.City_Id.eNDSFeatureType = _ndsFeatureType;

      streetAvailability.Availability = it->getHasStreets();

      result.StreetAvailabilityList.push_back(streetAvailability);

      ++it;
   }

   vSendMethodResult(result);
}
