/**************************************************************************//**
 * \file       clSDS_Method_NavDataAccessModeChanged.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NavDataAccessModeChanged_h
#define clSDS_Method_NavDataAccessModeChanged_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceConst.h"
#include "external/sds2hmi_fi.h"


class clSDS_Method_NavDataAccessModeChanged
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationSDSService::DatasetAccessModeChangedIndicationCallbackIF
{
   public:
      clSDS_Method_NavDataAccessModeChanged(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> naviSDSProxy);
      virtual ~clSDS_Method_NavDataAccessModeChanged();

      void onDatasetAccessModeChangedIndicationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::DatasetAccessModeChangedIndicationError >& error);
      void onDatasetAccessModeChangedIndicationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::DatasetAccessModeChangedIndicationResponse >& response);

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);

   private:
      boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> _naviSDSProxy;
      std::map< sds2hmi_fi_tcl_e8_NDSDataAccessType::tenType, org::bosch::cm::navigation::NavigationSDSService::NdsDataAccessType> _ndsDataAccessTypeMap;
      void mapSdsUnittoNaviUnit();
};


#endif
