/**************************************************************************//**
 * \file       clSDS_Method_NavDataAccessModeChanged.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NavDataAccessModeChanged.h"
#include "SdsAdapter_Trace.h"


using namespace org::bosch::cm::navigation::NavigationSDSService;


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NavDataAccessModeChanged::clSDS_Method_NavDataAccessModeChanged(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr< NavigationSDSServiceProxy> naviSDSProxy)

   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVDATAACCESSMODECHANGED, pService)
   , _naviSDSProxy(naviSDSProxy)
{
   mapSdsUnittoNaviUnit();
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NavDataAccessModeChanged::~clSDS_Method_NavDataAccessModeChanged()
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_NavDataAccessModeChanged::vMethodStart(amt_tclServiceData* pInMsg)
{
   sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart oMessage;
   vGetDataFromAmt(pInMsg, oMessage);
   NdsDatasetUser datasetUser = NdsDatasetUser__NDS_DATASET_USER__SDS;
   NdsDataAccessType dataAccessType = _ndsDataAccessTypeMap[oMessage.DataAccessType.enType];
   _naviSDSProxy->sendDatasetAccessModeChangedIndicationRequest(*this, datasetUser, oMessage.DataSetId, dataAccessType);
}


/**************************************************************************//**
*
******************************************************************************/

void clSDS_Method_NavDataAccessModeChanged::onDatasetAccessModeChangedIndicationError(const ::boost::shared_ptr< NavigationSDSServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< DatasetAccessModeChangedIndicationError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/

void clSDS_Method_NavDataAccessModeChanged::onDatasetAccessModeChangedIndicationResponse(const ::boost::shared_ptr< NavigationSDSServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< DatasetAccessModeChangedIndicationResponse >& /*response*/)
{
   vSendMethodResult();
}


void clSDS_Method_NavDataAccessModeChanged::mapSdsUnittoNaviUnit()
{
   _ndsDataAccessTypeMap[sds2hmi_fi_tcl_e8_NDSDataAccessType::FI_EN_UNKNOWN] = NdsDataAccessType__NDS_DATA_ACCESS_TYPE__UNKNOWN;
   _ndsDataAccessTypeMap[sds2hmi_fi_tcl_e8_NDSDataAccessType::FI_EN_SHARED] = NdsDataAccessType__NDS_DATA_ACCESS_TYPE__SHARED;
   _ndsDataAccessTypeMap[sds2hmi_fi_tcl_e8_NDSDataAccessType::FI_EN_NOT_SHARED] = NdsDataAccessType__NDS_DATA_ACCESS_TYPE__NOT_SHARED;
   _ndsDataAccessTypeMap[sds2hmi_fi_tcl_e8_NDSDataAccessType::FI_EN_NONE] = NdsDataAccessType__NDS_DATA_ACCESS_TYPE__UNKNOWN;
}
