/**************************************************************************//**
 * \file       clSDS_Method_MediaPlay.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_MediaPlay_h
#define clSDS_Method_MediaPlay_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"

#include "mplay_MediaPlayer_FIProxy.h"

class GuiService;
class clSDS_Method_MediaGetDeviceInfo;


class clSDS_Method_MediaPlay
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsCallbackIF
   , public mplay_MediaPlayer_FI:: PlayMediaPlayerObjectCallbackIF
   , public mplay_MediaPlayer_FI::PlayItemFromListCallbackIF
   , public mplay_MediaPlayer_FI::GetMediaObjectCallbackIF
   , public mplay_MediaPlayer_FI::ActiveMediaDeviceCallbackIF
   , public mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListCallbackIF
   , public mplay_MediaPlayer_FI::ClearLastModePauseCallbackIF

{
   public:
      virtual ~clSDS_Method_MediaPlay();
      clSDS_Method_MediaPlay(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > pSdsMediaProxy,
         GuiService& guiService,
         clSDS_Method_MediaGetDeviceInfo* mediaGetDeviceInfo);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onMediaPlayerDeviceConnectionsStatus(
         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus >& status);

      virtual void onMediaPlayerDeviceConnectionsError(
         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsError >& error);

      virtual void onPlayMediaPlayerObjectError(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::PlayMediaPlayerObjectError >& error);

      virtual void onPlayMediaPlayerObjectResult(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::PlayMediaPlayerObjectResult >& result);

      virtual void onPlayItemFromListError(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::PlayItemFromListError >& error);

      virtual void onPlayItemFromListResult(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::PlayItemFromListResult >& result);

      virtual void onGetMediaObjectError(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::GetMediaObjectError >& error);

      virtual void onGetMediaObjectResult(
         const ::boost::shared_ptr<mplay_MediaPlayer_FI:: Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::GetMediaObjectResult >& result);

      virtual void onCreateMediaPlayerQuickPlayListError(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListError >& error);

      virtual void onCreateMediaPlayerQuickPlayListResult(
         const ::boost::shared_ptr<mplay_MediaPlayer_FI:: Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::CreateMediaPlayerQuickPlayListResult >& result);

      virtual void onActiveMediaDeviceError(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::ActiveMediaDeviceError >& error);

      virtual void onActiveMediaDeviceStatus(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::ActiveMediaDeviceStatus >& status);

      virtual void onClearLastModePauseError(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::ClearLastModePauseError >& error);

      virtual void onClearLastModePauseResult(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::ClearLastModePauseResult >& error);

   private:

      struct trDevice
      {
         bool bIsConnected;
         unsigned int uiDeviceTag;
         unsigned int uiDeviceType;
         unsigned int uiNoOfAudioFiles;
         unsigned int discType;
         std::string syspath;
      };

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      tVoid vPlaySource(tU32 u32SdsSourceId);
      tVoid vCdPlayByTrack(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& oMessage);
      tVoid vProcessMessage(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& oMessage);
      tVoid vProcessMediaRequests(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& oMessage);
      tVoid playAllSources(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& oMessage);
      bool enGetMediaAudioSource();
      bool bIsSupportedDVDDisc(tU32 u32Index) const;
      tBool isUSB1connected(std::string& sysPath) const;
      tVoid vMediaPlayStatus();
      tVoid vMediaObjectValidationResponse(tBool bResult);
      tVoid sendPlayMediaRequest(unsigned int deviceTag, unsigned int deviceType, std::string syspath);
      sds2hmi_fi_tcl_e8_MPL_SourceType::tenType enGetHmiSourceType(tU32 u32SdsSourceId);
      boost::shared_ptr<mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy> _mediaPlayerProxy;
      GuiService& _guiService;
      clSDS_Method_MediaGetDeviceInfo* _pMediaGetDeviceInfo;
      std::vector< trDevice > _oDeviceList;
      tU32 _u32MediaId;
      MPlay_fi_types::T_e8_MPlayDeviceType _e8DeviceType;
      uint8 _u8DeviceTag;
};


#endif
