/**************************************************************************//**
 * \file       clSDS_Method_MediaGetAmbiguityList.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_MediaGetAmbiguityList_h
#define clSDS_Method_MediaGetAmbiguityList_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "mplay_MediaPlayer_FIProxy.h"


class clSDS_NBestList;


class clSDS_Method_MediaGetAmbiguityList
   : public clServerMethod
   , public mplay_MediaPlayer_FI::GetMediaObjectCallbackIF
{
   public:
      virtual ~clSDS_Method_MediaGetAmbiguityList();
      clSDS_Method_MediaGetAmbiguityList(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > mediaPlayerProxy,
         clSDS_NBestList* pNBestList);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);

      virtual void onGetMediaObjectError(
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::GetMediaObjectError >& error);
      virtual void onGetMediaObjectResult(
         const ::boost::shared_ptr<mplay_MediaPlayer_FI:: Mplay_MediaPlayer_FIProxy >& proxy,
         const ::boost::shared_ptr< mplay_MediaPlayer_FI::GetMediaObjectResult >& result);

      void responseReceived();
      void sendResult();
      std::vector<sds2hmi_fi_tcl_MediaIDString> convertMediaObjects() const;
      std::string makeListItemString(const MPlay_fi_types::T_MPlayMediaObject& mediaObject) const;
      std::string trimAmbiguousPlaylistPath(const std::string& path) const;
      void populateViewList(const std::vector<sds2hmi_fi_tcl_MediaIDString>& ambigList) const;
      void traceResult(const std::vector<sds2hmi_fi_tcl_MediaIDString>& ambigList) const;

      boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > _mediaPlayerProxy;
      clSDS_NBestList* _pNBestList;
      std::vector<MPlay_fi_types::T_MPlayMediaObject> _mediaObjects;
      size_t _pendingResponses;
};


#endif
