/**************************************************************************//**
 * \file       clSDS_Method_CommonStopSession.cpp
 *
 * clSDS_Method_CommonStopSession method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonStopSession.h"
#include "external/sds2hmi_fi.h"
#include "application/GuiService.h"
#include "application/SdsAudioSource.h"
#include "application/clSDS_MenuManager.h"
#include "application/DiagnosticsClientHandler.h"


using namespace sds_gui_fi::SdsGuiService;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_CommonStopSession::~clSDS_Method_CommonStopSession()
{
   _pMenuManager = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_CommonStopSession::clSDS_Method_CommonStopSession(
   ahl_tclBaseOneThreadService* pService,
   SdsAudioSource& audioSource,
   clSDS_MenuManager* pMenuManager,
   GuiService& guiService,
   DiagnosticsClientHandler& diagnosticsClientHandler)

   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONSTOPSESSION, pService)
   , _audioSource(audioSource)
   , _pMenuManager(pMenuManager)
   , _guiService(guiService)
   , _diagnosticsClientHandler(diagnosticsClientHandler)
   , _waitingOnAudioActivity(false)
{
   _audioSource.addObserver(this);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonStopSession::vMethodStart(amt_tclServiceData* /*pInMessage*/)
{
   if (_audioSource.getArlSourceActivity() == ARL_EN_ISRC_ACT_OFF)
   {
      _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_STOP_SESSION);
      _pMenuManager->vCloseGUI();
      vSendMethodResult();
   }
   else
   {
      _waitingOnAudioActivity = true;
      _audioSource.sendAudioRouteRequest(ARL_SRC_VRU, ARL_EN_ISRC_ACT_OFF);
   }
   _diagnosticsClientHandler.computeGuidanceRuntime(false);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_CommonStopSession::onAudioSourceStateChanged(arl_tenActivity state)
{
   if (_waitingOnAudioActivity)
   {
      if (state == ARL_EN_ISRC_ACT_OFF)
      {
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_STOP_SESSION);
         _pMenuManager->vCloseGUI();
         vSendMethodResult();
         _waitingOnAudioActivity = false;
      }
      else
      {
      }
   }
}
