/**************************************************************************//**
 * \file       clSDS_Method_CommonStartSession.cpp
 *
 * clSDS_Method_CommonStartSession method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonStartSession.h"
#include "application/SdsAudioSource.h"
#include "Sds2HmiServer/functions/clSDS_Property_Audio_ECNR_EngineParameter.h"
#include "application/DiagnosticsClientHandler.h"
#include "external/sds2hmi_fi.h"

using namespace sds_gui_fi::SdsGuiService;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_CommonStartSession::~clSDS_Method_CommonStartSession()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_CommonStartSession::clSDS_Method_CommonStartSession(
   ahl_tclBaseOneThreadService* pService,
   SdsAudioSource& audioSource,
   GuiService& guiService,
   clSDS_Property_Audio_ECNR_EngineParameter& property_Audio_ECNR_EngineParameter,
   DiagnosticsClientHandler& diagnosticsClientHandler)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONSTARTSESSION, pService)
   , _audioSource(audioSource)
   , _guiService(guiService)
   , _property_Audio_ECNR_EngineParameter(property_Audio_ECNR_EngineParameter)
   , _diagnosticsClientHandler(diagnosticsClientHandler)
   , _waitingOnAudioActivity(false)
{
   _property_Audio_ECNR_EngineParameter.addObserver(this);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonStartSession::vMethodStart(amt_tclServiceData* /*pInMessage*/)
{
   if (_audioSource.getArlSourceActivity() == ARL_EN_ISRC_ACT_ON)
   {
      vSendMethodResult();
   }
   else
   {
      _waitingOnAudioActivity = true;
      _audioSource.sendAudioRouteRequest(ARL_SRC_VRU, ARL_EN_ISRC_ACT_ON);
      startAudioChannelWaitTimer();
   }
   _diagnosticsClientHandler.computeGuidanceRuntime(true);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_CommonStartSession::onEcnrEngineParameterChanged()
{
   if (_waitingOnAudioActivity)
   {
      _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_START_SESSION);
      vSendMethodResult();
      _waitingOnAudioActivity = false;
      stopAudioChannelWaitTimer();
   }
}


/**************************************************************************//**
 * 3000 millisecs ~= (10 * 250ms(normal time to process the Audiochannel request
 *   + EcnrEngineparameter request when system is inload)
 ******************************************************************************/
void clSDS_Method_CommonStartSession::startAudioChannelWaitTimer()
{
   _audioChannelWaitTimer.start(*this, 3000);
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_CommonStartSession::stopAudioChannelWaitTimer()
{
   _audioChannelWaitTimer.stop();
}


/**************************************************************************//**
 * If SDSAdapter doesn't receive Audio channel response on time, send Audiochannel request OFF to clear any pending channelrequest
 * and also send MethodError to end the wait for MethodResult.
 * In the event of new PTTpress, startsession Methodstart would be received.
 * Assumption: SDSMW doesn't process PTT request while it waits for Startsession MethodResult.
 ******************************************************************************/
void clSDS_Method_CommonStartSession::onExpired(asf::core::Timer& /*timer*/, boost::shared_ptr<asf::core::TimerPayload> /*data*/)
{
   _audioSource.sendAudioRouteRequest(ARL_SRC_VRU, ARL_EN_ISRC_ACT_OFF);
   vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
   _waitingOnAudioActivity = false;
}
