/**************************************************************************//**
 * \file       clSDS_Method_CommonShowDialog.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_CommonShowDialog_h
#define clSDS_Method_CommonShowDialog_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "application/clSDS_Display.h"
#include "application/clSDS_ConfigurationFlags.h"


class clSDS_MenuManager;
class clSDS_ListScreen;
class clSDS_Property_PhoneStatus;
class clSDS_ScreenData;
class GuiService;
class SdsPhoneService;
class clSDS_ActiveScreenObserver;
class clSDS_Display;
class VariantLayoutMap;

class clSDS_Method_CommonShowDialog : public clServerMethod
{
   public:
      virtual ~clSDS_Method_CommonShowDialog();
      clSDS_Method_CommonShowDialog(
         ahl_tclBaseOneThreadService* pService,
         clSDS_MenuManager* pMenuManager,
         clSDS_ListScreen* pListScreen,
         clSDS_Property_PhoneStatus* pProperty_PhoneStatus,
         GuiService* pGuiService,
         SdsPhoneService* pSdsPhoneService,
         clSDS_Display* pDisplay,
         VariantLayoutMap* pVariantLayoutMap);

      std::string getViewId() const;
      void setActiveScreenObserver(clSDS_ActiveScreenObserver* obs);
      void vTTFisMethodStart(std::string paramString);

   private:
      enum
      {
         SINGLE_PAGE = 1,
         PREVIOUS_PAGE = 2,
         NEXT_PAGE = 4,
         NEXT_PREVIOUS_PAGE = 6
      };

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      tVoid vUpdatePageNumber(sds2hmi_fi_tcl_e8_PopUp_UpdateType nPopUp_UpDateType);
      tVoid vSendResult(const clSDS_ScreenData& oScreenData);
      sds2hmi_fi_tcl_e8_MainDomains::tenType getPreviousDomain(const std::string& viewId) const;
      sds2hmi_fi_tcl_e8_MainDomains::tenType getNextDomain(const std::string& viewId) const;
      uint32 getPageNumber(const std::string& viewId);
      uint32 getNumberOfPages(const std::string& viewId);
      uint32 getNumberOfCommandPages() const;
      uint32 getLastCommandPage() const;
      tU8 getNextPreviousListPageOptions() const;
      tU8 getNextPreviousCommandPageOptions() const;
      tVoid vTraceXmlData(const std::string& oXmlData) const;
      tVoid vUpdateSpokenDigitString(const clSDS_ScreenData& oScreenData, const std::string& viewId);
      bool isPhoneAvailable() const;
      bool isNaviAvailable() const;
      bool isInfoAvailable() const;
      bool isEveAvailable() const;
      bool isVehicleInfoAvailable() const;
      unsigned int getNumberOfCommandsOnPage();
      tU8 getNextPreviousOptions(const std::string& viewId) const;
      std::vector<SelectableText> _CommandList;

      clSDS_MenuManager* _pMenuManager;
      GuiService* _pGuiService;
      SdsPhoneService* _pSdsPhoneService;
      clSDS_ListScreen* _pListScreen;
      clSDS_Property_PhoneStatus* _pProperty_PhoneStatus;
      clSDS_ActiveScreenObserver* _pActiveScreenObserver;
      clSDS_Display* _pDisplay;
      VariantLayoutMap* _pVariantLayoutMap;
      std::string _viewId;
      uint32 _commandPageNumber;
      uint32 _maxItemsPerPage;
};


#endif
