/**************************************************************************//**
 * \file       clSDS_Method_CommonSetAvailableUserwords.cpp
 *
 * clSDS_Method_CommonSetAvailableUserwords method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonSetAvailableUserwords.h"
#include "external/sds2hmi_fi.h"
#include "application/StringUtils.h"
#include "application/NaviVoiceTagHandler.h"
#include "SdsAdapter_Trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonSetAvailableUserwords.cpp.trc.h"
#endif


#define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
#include "utf_if.h"

#define NAVIUSERWORDPROFILE 1
/**************************************************************************//**
 * Destructor
 ******************************************************************************/
clSDS_Method_CommonSetAvailableUserwords::~clSDS_Method_CommonSetAvailableUserwords()
{
   _pNaviVoiceTag = NULL;
}


/**************************************************************************//**
 * Constructor
 ******************************************************************************/
clSDS_Method_CommonSetAvailableUserwords::clSDS_Method_CommonSetAvailableUserwords(ahl_tclBaseOneThreadService* pService,
      SdsPhoneService& sdsPhoneService,
      ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy,
      NaviVoiceTagHandler* pNaviVoiceTagHandler)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONSETAVAILABLEUSERWORDS, pService)
   , _phonebookProxy(phonebookProxy)
   , _sdsPhoneService(sdsPhoneService)
   , _pNaviVoiceTag(pNaviVoiceTagHandler)
   , _availableUserwords()
   , _profileID(0)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_Method_CommonSetAvailableUserwords::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);

   _availableUserwords.clear();
   _availableUserwords = oMessage.AvailableUserwords;
   updateUserWords();
   vTraceMethodStart(oMessage.AvailableUserwords);
   vSendMethodResult();
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_CommonSetAvailableUserwords::phoneProfileChanged(uint8 profileID)
{
   _profileID = profileID;
   updateUserWords();
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_CommonSetAvailableUserwords::updateUserWords()
{
   for (tU32 u32Index = 0; u32Index < _availableUserwords.size(); u32Index++)
   {
      ETG_TRACE_USR1(("Navi user word profile = %d", _availableUserwords[u32Index].UWProfile));
      ETG_TRACE_USR1(("Navi user word size = %d", _availableUserwords[u32Index].NaviUWs.size()));
      if ((_availableUserwords[u32Index].UWProfile == NAVIUSERWORDPROFILE) && !_availableUserwords[u32Index].NaviUWs.empty() && _pNaviVoiceTag)
      {
         _pNaviVoiceTag->updateNaviUserWordList(_availableUserwords[u32Index].NaviUWs);
      }

      if ((_availableUserwords[u32Index].UWProfile + 1) == _profileID)
      {
         ETG_TRACE_USR1(("Active profile number = %d", _profileID));
         std::vector< sds_gui_fi::SdsPhoneService::UserWordList > userWordList;
         sds_gui_fi::SdsPhoneService::UserWordList uwList;
         if (!_availableUserwords[u32Index].PhoneUWs.empty())
         {
            uwList.setUserWordProfileID(_availableUserwords[u32Index].UWProfile + 1);
            uwList.setPhoneUWID(_availableUserwords[u32Index].PhoneUWs);
            userWordList.push_back(uwList);
         }
         _sdsPhoneService.sendUserWordUpdateSignal(userWordList);
      }
   }
}


/***********************************************************************//**
 *
 ***************************************************************************/
//static std::string makeDebugString(const sds2hmi_fi_tcl_Userword oSDS_user)
//{
//   std::string oTraceString;
//   for (tU32 u32SdsListIndex = 0; u32SdsListIndex < oSDS_user.PhoneUWs.size(); u32SdsListIndex++)
//   {
//      oTraceString.append(" ");
//      oTraceString.append(StringUtils::toString(oSDS_user.PhoneUWs[u32SdsListIndex]));
//   }
//   return oTraceString;
//}


/***********************************************************************//**
 *
 ***************************************************************************/
tVoid clSDS_Method_CommonSetAvailableUserwords::vTraceMethodStart(const AvailableUserwords& /*oUserwords*/) const
{
   // TODO jnd2hi rework trace
   //   for (tU32 u32Index = 0; u32Index < oUserwords.size(); u32Index++)
   //   {
   //      ET_TRACE_BIN(
   //         TR_CLASS_SDSADP_DETAILS,
   //         TR_LEVEL_HMI_INFO,
   //         ET_EN_T16 _ TRACE_CCA_VALUE _
   //         ET_EN_T16 _ _pService->u16GetServiceId() _
   //         ET_EN_T16 _ u16GetFunctionID() _
   //         ET_EN_T32 _ oUserwords[u32Index].UWProfile _
   //         ET_EN_STRING _ makeDebugString(oUserwords[u32Index]).c_str() _
   //         ET_EN_DONE);
   //   }
}
