/**************************************************************************//**
 * \file       clSDS_Method_CommonSetAvailableSpeakers.cpp
 *
 * clSDS_Method_CommonSetAvailableSpeakers method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonSetAvailableSpeakers.h"
#include "external/sds2hmi_fi.h"
#include "application/clSDS_LanguageMediator.h"
#include "SdsAdapter_Trace.h"
#include "application/StringUtils.h"
#include <sstream>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonSetAvailableSpeakers.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_CommonSetAvailableSpeakers::~clSDS_Method_CommonSetAvailableSpeakers()
{
   _pLanguageMediator = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_CommonSetAvailableSpeakers::clSDS_Method_CommonSetAvailableSpeakers(ahl_tclBaseOneThreadService* pService, clSDS_LanguageMediator* pLanguageMediator)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONSETAVAILABLESPEAKERS, pService),
     _pLanguageMediator(pLanguageMediator)
{
}


static void traceAvailableSpeakers(const std::vector<sds2hmi_fi_tcl_LanguageAndSpeaker>& speakers)
{
   if (etg_bIsTraceActive(TR_CLASS_SDSADP_DETAILS, ETG_LEVEL_USER_4))
   {
      for (size_t i = 0; i < speakers.size(); ++i)
      {
         std::stringstream line;
         line << "id=" << speakers[i].SpeakerId << ", ";
         line << "gender=" << speakers[i].Gender.enType << ", ";
         line << "asr=" << static_cast<size_t>(speakers[i].ASRsupported) << ", ";
         line << "language=" << StringUtils::toISOString(speakers[i].LanguageID.ISO639_3_SDSLanguageCode.enType) << ", ";
         line << "country=" << StringUtils::toISOString(speakers[i].LanguageID.ISO3166_CountryCode.enType) << ", ";
         ETG_TRACE_USR4(("available speaker: %s", line.str().c_str()));
      }
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonSetAvailableSpeakers::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   traceAvailableSpeakers(oMessage.LanguageAndSpeaker);
   vSendMethodResult();
   if (_pLanguageMediator != NULL)
   {
      _pLanguageMediator->setAvailableSpeakers(oMessage.LanguageAndSpeaker);
   }
}
