/**************************************************************************//**
 * \file       clSDS_Method_CommonSetActiveApplication.cpp
 *
 * clSDS_Method_CommonSetActiveApplication method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonSetActiveApplication.h"
#include "SdsAdapter_Trace.h"

#define ETG_ENABLED
#include "trace_interface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX      "SdsAdapter_"
#define ETG_I_TRACE_CHANNEL         TR_TTFIS_SAAL
#define ETG_DEFAULT_TRACE_CLASS     TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonSetActiveApplication.cpp.trc.h"
#endif


using namespace org::genivi::audiomanager::CommandInterface;
using namespace sds_gui_fi::SdsGuiService;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_CommonSetActiveApplication::~clSDS_Method_CommonSetActiveApplication()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_CommonSetActiveApplication::clSDS_Method_CommonSetActiveApplication(ahl_tclBaseOneThreadService* pService, GuiService& guiService
      , boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy> commandInterfaceProxy)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONSETACTIVEAPPLICATION, pService)
   , _guiService(guiService)
   , _commandInterfaceProxy(commandInterfaceProxy)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonSetActiveApplication::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   switch (oMessage.ApplicationId.enType)
   {
      case sds2hmi_fi_tcl_e8_Application::FI_EN_SPEECH_SETTINGS:
         _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_VR_SETTINGS);
         break;

      case sds2hmi_fi_tcl_e8_Application::FI_EN_SONG_LIST:
         _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SONG_LIST);
         break;

      case sds2hmi_fi_tcl_e8_Application::FI_EN_ARTIST_LIST:
         _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_ARTIST_LIST);
         break;

      case sds2hmi_fi_tcl_e8_Application::FI_EN_ALBUM_LIST:
         _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_ALBUM_LIST);
         break;

      /*case sds2hmi_fi_tcl_e8_Application::FI_EN_TV_TUNER:
         _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SDS_PLAY_TV);
         _guiService.sendActivateAudioSourceSignal(AudioSource__DTV);
         break;*/

      case sds2hmi_fi_tcl_e8_Application::FI_EN_TUNER:
         _commandInterfaceProxy->sendGetListSystemPropertiesRequest(*this);
         break;

      default:
         break;
   }
   vSendMethodResult();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonSetActiveApplication::onGetListSystemPropertiesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& /*proxy*/,
      const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesError >& /*error*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonSetActiveApplication::onGetListSystemPropertiesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& /*proxy*/,
      const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse >& response)
{
   const ::std::vector< GetListSystemPropertiesResponseListSystemPropertiesStruct >& listSystemProperties = response->getListSystemProperties();
   if (!listSystemProperties.empty())
   {
      for (::std::vector< GetListSystemPropertiesResponseListSystemPropertiesStruct >::const_iterator itr = listSystemProperties.begin(); itr != listSystemProperties.end(); ++itr)
      {
         if (itr->getElem1() == SYP_LAST_TUNER_SOURCE)
         {
            requestPlayLastTunerSource(itr->getElem2());
         }
      }
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonSetActiveApplication::requestPlayLastTunerSource(const uint16 sourceID)
{
   switch (sourceID)
   {
      case TUNER_FM:
         _guiService.sendActivateAudioSourceSignal(AudioSource__FM);
         break;

      case TUNER_AM:
         _guiService.sendActivateAudioSourceSignal(AudioSource__AM);
         break;

      case TUNER_DAB:
         _guiService.sendActivateAudioSourceSignal(AudioSource__DAB);
         break;

      case TUNER_DRM:
         _guiService.sendActivateAudioSourceSignal(AudioSource__DRM);
         break;

      /*case DTV:
         _guiService.sendActivateAudioSourceSignal(AudioSource__DTV);
         break;*/

      case TUNER_TA_FM:
         _guiService.sendActivateAudioSourceSignal(AudioSource__FM_TA);
         break;

      case TUNER_TA_DAB:
         _guiService.sendActivateAudioSourceSignal(AudioSource__DAB_TA);
         break;

      case TUNER_XM:
         _guiService.sendActivateAudioSourceSignal(AudioSource__XM);
         break;

      case SXM_NEWS:
         _guiService.sendActivateAudioSourceSignal(AudioSource__XM_NEWS);
         break;

      case TUNER_TI_AM:
         _guiService.sendActivateAudioSourceSignal(AudioSource__AM_TI);
         break;

      default:
         break;
   }
}
