/**************************************************************************//**
 * \file       clSDS_Method_CommonRestoreHMIList.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_CommonRestoreHMIList_h
#define clSDS_Method_CommonRestoreHMIList_h

#include "external/sds2hmi_fi.h"
#include "Sds2HmiServer/framework/clServerMethod.h"
#include "application/RestoreHMIListObserver.h"
#

class RestoreHMIList;
class clSDS_POIList;
class QuickChargingStation;

class clSDS_Method_CommonRestoreHMIList
   : public clServerMethod
   , public RestoreHMIListObserver
{
   public:
      virtual ~clSDS_Method_CommonRestoreHMIList();
      clSDS_Method_CommonRestoreHMIList(
         ahl_tclBaseOneThreadService* pService
         , clSDS_POIList* pPOIList
         , QuickChargingStation* pQuickChargingStation);

   private:
      virtual void vMethodStart(amt_tclServiceData* pInMsg);
      void handleHMIListType(sds2hmi_fi_tcl_e8_HMI_ListType::tenType enListType);
      void addHMIListTypes(sds2hmi_fi_tcl_e8_HMI_ListType::tenType, RestoreHMIList*);
      std::map<sds2hmi_fi_tcl_e8_HMI_ListType::tenType, RestoreHMIList*> _oHMIListMap;
      clSDS_POIList* _pPOIList;
      QuickChargingStation* _pQuickChargingStation;
      virtual void hmiListRestored(RestoreHMIList* pRestoreHMIList);
};


#endif
