/**************************************************************************//**
 * \file       clSDS_Method_CommonGetHmiElementDescription.cpp
 *
 * clSDS_Method_CommonGetHmiElementDescription method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonGetHmiElementDescription.h"
#include "external/sds2hmi_fi.h"
#include "application/clSDS_MenuManager.h"
#include "application/clSDS_ListScreen.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonGetHmiElementDescription.cpp.trc.h"
#endif


/**************************************************************************//**
 * Constructor
 ******************************************************************************/
clSDS_Method_CommonGetHmiElementDescription::clSDS_Method_CommonGetHmiElementDescription(
   ahl_tclBaseOneThreadService* pService,
   clSDS_MenuManager* pMenuManager,
   clSDS_ListScreen* pListScreen)

   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONGETHMIELEMENTDESCRIPTION, pService)
   , _pMenuManager(pMenuManager)
   , _pListScreen(pListScreen)
{
}


/**************************************************************************//**
 * Destructor
 ******************************************************************************/
clSDS_Method_CommonGetHmiElementDescription::~clSDS_Method_CommonGetHmiElementDescription()
{
   _pMenuManager = NULL;
   _pListScreen = NULL;
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_Method_CommonGetHmiElementDescription::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart oMessage;
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult oResult;
   vGetDataFromAmt(pInMessage, oMessage);
   getHmiDescription(oMessage, oResult);
   vSendMethodResult(oResult);
   traceResult(oResult);
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_CommonGetHmiElementDescription::getHmiDescription(
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& oMessage,
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& oResult) const
{
   std::vector<sds2hmi_fi_tcl_HMIElementDescription> descriptorValues;
   if (oMessage.DescriptionMode.enType == sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::FI_EN_DESCR_PROMPT)
   {
      switch (oMessage.ElementReference.enType)
      {
         case sds2hmi_fi_tcl_e8_HMIElementReference::FI_EN_ELEMENT_ONFOCUS :
         {
            if ((_pMenuManager != NULL) && (clSDS_ConfigurationFlags::getPromptOnFocusMovementKey()))
            {
               sds2hmi_fi_tcl_HMIElementDescription oHMIElementDescription;
               oHMIElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_PROMPTID;
               oHMIElementDescription.DescriptorValue  = _pMenuManager->getPromptId().c_str();
               oResult.Description.push_back(oHMIElementDescription);
               if (_pListScreen != NULL)
               {
                  descriptorValues = _pListScreen->getHmiElementDescription(_pMenuManager->getListIndex() + 1);
                  insertDescriptorValues(descriptorValues, oResult);
               }
            }
         }
         break;

         case sds2hmi_fi_tcl_e8_HMIElementReference::FI_EN_ELEMENT_BY_LINENUMBER :
         case sds2hmi_fi_tcl_e8_HMIElementReference::FI_EN_ELEMENT_BY_ID :
         {
            if (_pListScreen != NULL)
            {
               oResult.Description = _pListScreen->getHmiElementDescription(oMessage.HMIId);
            }
         }
         break;

         default :
            break;
      }
   }
   else if (oMessage.DescriptionMode.enType == sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::FI_EN_DESCR_UNKNOWN)
   {
      if (oMessage.ElementReference.enType == sds2hmi_fi_tcl_e8_HMIElementReference::FI_EN_ELEMENT_ONFOCUS)
      {
         if (_pMenuManager != NULL)
         {
            sds2hmi_fi_tcl_HMIElementDescription oHMIElementDescription;
            oHMIElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_UNKNOWN;
            oHMIElementDescription.DescriptorValue  = "";
            oHMIElementDescription.DescriptorId = _pMenuManager->getGrammarIdOfCommand(_pMenuManager->getDefaultFocusIndex());
            oResult.Description.push_back(oHMIElementDescription);
         }
      }
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_CommonGetHmiElementDescription::insertDescriptorValues(
   std::vector<sds2hmi_fi_tcl_HMIElementDescription>  descriptorValues,
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& Result) const
{
   for (size_t it = 0; it < descriptorValues.size(); it++)
   {
      Result.Description.push_back(descriptorValues[it]);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_CommonGetHmiElementDescription::traceResult(
   const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& result) const
{
   for (size_t i = 0; i < result.Description.size(); ++i)
   {
      const sds2hmi_fi_tcl_HMIElementDescription& descr = result.Description[i];
      ETG_TRACE_USR1(("HmiElementDescription: tag=%d : value='%s'", descr.DescriptorTag.enType, descr.DescriptorValue.szValue));
   }
}
