/**************************************************************************//**
 * \file       clSDS_Method_AppsLaunchApplication.cpp
 *
 * clSDS_Method_AppsLaunchApplication method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_AppsLaunchApplication.h"
//#include "application/AppChannelList.h"
#include "SdsAdapter_Trace.h"
#include "application/GuiService.h"

#define VALID_DEVICE_HANDLE_BEGIN 2
#define VALID_DEVICE_HANDLE_END 11

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_AppsLaunchApplication.cpp.trc.h"
#endif


using namespace most_Tel_fi_types_Extended;
using namespace sds_gui_fi::SdsGuiService;


/**************************************************************************//**
 * Destructor
 ******************************************************************************/
clSDS_Method_AppsLaunchApplication::~clSDS_Method_AppsLaunchApplication()
{
}


/**************************************************************************//**
 * Constructor
 ******************************************************************************/
clSDS_Method_AppsLaunchApplication::clSDS_Method_AppsLaunchApplication(
   ahl_tclBaseOneThreadService* pService
   , ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > pSds2TelProxy
   , GuiService& guiService)

   : clServerMethod(SDS2HMI_SDSFI_C_U16_APPSLAUNCHAPPLICATION, pService)
   , _telephoneProxy(pSds2TelProxy)
   , _guiService(guiService)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_Method_AppsLaunchApplication::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);

   ETG_TRACE_USR1(("AppId = %d", oMessage.AppId));
   if (strcmp(oMessage.sAppName, ""))
   {
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_PHONE_CALL_SIRI_VA);
      //_pAppChannelList->sendFullScreenAppRequest(oMessage.AppId);
#endif
   }
   else
   {
      // TODO jnd2hi: remove all members and use proxy members directly
      if ((_telephoneProxy->hasActivePhoneDevice()))
      {
         uint8 deviceHandle = _telephoneProxy->getActivePhoneDevice().getU8DeviceHandle();
         if ((deviceHandle >= VALID_DEVICE_HANDLE_BEGIN) && (deviceHandle <= VALID_DEVICE_HANDLE_END))
         {
            if (_telephoneProxy->hasBTDeviceVoiceRecognitionExtended())
            {
               bool voiceRecSupported = _telephoneProxy->getBTDeviceVoiceRecognitionExtended().getBBTDeviceVoiceRecSupported();
               most_Tel_fi_types_Extended::T_e8_TelSiriAvailabilityState siriStatus = _telephoneProxy->getBTDeviceVoiceRecognitionExtended().getE8SiriAvailabilityState();
               if (voiceRecSupported)
               {
                  _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_PHONE_CALL_SIRI_VA);
                  _telephoneProxy->sendBTDeviceVoiceRecognitionExtendedPureSet(deviceHandle, true);
               }
               else
               {
                  if (siriStatus == T_e8_TelSiriAvailabilityState__e8AVAILABLE_ENABLED)
                  {
                     _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_PHONE_CALL_SIRI_VA);
                     _telephoneProxy->sendBTDeviceVoiceRecognitionExtendedPureSet(deviceHandle, true);
                  }
                  // TODO jnd2hi: is it really correct to send true/false one after the other
                  _telephoneProxy->sendBTDeviceVoiceRecognitionExtendedPureSet(deviceHandle, false);
               }
            }
         }
      }
   }
   // Error message not defined in SDS for launching VA or Siri use cases
   //session ends with confirmation message
   vSendMethodResult();
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_AppsLaunchApplication::onAvailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _telephoneProxy)
   {
      _telephoneProxy->sendBTDeviceVoiceRecognitionExtendedUpReg(*this);
      _telephoneProxy->sendActivePhoneDeviceUpReg(*this);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_AppsLaunchApplication::onUnavailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _telephoneProxy)
   {
      _telephoneProxy->sendBTDeviceVoiceRecognitionExtendedRelUpRegAll();
      _telephoneProxy->sendActivePhoneDeviceRelUpRegAll();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_AppsLaunchApplication::onBTDeviceVoiceRecognitionExtendedStatus(
   const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_Tel_FI::BTDeviceVoiceRecognitionExtendedStatus >& /*status*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_AppsLaunchApplication::onBTDeviceVoiceRecognitionExtendedError(
   const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_Tel_FI::BTDeviceVoiceRecognitionExtendedError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R

/*void clSDS_Method_AppsLaunchApplication::setAppsChannelList(AppChannelList* pAppChannelList)
{
   _pAppChannelList = pAppChannelList;
}*/


#endif


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_AppsLaunchApplication::onActivePhoneDeviceError(
   const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_Tel_FI::ActivePhoneDeviceError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_AppsLaunchApplication::onActivePhoneDeviceStatus(
   const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_Tel_FI::ActivePhoneDeviceStatus >& /*status*/)
{
}
