/**************************************************************************//**uint32
 * \file       clServerMethodTimerHelper.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2018 Robert Bosch GmbH
 *             (C) 2018 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clServerMethodTimerHelper_h
#define clServerMethodTimerHelper_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "asf/core/Timer.h"


class clServerMethodTimerHelper : public ::asf::core::TimerCallbackIF
{
   public:
      clServerMethodTimerHelper(clServerMethod& serverMethod, size_t processingTimeoutMs);
      ~clServerMethodTimerHelper();
      void startProccessingTimer();
      void stopProccessingTimer();
      void scheduleQueuedRequest();

   private:
      /**
       * Called when a timer has expired. Since there are multiple timer instances
       * we need to determine the right instance and take the appropriate action.
       */
      void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

      clServerMethod& _serverMethod;
      asf::ms_t _processingTimeoutMs;
      asf::core::Timer _processingTimer;
      asf::core::Timer _submitTimer;
};


#endif
