/**************************************************************************//**uint32
 * \file       clServerMethod.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016-2018 Robert Bosch GmbH
 *             (C) 2016-2018 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clServerMethod_h
#define clServerMethod_h


#include "Sds2HmiServer/framework/clFunction.h"
#include "Sds2HmiServer/framework/MessageQueue.h"
#include <list>

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "fi_msgfw_if.h"


class clServerMethodTimerHelper;


class clServerMethod : public clFunction
{
   public:
      virtual ~clServerMethod();
      clServerMethod(tU16 u16FunctionID, ahl_tclBaseOneThreadService* pService, size_t processingTimeoutMs = 15000);
      clServerMethod(const clServerMethod&);
      clServerMethod& operator=(const clServerMethod&);
      virtual tVoid vHandleMessage(amt_tclServiceData* pInMsg);
      tVoid vSendMethodResult(const fi_tclTypeBase& oOutData);
      tVoid vSendErrorMessage(tU16 u16ErrorCode);

   protected:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg) = 0;
      tVoid vSendMethodResult();
      /**
       * Can optionally be overridden by the derived class.
       * When overridden by the derived class, the derived class has the option to send
       * an appropriate response by calling vSendMethodResult() or vSendErrorMessage().
       * If the request is still pending when this function returns, the base class
       * will send an error message with 'InternalError'. This is the default behaviour.
       */
      virtual void onRequestTimeout();

   private:
      void queueRequest(amt_tclServiceData* pInMessage);
      amt_tclServiceData* copyMessage(amt_tclServiceData* pMsg);
      void requestWasAnswered();
      void requestTimeout();
      void submitQueuedRequest();
      void submitRequest(amt_tclServiceData* pInMessage);
      void saveResponseParameters(const amt_tclServiceData* pInMessage);

      clServerMethodTimerHelper* _pTimerHelper;
      ::MessageQueue _messageQueue;
      bool _requestPending;
      tU16 _u16DestAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCtr;

      friend clServerMethodTimerHelper;
};


#endif
