/**************************************************************************//**
 * \file       TraceCommandAdapter.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef TraceCommandAdapter_h
#define TraceCommandAdapter_h


#include <string>


class GuiService;
class PopUpService;
class EarlyStartupPlayer;
class clSDS_Method_NaviSetDestinationItem;
class clSDS_Property_NaviCurrentCountryState;
class clSDS_Method_CommonShowDialog;
class clSDS_Display;


class TraceCommandAdapter
{
   public:
      TraceCommandAdapter(); // declare without implementation - for solving LINT warning
      TraceCommandAdapter(
         GuiService* guiService,
         PopUpService* popUpService,
         EarlyStartupPlayer* earlyStartupPlayer,
         clSDS_Method_NaviSetDestinationItem* pMethod_NaviSetDestinationItem,
         clSDS_Property_NaviCurrentCountryState* _pPropertyNaviCurrentCountryState,
         clSDS_Method_CommonShowDialog* pMethodCommonShowDialog,
		 clSDS_Display *pDisplay);
      virtual ~TraceCommandAdapter();

      static void pttShortPress();
      static void testPttShortPress(std::string paramString);
      static void closeView();
      static void startAudio();
      static void stopAudio();
      static void setMicrophoneLevel(unsigned int level);
      static void naviRequest(std::string paramString);
      static void positionInfo();
      static void commandNotProcessed(const unsigned char* data);

   private:
      static GuiService* _pGuiService;
      static PopUpService* _pPopUpService;
      static EarlyStartupPlayer* _pEarlyStartupPlayer;
      static clSDS_Method_NaviSetDestinationItem* _pMethod_NaviSetDestinationItem;
      static clSDS_Property_NaviCurrentCountryState* _pPropertyNaviCurrentCountryState;
      static clSDS_Method_CommonShowDialog* _pMethodCommonShowDialog;
      static clSDS_Display *_pDisplay;
};


#endif
