/**************************************************************************//**
 * \file       Sds2HmiServer.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef Sds2HmiServer_h
#define Sds2HmiServer_h


#include "asf/core/Blob.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "clock_main_fiProxy.h"
#include "CMB_ACR_FIProxy.h"
#include "dabtuner_main_fiProxy.h"
#include "MOST_BTSet_FIProxy.h"
#include "MOST_Msg_FIProxy.h"
#include "MOST_PhonBk_FIProxy.h"
#include "MOST_Tel_FIProxy.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "org/bosch/audproc/serviceProxy.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
//#include "org/bosch/cm/fc_dtv/serverInterfaceProxy.h"
//#include "org/bosch/cm/fc_dtv/serverInterface.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "org/bosch/ecnr/serviceProxy.h"
#include "sds_fm_fi/SdsFmServiceProxy.h"
#include "sds_am_fi/SdsAmServiceProxy.h"
#include "sds_dab_fi/SdsDabServiceProxy.h"
#include "sds_sxm_fi/SdsSxmServiceProxy.h"
#include "sds_app_fi/SdsAppServiceProxy.h"
#include "sds_tv_fi/SdsTvServiceProxy.h"
#include "smartphoneint_main_fiProxy.h"
#include "sxm_audio_main_fiProxy.h"
#include "sxm_canadian_fuel_main_fiProxy.h"
#include "sxm_fuel_main_fiProxy.h"
#include "sxm_movies_main_fiProxy.h"
#include "sxm_parking_main_fiProxy.h"
#include "sxm_phonetics_main_fiProxy.h"
#include "sxm_sports_main_fiProxy.h"
#include "sxm_stocks_main_fiProxy.h"
#include "sxm_tabweather_main_fiProxy.h"
#include "tcu_main_fiProxy.h"
#include "tuner_main_fiProxy.h"
#include "tunermaster_main_fiProxy.h"
#include "tcu_usb_main_fiProxy.h"
#include "VEHICLE_MAIN_FIProxy.h"
#include "bosch/cm/profileProxy.h"
#include "org/genivi/audiomanager/CommandInterfaceProxy.h"
//#include "HVACPIVI_MAIN_FIProxy.h"
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
#include "bosch/cm/ai/hmi/managedapps/ManagedAppsProxy.h"
#endif
#include "Midw_Diagnostics_FIProxy.h"

class AhlApp;
class AhlService;
class AudioSourceHandler;
class EarlyStartupPlayer;
class clSDS_AddressBookList;
class clSDS_AmbigContactList;
class clSDS_AmbigNumberList;
class clSDS_ConfigurationFlags;
class clSDS_ContactNumberList;
class clSDS_Display;
class clSDS_DTMFHandler;
class clSDS_FuelPriceList;
class clSDS_G2P_FactorySettings;
class clSDS_InfoFeedsList;
class clSDS_IsVehicleMoving;
class clSDS_LanguageMediator;
class clSDS_ListScreen;
class clSDS_MenuManager;
class clSDS_MyAppsDataBase;
class clSDS_MyAppsList;
class clSDS_MultipleDestinationsList;
class clSDS_NBestList;
class clSDS_FMNBestList;
class clSDS_FMTemplate;
class clSDS_ParkingList;
class clSDS_NaviListItems;
class NaviPOICategoryList;
class NaviPOIIconsList;
class clSDS_POIList;
class clSDS_PhonebookList;
class clSDS_PreviousDestinationsList;
class clSDS_QuickDialList;
class clSDS_ReadSmsList;
class clSDS_RecentCallsList;
class clSDS_SDSStatus;
class clSDS_SessionControl;
class clSDS_SXMAudioChannelList;
class clSDS_TunerBandRange;
class clSDS_Userwords;
class NdsCountryStateRequestor;
class GuiService;
class InfoShowMenuHandler;
class NaviAddressFormatter;
class UserProfile;
class NaviDetourList;
class QuickChargingStation;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
//class AppChannelList;
#endif
class PhonebookContacts;
class PopUpService;
class SettingsService;
class SdsAudioSource;
class SdsDataHandoverService;
class SdsDiagnosisService;
class SdsFocusService;
class SdsPhoneService;
class SxmDataServices;
class clSDS_FmChannelList;
class clSDS_AmChannelList;
class clSDS_DabChannelList;
class clSDS_CustomSMSList;
class clSDS_FormatTimeDate;
//class clSDS_TVStationList;
class clSDS_Method_AppsLaunchApplication;
class clSDS_Method_CommonGetHmiListDescription;
class clSDS_Method_CommonGetListInfo;
class clSDS_Method_CommonSetActiveApplication;
class clSDS_Method_CommonSetAvailableUserwords;
class clSDS_Method_CommonShowDialog;
class clSDS_Method_ContactsGetAmbiguityList;
class clSDS_Method_MediaGetAmbiguityList;
class clSDS_Method_MediaGetDeviceInfo;
class clSDS_Method_MediaPlay;
class clSDS_Method_NaviSelectDestListEntry;
class clSDS_Method_NaviGetContactListEntries;
class clSDS_Method_NaviSetDestinationItem;
class clSDS_Method_NaviValidateDestinationEntries;
class clSDS_Method_NaviGetWaypointListInfo;
class clSDS_Method_NaviSetDestinationAsWaypoint;
class clSDS_Method_NaviSetMapMode;
class clSDS_Method_NaviGetSearchLocation;
class clSDS_Method_PhoneDialNumber;
class clSDS_Method_PhoneDialContact;
class clSDS_Method_PhoneGetContactListEntries;
class clSDS_Method_PhoneSelectPhone;
class clSDS_Method_PhoneSendDTMFDigits;
class clSDS_Method_PhoneSetPhoneSetting;
class clSDS_Method_PhoneStartPairing;
class clSDS_Method_PhoneRedialLastNumber;
class clSDS_Method_PhoneUpdatePhonebook;
class clSDS_Method_TextMsgCallbackSender;
class clSDS_Method_TextMsgGetContent;
class clSDS_Method_TextMsgGetInfo;
class clSDS_Method_TextMsgSelectMessage;
class clSDS_Method_TextMsgSend;
class clSDS_Method_TextMsgSetContent;
class clSDS_Method_TextMsgSetNumber;
class clSDS_Method_TunerSelectBandMemBank;
class clSDS_Method_TunerSelectStation;
class clSDS_Method_CommonRestoreHMIList;
class clSDS_Method_VDLGetDatabases;
//class clSDS_Method_TVSelectStation;
class clSDS_Method_InfoShowMenu;
class clSDS_Property_Audio_ECNR_EngineParameter;
class clSDS_Method_NavDataGetCountryStateList;
class clSDS_Method_NavDataGetStreetAvailability;
class clSDS_Method_NavDataGetStringAndPhoneme;
class clSDS_Property_AudioECNR_ASR_ModeStatus;
class clSDS_Property_CommonActionRequest;
class clSDS_Property_CommonCoreSpeechParameters;
class clSDS_Property_CommonSDSConfiguration_Dyna;
class clSDS_Property_CommonSDSConfiguration_Stat;
class clSDS_Property_CommonSettingsRequest;
class clSDS_Property_CommonStatus;
class clSDS_Property_ConnectedDeviceStatus;
class clSDS_Property_InfoServiceStatus;
class clSDS_Property_MediaStatus;
class clSDS_Property_NavDataDataSetInfo;
class clSDS_Method_NavDataRegisterDirectNDSUse;
class clSDS_Method_NavDataUnRegisterDirectNDSUse;
class clSDS_Method_NavDataAccessModeChanged;
class clSDS_Property_NaviCurrentCountryState;
class clSDS_Property_NaviStatus;
class clSDS_Property_PhoneStatus;
class clSDS_Property_SpecialAppStatus;
class clSDS_Property_TextMsgStatus;
class clSDS_Property_TunerStatus;
class clSDS_Property_VDLStatus;
class clSDS_Method_PhoneSwitchCall;
class TraceCommandAdapter;
class AcrHandler;
class NaviVoiceTagHandler;
class SystemVoiceSettings;
class CountryNameRequestor;
class StateNameRequestor;
class NaviHapticHandOverInterface;
class DataHandoverHandler;
class VariantLayoutMap;
class NaviHapticHandOverList;
class NdsStringRequestor;
class NdsPhonemeRequestor;
class NdsCountryStateRequestor;
class clSDS_Method_NaviStartDistanceDetour;
class clSDS_Method_NaviCancelDistanceDetour;
class clSDS_QuickDialRelationshipUpdater;
class clSDS_Property_NaviPOIIconList;
class DiagnosticsClientHandler;

class Sds2HmiServer : public asf::core::ServiceAvailableIF
{
   public:
      Sds2HmiServer();
      Sds2HmiServer(const Sds2HmiServer& rhs); // not implemented!
      virtual ~Sds2HmiServer();
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange) ;
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange) ;
      Sds2HmiServer& operator=(const Sds2HmiServer& rhs); // not implemented!

   private:
      void buildRegistry() const;
      AhlService* createSds2HmiService(AhlApp* ahlApp);
      void addServiceAvailableDelegate(asf::core::ServiceAvailableIF* obs);
      void registerServiceAvailableDelegates();
      void createproxies();
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      void createRenaultSpecificProxies();
#endif

      AhlApp* _pAhlApp;
      AhlService* _pSds2HmiService;
      AudioSourceHandler* _pAudioSourceHandler;
      clSDS_AddressBookList* _pAddressBookList;
      clSDS_AmbigContactList* _pAmbigContactList;
      clSDS_AmbigNumberList* _pAmbigNumberList;
      clSDS_ConfigurationFlags* _pConfigFlags;
      clSDS_ContactNumberList* _pContactNumberList;
      clSDS_CustomSMSList* _pCustomSMSList;
      clSDS_Display* _pDisplay;
      clSDS_DTMFHandler* _pDTMFHandler;
      EarlyStartupPlayer* _pEarlyStartupPlayer;
      clSDS_FmChannelList* _pFmChannelList;
      clSDS_AmChannelList* _pAmChannelList;
      clSDS_DabChannelList* _pDabChannelList;
      clSDS_FormatTimeDate* _pFormatTimeDate;
      clSDS_FuelPriceList* _pFuelPriceList;
      clSDS_G2P_FactorySettings* _pG2P_FactorySetttings;
      clSDS_InfoFeedsList* _pInfoFeedsList;
      clSDS_IsVehicleMoving* _pIsVehicleMoving;
      clSDS_LanguageMediator* _pLanguageMediator;
      clSDS_ListScreen* _pListScreen;
      clSDS_MenuManager* _pMenuManager;
      clSDS_MultipleDestinationsList* _pMultipleDestinationList;
      clSDS_MyAppsDataBase* _pMyAppsDataBase;
      clSDS_NaviListItems* _pNaviListItems;
      NaviPOICategoryList* _pNaviPOICategoryList;
      NaviPOIIconsList* _pNaviPOIIconsList;
      clSDS_NBestList* _pNBestList;
      clSDS_FMNBestList* _pFMNBestList;
      clSDS_FMTemplate* _pFMTemplate;
      clSDS_ParkingList* _pParkingList;
      clSDS_PhonebookList* _pPhonebookList;
      clSDS_POIList* _pPOIList;
      clSDS_PreviousDestinationsList* _pPreviousDestinationsList;
      clSDS_QuickDialList* _pQuickDialList;
      clSDS_QuickDialRelationshipUpdater* _pQuickDialLisRelationshipUpdater;
      clSDS_ReadSmsList* _pReadSmsList;
      clSDS_RecentCallsList* _pRecentCallsList;
      clSDS_SDSStatus* _pSDSStatus;
      clSDS_SessionControl* _pSessionControl;
      clSDS_SXMAudioChannelList* _pSxmAudioChannelList;
      clSDS_TunerBandRange* _pTunerBandRange;
      //clSDS_TVStationList* _pTVStationList;
      clSDS_Userwords* _pUserwords;
      AcrHandler* _pAcrHandler;
      NaviVoiceTagHandler* _pNaviVoiceTagHandler;
      NdsCountryStateRequestor* _pNdsCountryStateRequestor;
      GuiService* _pGuiService;
      InfoShowMenuHandler* _pInfoShowMenuHandler;
      NaviAddressFormatter* _pNaviAddressFormatter;
      NaviDetourList* _pNaviDetourList;
      PhonebookContacts* _pPhonebookContacts;
      PopUpService* _pPopUpService;
      SdsAudioSource* _pSdsAudioSource;
      SdsDataHandoverService* _pSdsDataHandoverService;
      SdsDiagnosisService* _pSdsDiagnosisService;
      SdsFocusService* _pSdsFocusService;
      SdsPhoneService* _pSdsPhoneService;
      SettingsService* _pSettingsService;
      SxmDataServices* _pSxmDataSevices;
      TraceCommandAdapter* _pTraceCommandAdapter;
      SystemVoiceSettings* _pVoiceSetting;
      CountryNameRequestor* _pCountryNameRequestor;
      StateNameRequestor* _pStateNameRequestor;
      DataHandoverHandler* _pDataHandoverHandler;
      VariantLayoutMap* _pVariantLayoutMap;
      NdsStringRequestor* _pNdsStringRequestor;
      NdsPhonemeRequestor* _pNdsPhonemeRequestor;
      QuickChargingStation* _pQuickChargingStation;
      clSDS_Method_AppsLaunchApplication* _pMethodAppsLaunchApplication;
      clSDS_Method_CommonGetHmiListDescription* _pMethodCommonGetHmiListDescription;
      clSDS_Method_CommonGetListInfo* _pMethodCommonGetListInfo;
      clSDS_Method_CommonSetActiveApplication* _pMethodCommonSetActiveApplication;
      clSDS_Method_CommonSetAvailableUserwords* _pMethodCommonSetAvailableUserwords;
      clSDS_Method_CommonShowDialog* _pMethodCommonShowDialog;
      clSDS_Method_ContactsGetAmbiguityList* _pMethodContactsGetAmbiguityList;
      clSDS_Method_MediaGetAmbiguityList* _pMethodMediaGetAmbiguityList;
      clSDS_Method_MediaGetDeviceInfo* _pMethodMediaGetDeviceInfo;
      clSDS_Method_MediaPlay* _pMethodMediaPlay;
      clSDS_Method_NavDataRegisterDirectNDSUse* _pMethodNavDataRegisterDirectNDSUse;
      clSDS_Method_NavDataUnRegisterDirectNDSUse* _pMethodNavDataUnRegisterDirectNDSUse;
      clSDS_Method_NavDataAccessModeChanged* _pMethod_NavDataAccessModeChanged;
      clSDS_Method_NaviGetContactListEntries* _pMethodNaviGetContactListEntries;
      clSDS_Method_NaviGetSearchLocation* _pMethodNaviGetSearchLocation;
      clSDS_Method_NaviGetWaypointListInfo* _pMethodNaviGetWaypointListInfo;
      clSDS_Method_NaviSelectDestListEntry* _pMethodNaviSelectDestListEntry;
      clSDS_Method_NaviSetDestinationAsWaypoint* _pMethodNaviSetDestinationAsWaypoint;
      clSDS_Method_NaviSetDestinationItem* _pMethodNaviSetDestinationItem;
      clSDS_Method_NaviValidateDestinationEntries* _pMethodNaviValidateDestinationEntries;
      clSDS_Method_NaviSetMapMode* _pMethodNaviSetMapMode;
      clSDS_Method_PhoneDialContact* _pMethodPhoneDialContact;
      clSDS_Method_PhoneDialNumber* _pMethodPhoneDialNumber;
      clSDS_Method_PhoneGetContactListEntries* _pMethodPhoneGetContactListEntries;
      clSDS_Method_PhoneRedialLastNumber* _pMethodPhoneRedialLastNumber;
      clSDS_Method_PhoneSelectPhone* _pMethodPhoneSelectPhone;
      clSDS_Method_PhoneSetPhoneSetting* _pMethodPhoneSetPhoneSetting;
      clSDS_Method_PhoneStartPairing* _pMethodPhoneStartPairing;
      clSDS_Method_PhoneSwitchCall* _pMethodPhoneSwitchCall;
      clSDS_Method_PhoneUpdatePhonebook* _pMethodPhoneUpdatePhonebook;
      clSDS_Method_TextMsgCallbackSender* _pMethodTextMsgCallbackSender;
      clSDS_Method_TextMsgGetContent* _pMethodTextMsgGetContent;
      clSDS_Method_TextMsgGetInfo* _pMethodTextMsgGetInfo;
      clSDS_Method_TextMsgSelectMessage* _pMethodTextMsgSelectMessage;
      clSDS_Method_TextMsgSend* _pMethodTextMsgSend;
      clSDS_Method_TextMsgSetContent* _pMethodTextMsgSetContent;
      clSDS_Method_TextMsgSetNumber* _pMethodTextMsgSetNumber;
      clSDS_Method_TunerSelectBandMemBank* _pMethodTunerSelectBandMemBank;
      clSDS_Method_TunerSelectStation* _pMethodTunerSelectStation;
      clSDS_Method_CommonRestoreHMIList* _pMethodCommonRestoreHMIList;
      //clSDS_Method_TVSelectStation* _pMethodTVSelectStation;
      clSDS_Method_VDLGetDatabases* _pMethodVDLGetDatabases;
      clSDS_Property_Audio_ECNR_EngineParameter* _pPropertyAudio_ECNR_EngineParameter;
      clSDS_Method_NavDataGetCountryStateList* _pMethodNavDataGetCountryStateList;
      clSDS_Method_NavDataGetStreetAvailability* _pMethodNavDataGetStreetAvailability;
      clSDS_Method_NavDataGetStringAndPhoneme* _pMethodNavDataGetStringAndPhoneme;
      clSDS_Method_InfoShowMenu* _pMethodInfoShowMenu;
      clSDS_Property_AudioECNR_ASR_ModeStatus* _pPropertyAudioECNRASRModeStatus;
      clSDS_Property_CommonActionRequest* _pPropertyCommonActionRequest;
      clSDS_Property_CommonCoreSpeechParameters* _pPropertyCommonCoreSpeechParameters;
      clSDS_Property_CommonSDSConfiguration_Dyna* _pPropertyCommonSDSConfiguration_Dyna;
      clSDS_Property_CommonSDSConfiguration_Stat* _pPropertyCommonSDSConfiguration_Stat;
      clSDS_Property_CommonSettingsRequest* _pPropertyCommonSettingsRequest;
      clSDS_Property_CommonStatus* _pPropertyCommonStatus;
      clSDS_Property_ConnectedDeviceStatus* _pPropertyConnectedDeviceStatus;
      clSDS_Property_InfoServiceStatus* _pPropertyInfoServiceStatus;
      clSDS_Property_MediaStatus* _pPropertyMediaStatus;
      clSDS_Property_NavDataDataSetInfo* _pPropertyNavDataDataSetInfo;
      clSDS_Property_NaviCurrentCountryState* _pPropertyNaviCurrentCountryState;
      clSDS_Property_NaviStatus* _pPropertyNaviStatus;
      clSDS_Property_PhoneStatus* _pPropertyPhoneStatus;
      clSDS_Property_SpecialAppStatus* _pPropertySpecialAppStatus;
      clSDS_Property_TextMsgStatus* _pPropertyTextMsgStatus;
      clSDS_Property_TunerStatus* _pPropertyTunerStatus;
      clSDS_Property_VDLStatus* _pPropertyVDLStatus;
      NaviHapticHandOverInterface* _pNaviHapticHandOverInterface;
      NaviHapticHandOverList* _pNaviHapticHandOverList;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      // AppChannelList* _pAppChannelList;
#endif
      UserProfile* _pUserProfile;
      clSDS_Method_NaviStartDistanceDetour* _pNaviStartDistanceDetour;
      clSDS_Method_NaviCancelDistanceDetour* _pNaviCancelDistanceDetour;
      clSDS_Property_NaviPOIIconList* _pPropertyNaviPOIIconList;
      DiagnosticsClientHandler* _pDiagnosticsClientHandler;

      boost::shared_ptr< MOST_BTSet_FI::MOST_BTSet_FIProxy > _bluetoothSettingsProxy;
      boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy> _phonebookProxy;
      boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy > _telephoneProxy;
      boost::shared_ptr< MOST_Msg_FI::MOST_Msg_FIProxy > _msgProxy;
      boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy> _mediaPlayerProxy;
      boost::shared_ptr< tcu_main_fi::Tcu_main_fiProxy > _tcuProxy;
      boost::shared_ptr< tuner_main_fi::Tuner_main_fiProxy > _tunerProxy;
      boost::shared_ptr< tunermaster_main_fi::Tunermaster_main_fiProxy > _tunerMasterProxy;
      boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > _vehicleProxy;
      boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioProxy;
      boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy > _sxmCanadianFuelProxy;
      boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy > _sxmFuelProxy;
      boost::shared_ptr< sxm_movies_main_fi::Sxm_movies_main_fiProxy > _sxmMovieProxy;
      boost::shared_ptr< sxm_phonetics_main_fi::Sxm_phonetics_main_fiProxy > _sxmPhoneticsProxy;
      boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy > _sxmParkingProxy;
      boost::shared_ptr< sxm_sports_main_fi::Sxm_sports_main_fiProxy > _sxmSportsProxy;
      boost::shared_ptr< sxm_stocks_main_fi::Sxm_stocks_main_fiProxy > _sxmStocksProxy;
      boost::shared_ptr< sxm_tabweather_main_fi::Sxm_tabweather_main_fiProxy > _sxmTabWeatherProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      boost::shared_ptr< sds_sxm_fi::SdsSxmService::SdsSxmServiceProxy > _sdsSxmProxy;
      boost::shared_ptr< sds_fm_fi::SdsFmService::SdsFmServiceProxy > _sdsFmProxy;
      boost::shared_ptr< sds_am_fi::SdsAmService::SdsAmServiceProxy > _sdsAmProxy;
      boost::shared_ptr< sds_app_fi::SdsAppService::SdsAppServiceProxy> _sdsAppProxy;
      boost::shared_ptr< sds_dab_fi::SdsDabService::SdsDabServiceProxy > _sdsDabProxy;
      boost::shared_ptr< tcu_usb_main_fi::Tcu_usb_main_fiProxy> _tcuUsbMainProxy;
      boost::shared_ptr< sds_tv_fi::SdsTvService::SdsTvServiceProxy > _sdsTvProxy;
      boost::shared_ptr< clock_main_fi::Clock_main_fiProxy > _clockProxy;

      //boost::shared_ptr< org::bosch::cm::fc_dtv::serverInterface::ServerInterfaceProxy> _tvServiceProxy;

      boost::shared_ptr< dabtuner_main_fi::Dabtuner_main_fiProxy > _tunerDabProxy;
      //boost::shared_ptr<MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy> _tunerDabProxy;
      boost::shared_ptr< ::smartphoneint_main_fi::Smartphoneint_main_fiProxy > _smatphoneintProxy;
      boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy > _ecnrProxy;
      boost::shared_ptr< org::bosch::audproc::service::ServiceProxy > _audprocProxy;
      boost::shared_ptr< CMB_ACR_FI::CMB_ACR_FIProxy >_acrProxy;
      boost::shared_ptr< bosch::cm::profile::ProfileProxy > _profileProxy;
      boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy > _commandInterfaceProxy;
      //boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy> _hvacPIVIProxy;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      boost::shared_ptr< bosch::cm::ai::hmi::managedapps::ManagedApps::ManagedAppsProxy > _managedAppsProxy;
#endif
      boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy > _diagnosticProxy;
      std::vector <asf::core::ServiceAvailableIF* > _serviceAvailableDelegates;
};


#endif
