/**************************************************************************//**
* \file     clTunerInterface.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clTunerInterface_h
#define clTunerInterface_h


#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tString.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clTunerInterface
         {
         public:
            virtual ~clTunerInterface(){};
            clTunerInterface(){};
            virtual void vOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice) = 0;
            virtual void vSetTunerState(tuner::common::enSourceId tunerSourceId, tuner::common::enTunerState tunerState, bool bInformSourceChange) = 0;
            virtual void vChangeBand(tuner::common::enBand tunerBand) = 0;
            virtual void vOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState) = 0;
            virtual void vSetFrequency(tuner::common::enBand tunerBand, unsigned int frequency) = 0;
            virtual void vSetModulationAndSrcActivity(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity) = 0;
            virtual void vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone) = 0;
            virtual void vClearAnnouncementStates() = 0;
            virtual void vCancelAnnouncement() = 0;
         };
      }
   }
}

#endif // clTunerInterface_h
