/**************************************************************************//**
* \file     clTunerControl.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clTunerControl_h
#define clTunerControl_h


#include "datatypes/tunerDatatypes.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tMap.h"
#include "datatypes/tString.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
      	 class clTunerInterface;

         class clTunerControl
         {
         public:
            virtual ~clTunerControl();
            static clTunerControl* instance();
            static clTunerControl* m_poTunerControl;
            void vOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
            void vSetTunerState(tuner::common::enTunerState tunerState, tuner::common::enSourceId tunerSourceId, bool bInformSourceChange = false);
            void vChangeBand(tuner::common::enSourceId tunerSourceId, tuner::common::enBand tunerBand);
            void vSetFrequency(tuner::common::enSourceId tunerSourceId, tuner::common::enBand tunerBand, unsigned int frequency);
            void vOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState);
            void vSetTunerImpl(tuner::sessionManagement::audio::clTunerInterface* poImpl, tuner::common::enSourceId tunerSourceId);
            void vSetModulationAndSrcActivity(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
            void vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone );
            void vClearAnnouncementStates(tuner::common::enSourceId tunerSourceId);
            void vCancelAnnouncement(tuner::common::enSourceId tunerSourceId);

         private:
            clTunerControl();
            tunerMap<tuner::common::enSourceId, tuner::sessionManagement::audio::clTunerInterface*> TunerImplMap;
         };
      }
   }
}

#endif // clTunerControl_h
