/**************************************************************************//**
* \file     clTunerControl.cpp
*
*           clTunerControl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "sessionManagement/audio/clTunerControl.h"
#include "sessionManagement/audio/interface/clTunerInterface.h"


using namespace tuner::sessionManagement::audio;
using namespace tuner::common;


clTunerControl* clTunerControl::m_poTunerControl = NULL;
/**************************************************************************//**
* Constructor
******************************************************************************/
clTunerControl::clTunerControl()
{

}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTunerControl::~clTunerControl()
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTunerControl* clTunerControl::instance()
{
	if (m_poTunerControl == 0)
	{
		m_poTunerControl = new clTunerControl();
	}
	return m_poTunerControl;
}


/**************************************************************************//**
* 
******************************************************************************/
void clTunerControl::vSetTunerImpl(tuner::sessionManagement::audio::clTunerInterface* poImpl,tuner::common::enSourceId tunerSourceId)
{
	TunerImplMap[tunerSourceId] = poImpl;
}

/**************************************************************************//**
* 
******************************************************************************/
void clTunerControl::vSetTunerState(tuner::common::enTunerState tunerState, tuner::common::enSourceId tunerSourceId, bool bInformSourceChange)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vSetTunerState(tunerSourceId, tunerState, bInformSourceChange);
	}
}


/**************************************************************************//**
* 
******************************************************************************/
void clTunerControl::vChangeBand(tuner::common::enSourceId tunerSourceId, tuner::common::enBand tunerBand)
{
	if (tunerBand != tuner::common::BANDNONE)
	{
		if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
		{
			TunerImplMap[tunerSourceId]->vChangeBand(tunerBand);
		}
	}
}

void clTunerControl::vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone )
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vOnSrcChangeCompleted(tunerSourceId, bSetBandNone);
	}
}

/**************************************************************************//**
* 
******************************************************************************/
void clTunerControl::vOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vOnAllocate(tunerSourceId, inputDevice);
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clTunerControl::vOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vOnMuteState(tunerSourceId, tunerMuteState);
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clTunerControl::vSetFrequency(tuner::common::enSourceId tunerSourceId, tuner::common::enBand tunerBand, unsigned int frequency)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vSetFrequency(tunerBand, frequency);
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clTunerControl::vSetModulationAndSrcActivity(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vSetModulationAndSrcActivity(tunerSourceId, tunerSrcActivity);
	}
}
/**************************************************************************//**
*
******************************************************************************/
void clTunerControl::vClearAnnouncementStates(tuner::common::enSourceId tunerSourceId)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vClearAnnouncementStates();
	}
}
/**************************************************************************//**
*
******************************************************************************/
void clTunerControl::vCancelAnnouncement(tuner::common::enSourceId tunerSourceId)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vCancelAnnouncement();
	}
}
