/**************************************************************************//**
* \file     clTunerClientServiceState.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clTunerClientServiceState_h
#define clTunerClientServiceState_h


#include "datatypes/tunerDatatypes.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tMap.h"
#include "datatypes/tString.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clTunerClientServiceState
         {
            public:
               clTunerClientServiceState();
               virtual ~clTunerClientServiceState();
               void vReset();
               bool bIsServiceAvailable(tuner::common::enSourceId sourceId);
               bool bIsServiceUnAvailable(tuner::common::enSourceId sourceId);
			   bool bIsServiceUnKnown(tuner::common::enSourceId sourceId);
               void vOnServiceState(tuner::common::enTunerClient tunerClient, tuner::common::enTunerClientAvailability tunerClientAvailability);
               void vStoreRequest(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity);
			   void vStoreRequest(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
               void vClearStoredRequest();
               tuner::common::enSourceId getStoredSource();
			   tuner::common::enSourceId getAllocateStoredSourceId();
			   tunerString getAllocateStoredInputDevice();
               tuner::common::enSrcActivity getStoredSourceActivity();
               void vOnNewTunerState(tuner::common::enTunerClient tunerClient, tuner::common::enTunerState tunerState);
               void vClearTunerState(tuner::common::enTunerClient tunerClient);
               tuner::common::enTunerState oGetCurrentTunerState(tuner::common::enTunerClient tunerClient);
               void vStorePreviousTunerState();
               tuner::common::enTunerState oGetPreviousTunerState(tuner::common::enTunerClient tunerClient);
               void vClearPreviousTunerState();
			   void vClearStoredAllocateRequest();

            private:
               tuner::common::enSourceId storeSourceId;
               tuner::common::enSrcActivity storeSourceActivity;
			   tuner::common::enSourceId allocateStoredSourceId;
			   tunerString allocateStoredInputDevice;
               tunerMap<tuner::common::enSourceId, tuner::common::enTunerClientAvailability> SourceAvailableMap;
               tunerMap<tuner::common::enTunerClient, tuner::common::enTunerState> currentTunerStateMap;
               tunerMap<tuner::common::enTunerClient, tuner::common::enTunerState> previousTunerStateMap;
         };
      }
   }
}

#endif // clTunerClientServiceState_h
