/**************************************************************************//**
* \file     clMuteRequest.cpp
*
*           clMuteRequest method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "sessionManagement/audio/clMuteRequest.h"


using namespace tuner::sessionManagement::audio;
using namespace tuner::common;


/**************************************************************************//**
* Constructor
******************************************************************************/
clMuteRequest::clMuteRequest():
bStoredMuteInterrupt(false)
, storedMuteSourceId(SOURCEID_LIMIT)
,bStoreMuteRequest(false)
, muteSourceId(SOURCEID_LIMIT)
,state(REQUEST_COMPLETED)
,muteState(MUTESTATE_UNKNOWN)
,bBlockSourceChange(false)
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clMuteRequest::~clMuteRequest()
{
}


/**************************************************************************//**
* 
******************************************************************************/
bool clMuteRequest::bIsRequestPending()
{
   if (state == clMuteRequest::REQUEST_PENDING)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clMuteRequest::bIsRequestInProgress()
{
   if (state == clMuteRequest::REQUEST_IN_PROGRESS)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clMuteRequest::bIsRequestCompleted()
{
   if (state == clMuteRequest::REQUEST_COMPLETED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clMuteRequest::bMute()
{
   if (muteState == tuner::common::MUTE)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clMuteRequest::bDeMute()
{
   if (muteState == tuner::common::DEMUTE)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
void clMuteRequest::vReset()
{
	state = REQUEST_COMPLETED;
	muteState = MUTESTATE_UNKNOWN;
	bBlockSourceChange = false;
}

bool clMuteRequest::bIsMuteRequestStored()
{
	return bStoreMuteRequest;
}

bool clMuteRequest::bIsToBeProcessStoredMuteRequest(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity, tuner::common::enBand tunerBand)
{
	if(bStoreMuteRequest)
	{
		if((storedMuteSourceId == tunerSourceId) && (tunerSourceActivity == tuner::common::SRCON || tunerSourceActivity == tuner::common::SRCPAUSE))
		{
			return true;
		}
		/*If source is in PAUSE state before temporary source putting through, forward mute request received after temporary source OFF */
		else if(bIsTemporarySource(tunerSourceId) && (tunerSourceActivity == tuner::common::SRCOFF) && (storedMuteSourceId == oGetTunerSourceId(tunerBand)))
		{
			return true;
		}
		else if((storedMuteSourceId == tunerSourceId) && (tunerSourceActivity == tuner::common::SRCOFF))
		{
			vClearStoredMuteRequest();
			return false;
		}
	}
	return false;
}

void clMuteRequest::vStoreMuteRequest(tuner::common::enSourceId tunerSourceId, bool bInterrupt)
{
	bStoreMuteRequest = true;
	bStoredMuteInterrupt = bInterrupt;
	storedMuteSourceId = tunerSourceId;
}

void clMuteRequest::vClearStoredMuteRequest()
{
	bStoreMuteRequest = false;
	bStoredMuteInterrupt = false;
	storedMuteSourceId = SOURCEID_LIMIT;
}

bool clMuteRequest::oGetStoredMuteInterrupt()
{
	return bStoredMuteInterrupt;
}
tuner::common::enSourceId clMuteRequest::oGetStoredSourceId()
{
	return storedMuteSourceId;
}
