/**************************************************************************//**
* \file     clDirectFrequencyRequest.cpp
*
*           clDirectFrequencyRequest method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "sessionManagement/audio/clDirectFrequencyRequest.h"


using namespace tuner::sessionManagement::audio;
using namespace tuner::common;


/**************************************************************************//**
* Constructor
******************************************************************************/
clDirectFrequencyRequest::clDirectFrequencyRequest():
state(REQUEST_COMPLETED)
, frequency(0)
, sourceId(SOURCEID_LIMIT)
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clDirectFrequencyRequest::~clDirectFrequencyRequest()
{
}


/**************************************************************************//**
* 
******************************************************************************/
bool clDirectFrequencyRequest::bIsRequestPending()
{
   if (state == clDirectFrequencyRequest::REQUEST_PENDING)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clDirectFrequencyRequest::bIsRequestInProgress()
{
   if (state == clDirectFrequencyRequest::REQUEST_IN_PROGRESS)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clDirectFrequencyRequest::bIsRequestCompleted()
{
   if (state == clDirectFrequencyRequest::REQUEST_COMPLETED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
void clDirectFrequencyRequest::vReset()
{
	state = REQUEST_COMPLETED;
	frequency = 0;
	sourceId = SOURCEID_LIMIT;
}
