/**************************************************************************//**
* \file     clAudioSession.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clAudioSession_h
#define clAudioSession_h


#include "datatypes/tunerDatatypes.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "sessionManagement/audio/clTunerControl.h"
#include "sessionManagement/audio/clAudioControl.h"
#include "sessionManagement/audio/clAudioSessionState.h"
#include "sessionManagement/audio/clTunerClientServiceState.h"
#include "sessionManagement/audio/clDirectFrequencyRequest.h"
#include "sessionManagement/audio/clMuteRequest.h"
#include "datatypes/tString.h"
#include "datatypes/tMap.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define MAX_SESSIONMANAGEMENT_TIMER_EXPIRY_COUNT 0x02
#define USR1_SWITCHED_TOFG 0x01
#define TA_SWITCHED_TOFG  0x02
#define PTY_SWITCHED_TOFG 0x08

namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clAudioSession
         {
         public:
            virtual ~clAudioSession();
            static tuner::sessionManagement::audio::clAudioSession* instance();
            static void deleteInstance();
            bool bOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
            bool bOnDeAllocate(tuner::common::enSourceId tunerSourceId); 
            bool bOnSrcActivity(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
            void vRequestMute(tuner::common::enMuteState bMute, bool bInterrupt, tuner::common::enSourceId tunerSourceId);

            void vInit();
            void vDeInit();

            void vOnDirectFrequency(tuner::common::enSourceId tunerSourceId, unsigned int directFrequency);
            void vOnDirectFrequencyResult();
            virtual void vOnNewTunerState(tuner::common::enTunerState tunerState, tuner::common::enSourceId tunerSourceId);
            virtual void vOnNewTunerState(tuner::common::enTunerState tunerState, tuner::common::enTunerClient tunerClient, unsigned char audioSink);
            void vOnNewTunerBand(tuner::common::enBand tunerBand);
            bool bOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState);
            void vOnServiceState(tuner::common::enTunerClient tunerClient, tuner::common::enTunerClientAvailability tunerClientAvailable);
            bool bIsServiceUnAvailable(tuner::common::enSourceId tunerSourceId);
            tuner::common::enSourceId getStoredPreviousSessionStateBeforeAnnoucementSrc();
            tuner::common::enSrcActivity getStoredPreviousSessionStateBeforeAnnoucementSrcActivity();
            tuner::common::enSourceId getRequestedSessionSrc();
            tuner::common::enSrcActivity getRequestedSessionSrcActivity();
            tuner::common::enSessionState getRequestedSessionState();
            tuner::common::enTunerState getActiveTunerState(tuner::common::enTunerClient tunerClient);
            void vOnNewDabTunerState(tuner::common::enTunerState tunerState);
            void vInformSourceAvailability(tuner::common::enSourceId tunerSourceId,tuner::common::enAudioSrcAvailability,tuner::common::enAudioSourceAvailabiltyReason);
            tuner::common::enBand oGetActiveTunerBand();
			/*Start FG BG learn Forever changes */
            void vBGorFGLearnForever(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
            void vFGBGLearnForever(bool bBGorFGLearnForever);
            bool bIsBGorFGLearnForever(tuner::common::enSourceId tunerSourceId);
            void vTunerSetFGBGLearnForever(tuner::common::enSourceId tunerSourceId, bool bSupport);
			/*Start FG BG learn Forever changes */

            static tuner::sessionManagement::audio::clAudioSession* m_poSession;
            static unsigned char timerExpiryCount;
            static void vOnTimerExpiry();
			void vSetSBRVariant(bool bSBRVariant);

         private:
            clAudioSession();
            void vSynchronize();
			void vSynchronizeOnSrcChangeAllowed();
			void vSynchronizeOnMuteRequestPending();
			void vSynchronizeOnNoActiveSource();
			void vSynchronizeOnServiceStateUnAvailable(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
			void vSynchronizeOnServiceStateAvailable(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
			void vSynchronizeOnServiceStateUnAvailable(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
			void vSynchronizeOnServiceStateAvailable(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
            bool bIsNewSrcRequested();
            bool bProcessSrcChange();
            void vStartSrcChange();
            bool bIsErrorState();
            void vOnError();
            bool bIsStateChangeRequired();
            void vStartStateChange();
            bool bIsRequestCompleted();
            void vSetActiveState();
            void vActivateTunerSource();
            void vOnAllocate();
            void vOnNewStateRequested();
            void vOnNewSrcactivity();
            void vOnSrcChangeCompleted();
            void vStartTimer();
            void vStopTimer();
            void vResetActiveSession();
            void vResetAllSessionOnServiceStateUnAvailable();
            void vPrintSessionInformation();
            void vOnNewTunerStateForNormalSources();
            void vOnNewTunerStateForTemporarySources();
            bool bIsBandChangeResultPending();
            void vSetDirectFrequency();
            bool bProcessDirectFrequencyChange();
            bool bIsMuteRequestPending();
            bool bSendResponseDuringSrcChange();
            void vSendMuteResult();
            void vRequestMute(tuner::common::enSourceId sourceId);
            tuner::common::enTunerState oUpdateTunerStatus();
            void vUpdateTunerState(tuner::common::enTunerState tunerState, tuner::common::enTunerClient tunerClient, unsigned char audioSink);
            bool bIsTemporarySourceActivityOffRequest();
            bool bIsTemporarySourceActivityOffRequest(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
            bool bIsTemporarySourceActive();
            void vProcessStoredMuteRequest(tuner::common::enSourceId tunerSourceId, bool bInterrupt);
            bool bIsPreviousTunerStateForeGround(tuner::common::enSourceId tunerSourceId);
            bool bIsDirectFrequencyRequestToBeProcessed();
			bool bIsSrcActivityCompleted(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
			bool bIsPauseActivity();
			bool bIsOnOrPauseActivityInProgress();
			void vHandleClearStoredRequest(bool bIsClearStoredData);
			void vHandleClearStoredRequest(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
			void vHandleStoreRequest();
			void vHandleAcknowledgeToArl();
			void vSendDemuteRequest();
			bool bIsProperTunerStateReceived(tuner::common::enTunerState tunerState, tuner::common::enTunerState previousTunerState, unsigned char audioSink);
			void vStorePreviousSessionStateBeforeAnnoucement();
            tuner::sessionManagement::audio::clAudioSessionState activeSession;
            tuner::sessionManagement::audio::clAudioSessionState requestedSession;
            tuner::sessionManagement::audio::clAudioSessionState previousSessionAfterAnnouncement;
            tuner::sessionManagement::audio::clDirectFrequencyRequest directFrequencyRequest;
            tuner::sessionManagement::audio::clMuteRequest muteRequest;
            tuner::sessionManagement::audio::clTunerControl* tunerControl;
            tuner::sessionManagement::audio::clAudioControl audioControl;
            tuner::sessionManagement::audio::clTunerClientServiceState tunerClientServiceState;
            /*Start FG BG learn Forever changes */
            bool bFGBGLearnForNonRadioSource;
            tuner::common::enTunerState DABPreviousState;
            tunerMap<tuner::common::enSourceId, bool> FGorBGLearForeverStatus;
            /*End FG BG learn  Forever changes */
            OSAL_tTimerHandle  timer;
			bool m_bIsSBRVariant = false;
         };
      }
   }
}

#endif // clAudioSession_h
