/**************************************************************************//**
* \file     clAudioControl.cpp
*
*           clAudioControl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "sessionManagement/audio/clAudioControl.h"
#include "sessionManagement/audio/interface/clAudioInterface.h"

static tuner::sessionManagement::audio::clAudioInterface* m_poAudio;

using namespace tuner::sessionManagement::audio;

/**************************************************************************//**
* Constructor
******************************************************************************/
clAudioControl::clAudioControl()
{

}


/**************************************************************************//**
* Destructor
******************************************************************************/
clAudioControl::~clAudioControl()
{
}


/**************************************************************************//**
* 
******************************************************************************/
void clAudioControl::vSetAudioImpl(tuner::sessionManagement::audio::clAudioInterface* poImpl)
{
   m_poAudio = poImpl;
}


/**************************************************************************//**
* 
******************************************************************************/
void clAudioControl::vInformSourceAvailability(tuner::common::enSourceId tunerSourceId,
		tuner::common::enAudioSrcAvailability AudioSrcAvailability ,tuner::common::enAudioSourceAvailabiltyReason AudioSourceAvailabiltyReason)
{
   if (0 != m_poAudio)
   {
      m_poAudio->vSetSrcAvailable(tunerSourceId, AudioSrcAvailability,AudioSourceAvailabiltyReason);
   }
}


/**************************************************************************//**
* 
******************************************************************************/
void clAudioControl::vSendSrcChangeResult(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity)
{
   if (0 != m_poAudio)
   {
      m_poAudio->vSendSrcChangeResult(tunerSourceId, tunerSourceActivity);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clAudioControl::vRequestMute(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState)
{
   if (0 != m_poAudio)
   {
      m_poAudio->vRequestMute(tunerSourceId, tunerMuteState);
   }
}
