/******************************************************************
*FILE: clConfigDefines.h
*SW-COMPONENT:
*DESCRIPTION:
*COPYRIGHT:  2016 Robert Bosch GmbH
*AUTHOR:auj1kor
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef CLCONFIGMAIN_H_
#define CLCONFIGMAIN_H_

#include "clConfigInterface.h"
#include "datatypes/tMap.h"
#include "datatypes/tString.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define TUN_PRESETLIST_SIZE 61
#define TUN_TAG_SIZE 8
#define TUN_VERSION_SIZE 3
#define TUN_DAB_MATRIX_SIZE 112
#define TUN_DAB_TSU_MATRIX_SIZE 32
#define TUN_DAB_LABEL_SIZE 16
#define TUN_DAB_ARRAY_STARTBYTE 15



struct stTunerKDSConfig
{
  tunerString oParameterSet;
  tunerString oConfigType;
  int oByte;
  int oSize;
  tU8 oBitMaskAND;
  tU8 oBitMaskRightShift;
  tU8 oCompareVal;
  tU32 oDefaultValue;
};

struct stTunerFreqStepSize
{
	tU8 	oCountryZone;
	tU32 	oLowFM;
	tU32 	oHighFM;
	tU8  	oStepSizeFM;
	tU8  	oStepSizeManualFM;
	tU32 	oLowMW;
	tU32 	oHighMW;
	tU8  	oStepSizeMW;
	tU8  	oStepSizeManualMW;
	tU32 	oLowLW;
	tU32 	oHighLW;
	tU8  	oStepSizeLW;
	tU8  	oStepSizeManualLW;
};

struct stTunerFSSeekLevel
{
	tU8  	oSeekSensitivitybit;
	tU8  	oSeekSensitivityFMRDS;
	tU8  	oSeekSensitivityFMNONRDS;
	tU8  	oSeekSensitivityMW;
	tU8  	oSeekSensitivityLW;
};

struct stTunerAdrFmDeemphasis
{
	tU8 	oCountryZone;
	tU8 	oAdrFmDeemphasis;
};


struct stCHRYReceptionParameter1
{
	tU8 	oCountryZone;
	tU8 	oADRFmChannelSeparation;
	tU8 	oADRFmLimiting;
	tU8 	oADRFmMultipath;
	tU8 	oADRFmHighCut;
	tU8 	oADRFmSoftMute;
	tU8 	oADRAmSoftMute;
	tU8 	oADRFmDeemphasis;
	tU8 	oADRFmFrequencyResponse;
	tU8 	oADRAmFrequencyResponse;
	tU8 	oADRFmMisc;
	tU8 	oADRAmMisc;
	tU8 	oADRFmAmplificationLevel;
	tU8 	oADRAmAmplificationLevel;
	tU8 	oADRAM_Hicut_Configuration;
	tU8 	oADRAMDeemphasis;
	tU8     oDMQSwitchAudioTuner1;
};

struct stCHRYReceptionParameter2
{
	tU8 	oCountryZone;
	tU8 	oAMFMHicutExtender;
	tU8 	oFMSoftMuteTiming;
	tU8 	oAMFMMisscellaneous2;
	tU8 	oFMHicutExtenderFieldstrengthThreshold;
	tU8 	oFMHicutExtenderFieldstrengthFilterOffset;
	tU8 	oFMChannelSeperationMaximum;
	tU8 	oFMChannelSeperationTiming;
	tU8 	oFMHicutFieldstrengthThreshold;
	tU8 	oFMHicutTiming;
	tU8 	oFMDMQSensitivity;
	tU8 	oFMDeviationAdaption;
	tU8 	oAMNoiseBlanker228kHzSensitivity;
	tU8 	oAMNoiseBlanker45_6kHzSensitivity;
	tU8 	oAMHicutExtenderFieldstrengthThreshold;
	tU8 	oAMHicutExtenderFieldstrengthFilterOffset;
	tU8 	oFMSharxLimit;
};


class clTunerConfigInterface;

class clConfigMain : public clConfigInterface
{
public:
 clConfigMain();
 virtual ~clConfigMain();
 static clConfigMain* instance();
 static clConfigMain* m_poConfigMain;


 virtual tU32 u32GetConfigData(tunerString sConfigString);
 virtual void vStartKDSRead();
 virtual tenAntennaKDSReadReturn vReadAntennaParameter(tunerVector<tU8> &AntennaPar);
 virtual void vReadAntennaExtSupInfo(tU8 u8Buffer[]);
 virtual tU32 u32GetPreset( tU32 u32Index );
 virtual void vGetVersionID(tChar* pBuffer);
 virtual void vGetTsuMatrixDabFm(tU8 u8TsuMatrixDabFm[]);
 virtual void vGetTsuMatrixFmDab(tU8 u8TsuMatrixFmDab[]);
 virtual void vGetEnsemblelabel(tU8 u8LSMConfig_EnsembleLabel[]);
 virtual void vGetServiceLabel(tU8 u8LSMConfig_ServiceLabel[]);
 virtual void vGetComponentLabel(tU8 u8LSMConfig_ComponentLabel[]);


 void vSetTunerInterfacePtr(clTunerConfigInterface* poclTunerConfigInterface);

private:

 clTunerConfigInterface* m_poclTunerConfigInterface;
 tU32 m_u32PresetList[TUN_PRESETLIST_SIZE];

 /** Parameter set idetification tag ---------------------  0 - 7 byte */
 tChar m_sTag[TUN_TAG_SIZE];
 /** Major(1 byte) and Minor(2 byte) Version -------------	 8 - 10 byte */
 tChar m_sVersion[TUN_VERSION_SIZE];

 tChar m_sDabTag[TUN_TAG_SIZE];
 tChar m_sDabVersion[TUN_VERSION_SIZE];

 bool m_bPresetUpdate;

 tU8 m_u8DabMatrix[TUN_DAB_MATRIX_SIZE];

 void vUpdateMapKDSConfig(int u32index ,tU8* value);
 void vUpdateMapDabParameterSet(int u32index ,tU8* value);
 void vUpdateAvailableBandsFromEOL();
 void vUpdateFrequency_StepSizeFromEOL();
 void vUpdateFieldStrengthSeekLevelFromEOL();
 void vUpdateFromEOLParameterSet();
 void vUpdateDABAvailSystemConfiguration();
 void vUpdateDABAvailRadioNumConfiguration();
 void vUpdatePresetList();
 void vUpdateAdr_FmDeemphasis();
 void vHandleTTFisCommands(tU8 u8Commandtype, tU8 u8TunParameterSet);
 void vHandleCommand(tU8 u8Commandtype,int u32Index,tU8* value);
 void vHandle_RDS_AF_Switch(int u8CountryCode);
 void vReadDabParameterSet();
  void vReadCodingData();
  void vUpdatePIIgnoreAccordingToCountry();
  void vUpdateDRMAvailability();
  tU8 u8ReadAntennaPowerSupInfo(const tChar* strConfigItem);
 
 tunerMap<tunerString, tU32> TunerKDSConfigMap;
};

#endif /* CLCONFIGMAIN_H_ */
