/*
 * clConfigMain.cpp
 *
 *  Created on: Oct 20, 2015
 *      Author: auj1kor
 */

#include "clConfigMain.h"
#include "clTunerConfigInterface.h"
#include "clConfigDefines.h"
#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
   #define DP_S_IMPORT_INTERFACE_FI
   #include "dp_generic_if.h"
#else
   #include"diaglib_if.h"
#endif
#include "common/tuner_trace.h"

#define TUN_CONFIG_GET_U32(pu8) ((tU32)(((tU32)((pu8)[0])<<24) + ((tU32)((pu8)[1])<<16) + ((tU32)((pu8)[2])<<8) + (pu8)[3]))
#define TUN_CONFIG_GET_U16(pu8) ((tU16)(((tU16)((pu8)[0])<<8) + (pu8)[1]))
#define TUN_ANTENNAPAR_STARTING_UNUSED_BYTES_COUNT 10
#define TUN_ANTENNAPAR_EACH_ANTENNA_PARAM_COUNT 20
#define TUN_ANTENNAPAR_EACH_ANTENNA2_RESERVED_BYTE_COUNT 6
clConfigMain* clConfigMain::m_poConfigMain = NULL;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_KDSCONFIG
#include "trcGenProj/Header/clConfigMain.cpp.trc.h"
#endif

static const stTunerKDSConfig aTunerKDSConfig[] =
{
   #define TUNER_KDSCONFIG_MAP(ParameterSet, ConfigType, Byte, Size, BitMaskAND, BitMaskRightShift, CompareVal, DefaultValue)                  { ParameterSet, ConfigType, Byte, Size, BitMaskAND, BitMaskRightShift, CompareVal, DefaultValue},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_MAP
};

static const stTunerKDSConfig aTunerDABParameterSet[] =
{
   #define TUNER_KDSCONFIG_DAB_PARAMETERSET(ParameterSet, ConfigType, Byte, Size, BitMaskAND, BitMaskRightShift, CompareVal, DefaultValue)                  { ParameterSet, ConfigType, Byte, Size, BitMaskAND, BitMaskRightShift, CompareVal, DefaultValue},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_DAB_PARAMETERSET
};


static const stTunerFreqStepSize aTunerFreqStepSize[] =
{
   #define TUNER_KDSCONFIG_FREQ_STEPSIZE(CountryZone, LowFM, HighFM, StepSizeFM, ManualStepSizeFM, LowMW, HighMW, StepSizeMW, ManualStepSizeMW, LowLW, HighLW, StepSizeLW, ManualStepSizeLW) { CountryZone, LowFM, HighFM, StepSizeFM, ManualStepSizeFM, LowMW, HighMW, StepSizeMW, ManualStepSizeMW, LowLW, HighLW, StepSizeLW, ManualStepSizeLW},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_FREQ_STEPSIZE
};



static const stTunerFreqStepSize aTunerFreqStepSizeExt[] =
{
   #define TUNER_KDSCONFIG_FREQ_STEPSIZE_EXT(CountryZone, LowFM, HighFM, StepSizeFM, ManualStepSizeFM, LowMW, HighMW, StepSizeMW, ManualStepSizeMW, LowLW, HighLW, StepSizeLW, ManualStepSizeLW) { CountryZone, LowFM, HighFM, StepSizeFM, ManualStepSizeFM, LowMW, HighMW, StepSizeMW, ManualStepSizeMW, LowLW, HighLW, StepSizeLW, ManualStepSizeLW},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_FREQ_STEPSIZE_EXT
};


static const stTunerFSSeekLevel aTunerFSSeekLevel[] =
{
   #define TUNER_KDSCONFIG_FS_SEEKLEVEL(SeekSensitivityBitVal, SeekSensitivityFMRDS, SeekSensitivityFMNONRDS, SeekSensitivityMW, SeekSensitivityLW) { SeekSensitivityBitVal, SeekSensitivityFMRDS, SeekSensitivityFMNONRDS, SeekSensitivityMW, SeekSensitivityLW},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_FS_SEEKLEVEL
};



static const stTunerAdrFmDeemphasis aTunerAdrFmDeemphasis[] =
{
   #define TUNER_KDSCONFIG_ADR_FM_DEEMPHASIS(CountryZone, AdrFmDeemphasis){ CountryZone, AdrFmDeemphasis},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_ADR_FM_DEEMPHASIS
};

static const stCHRYReceptionParameter1 aCHRYReceptionParameter1[] =
{
   #define TUNER_KDSCONFIG_CHRY_PARAMETER_1(CountryZone, \
ADRFmChannelSeparation, \
ADRFmLimiting, \
ADRFmMultipath, \
ADRFmHighCut, \
ADRFmSoftMute, \
ADRAmSoftMute, \
ADRFmDeemphasis, \
ADRFmFrequencyResponse, \
ADRAmFrequencyResponse, \
ADRFmMisc, \
ADRAmMisc, \
ADRFmAmplificationLevel, \
ADRAmAmplificationLevel, \
ADRAM_Hicut_Configuration, \
ADRAMDeemphasis, \
DMQSwitchAudioTuner1)  {CountryZone, \
ADRFmChannelSeparation, \
ADRFmLimiting, \
ADRFmMultipath, \
ADRFmHighCut, \
ADRFmSoftMute, \
ADRAmSoftMute, \
ADRFmDeemphasis, \
ADRFmFrequencyResponse, \
ADRAmFrequencyResponse, \
ADRFmMisc, \
ADRAmMisc, \
ADRFmAmplificationLevel, \
ADRAmAmplificationLevel, \
ADRAM_Hicut_Configuration, \
ADRAMDeemphasis, \
DMQSwitchAudioTuner1},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_CHRY_PARAMETER_1
};


static const stCHRYReceptionParameter2 aCHRYReceptionParameter2[] =
{
   #define TUNER_KDSCONFIG_CHRY_PARAMETER_2(CountryZone, \
AMFMHicutExtender, \
FMSoftMuteTiming, \
AMFMMisscellaneous2, \
FMHicutExtenderFieldstrengthThreshold, \
FMHicutExtenderFieldstrengthFilterOffset, \
FMChannelSeperationMaximum, \
FMChannelSeperationTiming, \
FMHicutFieldstrengthThreshold, \
FMHicutTiming, \
FMDMQSensitivity, \
FMDeviationAdaption, \
AMNoiseBlanker228kHzSensitivity, \
AMNoiseBlanker45_6kHzSensitivity, \
AMHicutExtenderFieldstrengthThreshold, \
AMHicutExtenderFieldstrengthFilterOffset, \
FMSharxLimit)   {CountryZone, \
AMFMHicutExtender, \
FMSoftMuteTiming, \
AMFMMisscellaneous2, \
FMHicutExtenderFieldstrengthThreshold, \
FMHicutExtenderFieldstrengthFilterOffset, \
FMChannelSeperationMaximum, \
FMChannelSeperationTiming, \
FMHicutFieldstrengthThreshold, \
FMHicutTiming, \
FMDMQSensitivity, \
FMDeviationAdaption, \
AMNoiseBlanker228kHzSensitivity, \
AMNoiseBlanker45_6kHzSensitivity, \
AMHicutExtenderFieldstrengthThreshold, \
AMHicutExtenderFieldstrengthFilterOffset, \
FMSharxLimit},
   #include "tunerkdsConfig.dat"
   #undef TUNER_KDSCONFIG_CHRY_PARAMETER_2
};

#define READ_DRM_MODULATION_BIT 0x80000000
#define DRM_NOT_SUPPORTED 0x00

/**************************************************************************//**
* Constructor
******************************************************************************/
clConfigMain::clConfigMain()
{
	m_bPresetUpdate = false;
	memset(m_sTag, 0,  sizeof(tChar) * TUN_TAG_SIZE);
	memset(m_sVersion, 0,  sizeof(tChar) * TUN_VERSION_SIZE);
	memset(m_u32PresetList, 0,  sizeof(tU32) * TUN_PRESETLIST_SIZE);
	memset(m_sDabTag, 0,  sizeof(tChar) * TUN_TAG_SIZE);
	memset(m_sDabVersion, 0,  sizeof(tChar) * TUN_VERSION_SIZE);
	memset(m_u8DabMatrix, 0,  sizeof(tU8) * TUN_DAB_MATRIX_SIZE);
	m_poclTunerConfigInterface = NULL;
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clConfigMain::~clConfigMain()
{
	m_bPresetUpdate = false;
	memset(m_sTag, 0,  sizeof(tChar) * TUN_TAG_SIZE);
	memset(m_sVersion, 0,  sizeof(tChar) * TUN_VERSION_SIZE);
	memset(m_u32PresetList, 0,  sizeof(tU32) * TUN_PRESETLIST_SIZE);
	memset(m_sDabTag, 0,  sizeof(tChar) * TUN_TAG_SIZE);
	memset(m_sDabVersion, 0,  sizeof(tChar) * TUN_VERSION_SIZE);
	memset(m_u8DabMatrix, 0,  sizeof(tU8) * TUN_DAB_MATRIX_SIZE);
	m_poclTunerConfigInterface = NULL;
	m_poConfigMain = NULL;
}

/**************************************************************************//**
*
******************************************************************************/
clConfigMain* clConfigMain::instance()
{
	if (m_poConfigMain == 0)
	{
		m_poConfigMain = new clConfigMain();
	}
	return m_poConfigMain;
}

void clConfigMain::vSetTunerInterfacePtr(clTunerConfigInterface* poclTunerConfigInterface)
{
	m_poclTunerConfigInterface = poclTunerConfigInterface;
}

/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vStartKDSRead()
{
	tU8 u8BufferGet[500] = {0};
	tS32 s32ReturnCode = 0xFF;
	tU8 u8PresetIndex = 0;

	const int numberofKDSData = sizeof aTunerKDSConfig / sizeof(stTunerKDSConfig);

    for (int u32Index = 0; u32Index < numberofKDSData; u32Index++)
    {
    	if(strcmp(aTunerKDSConfig[u32Index].oConfigType.c_str() , "") == 0)
    	{
    		ETG_TRACE_USR1(( "*************************************************************    Start reading : %s *************************************************************  " , aTunerKDSConfig[u32Index].oParameterSet.c_str()));
			memset(u8BufferGet, 0,  sizeof(tU8) * 500);
    		s32ReturnCode = 0xFF;
    		s32ReturnCode=DP_s32GetConfigItem(aTunerKDSConfig[u32Index].oParameterSet.c_str(),"",u8BufferGet,(tU16)aTunerKDSConfig[u32Index].oSize,false); /* Added to avoid assert*/
    		continue;
    	}

#ifndef VARIANT_P_MIDDLEWARE_CONFIGLIB_GTEST

		if(s32ReturnCode == DP_S32_NO_ERR)
		{
			vUpdateMapKDSConfig(u32Index , u8BufferGet);
		}
		else
		{
		
			TunerKDSConfigMap[aTunerKDSConfig[u32Index].oConfigType] = aTunerKDSConfig[u32Index].oDefaultValue;
			ETG_TRACE_USR1(( " ********************* Set default values *********************"));
		}
#else

    	TunerKDSConfigMap[aTunerKDSConfig[u32Index].oConfigType] = aTunerKDSConfig[u32Index].oDefaultValue;

#endif
    	ETG_TRACE_USR2((" %50s : \t\t\t\t\t\t %u", aTunerKDSConfig[u32Index].oConfigType.c_str(), TunerKDSConfigMap[aTunerKDSConfig[u32Index].oConfigType]));

    	if((strcmp("Preset0",aTunerKDSConfig[u32Index].oConfigType.c_str()) == 0) || u8PresetIndex != 0)
    	{
    		m_u32PresetList[u8PresetIndex] = TunerKDSConfigMap[aTunerKDSConfig[u32Index].oConfigType];
    		ETG_TRACE_USR1(( " clConfigMain::vStartKDSRead u32PresetList[%d] = %d ", u8PresetIndex, m_u32PresetList[u8PresetIndex]));
    		u8PresetIndex++;

    		if(u8PresetIndex == TUN_PRESETLIST_SIZE)
    		{
    			u8PresetIndex = 0;
    		}
    	}
	}
	//Below code will be uncommented once Dab configuration happens using config lib
    if(u32GetConfigData("DABSupported"))
    {
        vReadDabParameterSet();
    }
	vUpdateAvailableBandsFromEOL();
	vUpdateFrequency_StepSizeFromEOL();
	vUpdateFieldStrengthSeekLevelFromEOL();
	vUpdateAdr_FmDeemphasis();
	vUpdateDABAvailSystemConfiguration();
	vUpdateDABAvailRadioNumConfiguration();
	if(u32GetConfigData("DRMSupported"))
	{
		vUpdateDRMAvailability();
	}
	
	/*This is specific to chery  */
	vReadCodingData();
	/*End of chery specific code */

	//Below code section will be uncommented once the system set coding is enabled for tunermaster
	/*if(m_poclTunerConfigInterface != NULL)
	{
		m_poclTunerConfigInterface->vConfigDone();
	}
	ETG_TRACE_USR1(( " clConfigMain:: m_poclTunerConfigInterface=%d",m_poclTunerConfigInterface));*/
#ifdef	VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	if(0xff ==u32GetConfigData("FmDabHdTunerMode"))
	{
		TunerKDSConfigMap["SBR"] = true;
	}
	ETG_TRACE_USR2(("SBR : \t\t\t\t\t\t %u", TunerKDSConfigMap["SBR"]));
#endif
}

/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vReadDabParameterSet()
{
	tU8 u8DabMatrixIndex = 0;
	tU8 u8BufferGet[500] = {0};
	tS32 s32ReturnCode = 0xFF;

	const int numberofKDSData = sizeof aTunerDABParameterSet / sizeof(stTunerKDSConfig);

	for (int u32Index = 0; u32Index < numberofKDSData; u32Index++)
	{
		if(strcmp(aTunerDABParameterSet[u32Index].oConfigType.c_str() , "") == 0)
		{
			ETG_TRACE_USR1(( "*************************************************************    Start reading : %s *************************************************************  " , aTunerKDSConfig[u32Index].oParameterSet.c_str()));
			memset(u8BufferGet, 0,  sizeof(tU8) * 500);
			s32ReturnCode = 0xFF;
			s32ReturnCode=DP_s32GetConfigItem(aTunerDABParameterSet[u32Index].oParameterSet.c_str(),"",u8BufferGet,(tU16)aTunerDABParameterSet[u32Index].oSize);
			continue;
		}

		if(s32ReturnCode == DP_S32_NO_ERR)
		{
			vUpdateMapDabParameterSet(u32Index , u8BufferGet);
		}
		else
		{

			TunerKDSConfigMap[aTunerDABParameterSet[u32Index].oConfigType] = aTunerDABParameterSet[u32Index].oDefaultValue;
			ETG_TRACE_USR1(( " ********************* Set default values *********************"));
		}

		ETG_TRACE_USR2((" %50s : \t\t\t\t\t\t %u", aTunerDABParameterSet[u32Index].oConfigType.c_str(), TunerKDSConfigMap[aTunerDABParameterSet[u32Index].oConfigType]));

		if(aTunerDABParameterSet[u32Index].oByte == TUN_DAB_ARRAY_STARTBYTE || u8DabMatrixIndex != 0)
		{
			m_u8DabMatrix[u8DabMatrixIndex] = (tU8) TunerKDSConfigMap[aTunerDABParameterSet[u32Index].oConfigType];
			u8DabMatrixIndex++;

			if(u8DabMatrixIndex == TUN_DAB_MATRIX_SIZE)
			{
				u8DabMatrixIndex = 0;
			}
		}
	}
}

/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vUpdateMapDabParameterSet(int u32index ,tU8* value)
{
	unsigned int ByteValue = 0;

	switch(aTunerDABParameterSet[u32index].oSize)
	{
		case 0x01 : ByteValue = value[aTunerDABParameterSet[u32index].oByte];
					break;
		case 0x02 : ByteValue = TUN_CONFIG_GET_U16(&value[aTunerDABParameterSet[u32index].oByte]);
					break;
		case 0x03 : OSAL_pvMemoryCopy( m_sDabVersion, &value[ aTunerDABParameterSet[u32index].oByte], (tU8)aTunerDABParameterSet[u32index].oSize);
					break;
		case 0x04 : ByteValue = TUN_CONFIG_GET_U32(&value[aTunerDABParameterSet[u32index].oByte]);
					break;
		case 0x08 : OSAL_pvMemoryCopy( m_sDabTag, &value[ aTunerDABParameterSet[u32index].oByte],(tU8)aTunerDABParameterSet[u32index].oSize);
					break;
		case 0xFF : ByteValue = aTunerDABParameterSet[u32index].oDefaultValue;
					break;
		default : break;
	}

	if(aTunerDABParameterSet[u32index].oBitMaskAND)
	{
		if(aTunerDABParameterSet[u32index].oCompareVal)
		{
			ByteValue = ((ByteValue & aTunerDABParameterSet[u32index].oBitMaskAND) >> aTunerDABParameterSet[u32index].oBitMaskRightShift) ? 0x01 : 0x00;
		}
		else
		{
			ByteValue = (ByteValue & aTunerDABParameterSet[u32index].oBitMaskAND) >> aTunerDABParameterSet[u32index].oBitMaskRightShift;
		}
	}

	TunerKDSConfigMap[aTunerDABParameterSet[u32index].oConfigType] = ByteValue;

}
/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vUpdateMapKDSConfig(int u32index ,tU8* value)
{
	unsigned int ByteValue = 0;
	switch(aTunerKDSConfig[u32index].oSize)
	{
		case 0x01 : ByteValue = value[aTunerKDSConfig[u32index].oByte];
					break;
		case 0x02 : ByteValue = TUN_CONFIG_GET_U16(&value[aTunerKDSConfig[u32index].oByte]);
					break;
		case 0x03 : OSAL_pvMemoryCopy( m_sVersion, &value[ aTunerKDSConfig[u32index].oByte], (tU8)aTunerKDSConfig[u32index].oSize);
					break;
		case 0x04 : ByteValue = TUN_CONFIG_GET_U32(&value[aTunerKDSConfig[u32index].oByte]);
					break;
		case 0x08 : OSAL_pvMemoryCopy( m_sTag, &value[ aTunerKDSConfig[u32index].oByte],(tU8)aTunerKDSConfig[u32index].oSize);
					break;
		case 0xFF : ByteValue = aTunerKDSConfig[u32index].oDefaultValue;
					break;
		default : break;
	}

	if(aTunerKDSConfig[u32index].oBitMaskAND)
	{
		if(aTunerKDSConfig[u32index].oCompareVal)
		{
			ByteValue = ((ByteValue & aTunerKDSConfig[u32index].oBitMaskAND) >> aTunerKDSConfig[u32index].oBitMaskRightShift) ? 0x01 : 0x00;
		}
		else
		{
			ByteValue = (ByteValue & aTunerKDSConfig[u32index].oBitMaskAND) >> aTunerKDSConfig[u32index].oBitMaskRightShift;
		}
	}

		TunerKDSConfigMap[aTunerKDSConfig[u32index].oConfigType] = ByteValue;

}


/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vUpdateAvailableBandsFromEOL()
{
	int u32Availablebands = u32GetConfigData("AvailableBands");

	if((u32GetConfigData("RADIOAMBandFunction") == 0xFF) || (u32GetConfigData("RADIOCountryZone") == 0xFF))
	{
		ETG_TRACE_USR1(( " clConfigMain:: vUpdateAvailableBandsFromEOL, invalid EOL "));
		return;
	}

	if(u32GetConfigData("RADIOAMBandFunction"))
	{
		if(u32GetConfigData("RADIOCountryZone") == 0) // EUR
		{
			u32Availablebands |= TUN_CONFIG_AM_AVAIL_EU; /* Enable both MW and LW */
		}
		else
		{
			/* Enable only MW */
			u32Availablebands &= TUN_CONFIG_LW_NOTAVAIL;
			u32Availablebands |= TUN_CONFIG_AM_AVAIL_RESTAREA;
		}
	}
	else
	{
		u32Availablebands &= TUN_CONFIG_AM_NOTAVAIL; /*Disable MW and LW */
	}

	TunerKDSConfigMap["AvailableBands"] = u32Availablebands;
}


/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vUpdateFrequency_StepSizeFromEOL()
{
	if((u32GetConfigData("RADIORDSFollowUp") == 0xFF) || (u32GetConfigData("RADIOCountryZone") == 0xFF))
	{
		ETG_TRACE_USR1(( " clConfigMain:: vUpdateFrequency_StepSizeFromEOL, invalid EOL "));
		return;
	}

	int u8CountryCode = u32GetConfigData("RADIOCountryZone");
	const int numberofKDSData = sizeof aTunerFreqStepSize / sizeof(stTunerFreqStepSize);



    for (int u32Index = 0; u32Index < numberofKDSData; u32Index++)
    {
    	if(aTunerFreqStepSize[u32Index].oCountryZone == u8CountryCode)
    	{
    		TunerKDSConfigMap["LowFM"]		 		=  aTunerFreqStepSize[u32Index].oLowFM;
    		TunerKDSConfigMap["HighFM"]      		=  aTunerFreqStepSize[u32Index].oHighFM;
			//if(u8CountryCode!=enPSA_TunerArea_Brazil) ;as discussed with nagaraj, it is commented out.
			{
    		TunerKDSConfigMap["StepSizeFM"]      	=  aTunerFreqStepSize[u32Index].oStepSizeFM;
    		TunerKDSConfigMap["ManualStepSizeFM"]   =  aTunerFreqStepSize[u32Index].oStepSizeManualFM;
    		TunerKDSConfigMap["LowMW"]      		=  aTunerFreqStepSize[u32Index].oLowMW;
    		TunerKDSConfigMap["HighMW"]      		=  aTunerFreqStepSize[u32Index].oHighMW;
    		TunerKDSConfigMap["StepSizeMW"]      	=  aTunerFreqStepSize[u32Index].oStepSizeMW;
    		TunerKDSConfigMap["ManualStepSizeMW"]   =  aTunerFreqStepSize[u32Index].oStepSizeManualMW;
    		TunerKDSConfigMap["LowLW"]      		=  aTunerFreqStepSize[u32Index].oLowLW;
    		TunerKDSConfigMap["HighLW"]      		=  aTunerFreqStepSize[u32Index].oHighLW;
    		TunerKDSConfigMap["StepSizeLW"]      	=  aTunerFreqStepSize[u32Index].oStepSizeLW;
    		TunerKDSConfigMap["ManualStepSizeLW"]   =  aTunerFreqStepSize[u32Index].oStepSizeManualLW;
			}
    	}
    }

    if(u8CountryCode != enPSA_TunerArea_Europe)
    {
    	TunerKDSConfigMap["CombiBands"] = 0;
    	TunerKDSConfigMap["LW_LSM"] = 0;
    }


	if (u32GetConfigData("FM_LSM") < u32GetConfigData("LowFM"))
	{
			TunerKDSConfigMap["FM_LSM"] = u32GetConfigData("LowFM");
	}
	if (u32GetConfigData("MW_LSM") < u32GetConfigData("LowMW"))
	{
			TunerKDSConfigMap["MW_LSM"] = u32GetConfigData("LowMW");
	}
	if (u32GetConfigData("LW_LSM") < u32GetConfigData("LowLW"))
	{
			TunerKDSConfigMap["LW_LSM"] = u32GetConfigData("LowLW");
	}

	vHandle_RDS_AF_Switch(u8CountryCode);
	vUpdatePIIgnoreAccordingToCountry();
}


/**************************************************************************//**
*
******************************************************************************/

void clConfigMain::vUpdateAdr_FmDeemphasis()
{
	if( u32GetConfigData("RADIOCountryZone") == 0xFF)
	{
		ETG_TRACE_USR1(( " clConfigMain:: vUpdateAdr_FmDeemphasis, invalid country code "));
		return;
	}

	int u8CountryCode = u32GetConfigData("RADIOCountryZone");
	const int numberofKDSData = sizeof aTunerAdrFmDeemphasis / sizeof(stTunerAdrFmDeemphasis);


    for (int u32Index = 0; u32Index < numberofKDSData; u32Index++)
    {
    	if(aTunerAdrFmDeemphasis[u32Index].oCountryZone == u8CountryCode)
    	{
    		TunerKDSConfigMap["ADRFmDeemphasis"]   =  aTunerAdrFmDeemphasis[u32Index].oAdrFmDeemphasis;
    	}
    }


}

void clConfigMain::vUpdatePIIgnoreAccordingToCountry()
{
	int u8CountryCode = u32GetConfigData("RADIOCountryZone");
	if(0xFF == u8CountryCode)
	{
		ETG_TRACE_USR1(( " clConfigMain:: vUpdatePIIgnoreAccordingToCountry, invalid country code "));
		return;
	}
	if((enPSA_TunerArea_Asia_China == u8CountryCode) || (enPSA_TunerArea_Korea == u8CountryCode))
	{
		TunerKDSConfigMap["PIIgnore"] = 0x6; /* Bit 0[PI Ignore]:    0
											    Bit 1 [Air PS only]: 1
												Bit 2 [Auto compare PI and Freq]: 1 */
	}
}
/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vUpdateFieldStrengthSeekLevelFromEOL()
{
	if((u32GetConfigData("AUDIORadioReceptionThreshold") == 0xFF) || (u32GetConfigData("RADIOCountryZone") == 0xFF))
	{
		ETG_TRACE_USR1(( " clConfigMain:: vUpdateFieldStrengthSeekLevelFromEOL, invalid EOL "));
		return;
	}

	int u8CountryCode = u32GetConfigData("RADIOCountryZone");
    const int numberofKDSData = sizeof aTunerFSSeekLevel / sizeof(stTunerFSSeekLevel);
	tU8 u8SeekSensitivitybit = (tU8) u32GetConfigData("AUDIORadioReceptionThreshold");

    for (int u32Index = 0; u32Index < numberofKDSData; u32Index++)
    {
    	if(u8SeekSensitivitybit == aTunerFSSeekLevel[u32Index].oSeekSensitivitybit)
    	{
    		TunerKDSConfigMap["SeekLevelFMRDSFieldstrength"] 	= aTunerFSSeekLevel[u32Index].oSeekSensitivityFMRDS;
    		TunerKDSConfigMap["SeekLevelFMNonRDSFieldstrength"] = aTunerFSSeekLevel[u32Index].oSeekSensitivityFMNONRDS;
    		TunerKDSConfigMap["SeekLevelMWFieldstrength"] 		= aTunerFSSeekLevel[u32Index].oSeekSensitivityMW;
			if(u8CountryCode == enPSA_TunerArea_Europe)
    		{
    			TunerKDSConfigMap["SeekLevelLWFieldstrength"] = aTunerFSSeekLevel[u32Index].oSeekSensitivityLW;
    		}
    	}
    }

}


/**************************************************************************//**
*
******************************************************************************/

void clConfigMain::vUpdateDABAvailSystemConfiguration()
{
	if(u32GetConfigData("DABSystemConfiguration") == 0xFF)
	{
		ETG_TRACE_USR1(( " clConfigMain:: vReadKDSSystemInfoCommonIVIParameters, invalid "));
		return;
	}

	if(u32GetConfigData("DABSupported"))
	{
		TunerKDSConfigMap["DABSupported"] = u32GetConfigData("DABSystemConfiguration");
	}
}

/**************************************************************************//**
*
******************************************************************************/

void clConfigMain::vUpdateDRMAvailability()
{
	if(!((u32GetConfigData("CombiBands")) & READ_DRM_MODULATION_BIT))
	{
		TunerKDSConfigMap["DRMSupported"] = DRM_NOT_SUPPORTED;
	}
	ETG_TRACE_USR1(( " clConfigMain:: vUpdateDRMAvailability,DRMSupported : %d ",TunerKDSConfigMap["DRMSupported"]));
}

/**************************************************************************//**
*
******************************************************************************/

void clConfigMain::vUpdateDABAvailRadioNumConfiguration()
{
	if(u32GetConfigData("RADIONUMBandActivation") == 0xFF)
	{
		ETG_TRACE_USR1(( " clConfigMain:: vReadKDSSystemInfoCommonIVIParameters, invalid "));
		return;
	}
	
	if(u32GetConfigData("DABSupported"))
	{
		TunerKDSConfigMap["DABSupported"] = u32GetConfigData("RADIONUMBandActivation");
	}

}


/**************************************************************************//**
*
******************************************************************************/
tenAntennaKDSReadReturn clConfigMain::vReadAntennaParameter(tunerVector<tU8> &AntennaPar)
{
	tS32 s32ReturnCode = DP_U8_ELEM_STATUS_NOT_READ;
	AntennaPar.clear();
#ifdef DP_U8_KDSLEN_ANTENNA2PARAMETER_COMPLETE
	tU8 u8NewParBuffer[DP_U8_KDSLEN_ANTENNA2PARAMETER_COMPLETE]{0};
	s32ReturnCode = DP_s32GetConfigItem("Antenna2Parameter","",u8NewParBuffer,DP_U8_KDSLEN_ANTENNA2PARAMETER_COMPLETE);
	if(s32ReturnCode == DP_S32_NO_ERR)
	{
		for(tU16 u16Index = 0; u16Index<DP_U8_KDSLEN_ANTENNA2PARAMETER_COMPLETE ; u16Index++)
		{
			AntennaPar.push_back(u8NewParBuffer[u16Index]);
		}
		return enAntennaKDSRead_NewParamSuc;
	}
	else
#endif
	{
		s32ReturnCode = DP_U8_ELEM_STATUS_NOT_READ;
		tU8 u8Buffer[DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE] {0};
		s32ReturnCode=DP_s32GetConfigItem("AntennaParameter","",u8Buffer,DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE);
		if(s32ReturnCode != DP_S32_NO_ERR)
		{
			return enAntennaKDSReadFail;
		}
		else
		{
			tU8 u8ReservedByteIndex = 0;
			for(tU16 u16KDSindex = 0; u16KDSindex < DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE; u16KDSindex++)
			{
				AntennaPar.push_back(u8Buffer[u16KDSindex]);
				if(u16KDSindex > TUN_ANTENNAPAR_STARTING_UNUSED_BYTES_COUNT)
				{
					u8ReservedByteIndex++;
				}
				if(u8ReservedByteIndex >= TUN_ANTENNAPAR_EACH_ANTENNA_PARAM_COUNT)
				{
					//push 6 reserved bytes
					for(tU8 u8ReservedByteCnt = 0; u8ReservedByteCnt<TUN_ANTENNAPAR_EACH_ANTENNA2_RESERVED_BYTE_COUNT; u8ReservedByteCnt++)
					{
						AntennaPar.push_back(0);
					}
					u8ReservedByteIndex = 0;
					if(u16KDSindex ==enAntennaParameter_idx_DAB1ParEnd)
					{
						//To updated 26bytes each for DAB2 Antenna with 0
						for(tU8 u8index = 0; u8index < (TUN_ANTENNAPAR_EACH_ANTENNA2_RESERVED_BYTE_COUNT+TUN_ANTENNAPAR_EACH_ANTENNA_PARAM_COUNT);
								u8index++)
						{
							AntennaPar.push_back(0);
						}
					}
					if (u8Buffer[8]>0x31)
					{
						if(u16KDSindex == enAntennaParameter_idx_DTV1ParEnd)
						{
							//DTV1 Antenna parameter shd be used for both DTV1 And DTV2 Antenna
							for(tU16 u16index = enAntennaParameter_idx_DTV1AntennaType; u16index < (enAntennaParameter_idx_DTV1AntennaType+TUN_ANTENNAPAR_EACH_ANTENNA_PARAM_COUNT);u16index++)
							{
								AntennaPar.push_back(u8Buffer[u16index]);
							}
							for(tU8 u8ReservedByteCnt = 0; u8ReservedByteCnt<TUN_ANTENNAPAR_EACH_ANTENNA2_RESERVED_BYTE_COUNT; u8ReservedByteCnt++)
							{
								AntennaPar.push_back(0);
							}
						}
						if(u16KDSindex == enAntennaParameter_idx_DTV2ParEnd)
						{
							//DTV2 Antenna parameter shd be used for both DTV3 And DTV4 Antenna
							for(tU16 u16index = enAntennaParameter_idx_DTV2AntennaType; u16index < (enAntennaParameter_idx_DTV2AntennaType+TUN_ANTENNAPAR_EACH_ANTENNA_PARAM_COUNT);u16index++)
							{
								AntennaPar.push_back(u8Buffer[u16index]);
							}
							for(tU8 u8ReservedByteCnt = 0; u8ReservedByteCnt<TUN_ANTENNAPAR_EACH_ANTENNA2_RESERVED_BYTE_COUNT; u8ReservedByteCnt++)
							{
								AntennaPar.push_back(0);
							}
						}
					}
					else if(u16KDSindex == enAntennaParameter_idx_DTV2ParEnd)
					{
						for(tU8 u8AntCnt= 0;u8AntCnt<2;u8AntCnt++)
						{
							for(tU16 u16index = 0; u16index < (TUN_ANTENNAPAR_EACH_ANTENNA_PARAM_COUNT+TUN_ANTENNAPAR_EACH_ANTENNA2_RESERVED_BYTE_COUNT);u16index++)
							{
								AntennaPar.push_back(0);
							}
						}
					}
				}
			}
			return enAntennaKDSRead_OldParamSuc;
		}
	}
	return enAntennaKDSReadFail;
}
/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vReadAntennaExtSupInfo(tU8 u8Buffer[])
{
	u8Buffer[enKdsCMVariantCoding_idx_FM1_AntennaInfo] = u8ReadAntennaPowerSupInfo("FMAntenna1Info");
	u8Buffer[enKdsCMVariantCoding_idx_FM2_AntennaInfo] = u8ReadAntennaPowerSupInfo("FMAntenna2Info");
	u8Buffer[enKdsCMVariantCoding_idx_DAB_AntennaInfo] = u8ReadAntennaPowerSupInfo("DABAntenna1Info");
	u8Buffer[enKdsCMVariantCoding_idx_GPS_AntennaInfo] = u8ReadAntennaPowerSupInfo("GPSAntenna1Info");
	u8Buffer[enKdsCMVariantCoding_idx_DTV1_AntennaInfo] = u8ReadAntennaPowerSupInfo("TVAntenna1Info");
	u8Buffer[enKdsCMVariantCoding_idx_DTV2_AntennaInfo] = u8ReadAntennaPowerSupInfo("TVAntenna2Info");
	u8Buffer[enKdsCMVariantCoding_idx_DTV3_AntennaInfo] = u8ReadAntennaPowerSupInfo("TVAntenna3Info");
	u8Buffer[enKdsCMVariantCoding_idx_DTV4_AntennaInfo] = u8ReadAntennaPowerSupInfo("TVAntenna4Info");
	u8Buffer[enKdsCMVariantCoding_idx_DAB2_AntennaInfo] = u8ReadAntennaPowerSupInfo("DABAntenna2Info");
}
tU8 clConfigMain::u8ReadAntennaPowerSupInfo(const tChar* strConfigItem)
{
	tU8 u8Data {enunknown};
	if(u32GetConfigData(strConfigItem) > enELMOS4_2)
	{
		tSize sKDSParamNameLen = strlen("Extended") + strlen(strConfigItem) + 1;
		tChar cKDSParamName[(tU8)sKDSParamNameLen] = "Extended";
		strcat(cKDSParamName,strConfigItem);
		tS32 s32ReturnCode = DP_s32GetConfigItem("CMExVariantCoding",cKDSParamName,&u8Data,1,false);
		if(s32ReturnCode != DP_S32_NO_ERR)
		{
			ETG_TRACE_USR4(( "Error in reading CMExVariantCoding"));
			return enunknown;
		}
		else
		{
			return u8Data;
		}
	}
	else
	{
		return (tU8)u32GetConfigData(strConfigItem);
	}
}


/**************************************************************************//**
*
******************************************************************************/
tU32 clConfigMain::u32GetPreset( tU32 u32Index)
{
	if(u32Index < TUN_PRESETLIST_SIZE)
	{
		return m_u32PresetList[u32Index];
	}
	else
	{
		return 0;
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clConfigMain::vGetVersionID(tChar* pBuffer)
{
	 OSAL_pvMemoryCopy( pBuffer, m_sTag, sizeof(m_sTag));
	 OSAL_pvMemoryCopy( &pBuffer[ sizeof( m_sTag)], m_sVersion, sizeof( m_sVersion));
}


/**************************************************************************//**
*
******************************************************************************/
tU32 clConfigMain::u32GetConfigData( tunerString sConfigString)
{
	if (TunerKDSConfigMap.find(sConfigString) != TunerKDSConfigMap.end())
	{
		return TunerKDSConfigMap[sConfigString];
	}
	return 0xFF;
}





void clConfigMain::vHandleTTFisCommands(tU8 u8Commandtype, tU8 u8TunParameterSet)
{
		ETG_TRACE_USR1(( "clConfigMain::vHandleTTFisCommands"));
		tU8 u8ParameterSetVal = 0;
		bool bActionDone = false;
		tU8 u8BufferGet[500] = {0};
		memset(u8BufferGet, 0,  sizeof(tU8) * 500);

		const int numberofKDSData = sizeof aTunerKDSConfig / sizeof(stTunerKDSConfig);

		for (int u32Index = 0; u32Index < numberofKDSData; u32Index++)
		{
			if(strcmp(aTunerKDSConfig[u32Index].oConfigType.c_str() , "") == 0 && bActionDone == true)
			{
				break;
			}
			else if((strcmp(aTunerKDSConfig[u32Index].oConfigType.c_str() , "") == 0) && (u8ParameterSetVal != u8TunParameterSet))
			{
				u8ParameterSetVal++;

				if(u8Commandtype == TUN_TRACE_CONFIG_PRINT || u8Commandtype == TUN_TRACE_CONFIG_SET_TO_DEFAULT)
				{
					continue;
				}
				if(u8Commandtype == TUN_TRACE_CONFIG_READ_KDS)
				{
					(void)DP_s32GetConfigItem(aTunerKDSConfig[u32Index].oParameterSet.c_str(),"",u8BufferGet,(tU16)aTunerKDSConfig[u32Index].oSize);
				}
			}
			else if(u8ParameterSetVal == u8TunParameterSet)
			{
				vHandleCommand(u8Commandtype,u32Index,u8BufferGet);
				bActionDone = true;
			}
		}
}


void clConfigMain::vHandleCommand(tU8 u8Commandtype,int u32Index,tU8* value)
{
	switch(u8Commandtype)
	{
	    case TUN_TRACE_CONFIG_PRINT:
		{
			ETG_TRACE_USR2((" %50s : \t\t\t\t\t\t %u", aTunerKDSConfig[u32Index].oConfigType.c_str(), TunerKDSConfigMap[aTunerKDSConfig[u32Index].oConfigType]));
		}
	      break;

	    case TUN_TRACE_CONFIG_SET_TO_DEFAULT:
	    {
	    	TunerKDSConfigMap[aTunerKDSConfig[u32Index].oConfigType] = aTunerKDSConfig[u32Index].oDefaultValue;
	    }
	      break;

	    case TUN_TRACE_CONFIG_READ_KDS:
	    {
	    	vUpdateMapKDSConfig(u32Index , value);
	    }
	      break;

	    default:

	      ETG_TRACE_FATAL(( " clConfigMain::vHandleCommand() -> Error: unknown command."
	                     ));
	      break;
	}
}

void clConfigMain::vHandle_RDS_AF_Switch(int u8CountryCode)
{
	if(u32GetConfigData("RADIORDSFollowUp"))
	{
		TunerKDSConfigMap["AFSwitchAudioTuner1"] = 0x01;
		TunerKDSConfigMap["AFSwitchAudioTuner2"] = 0x01;
	}
	else
	{
		TunerKDSConfigMap["AFSwitchAudioTuner1"] = 0x00;
		TunerKDSConfigMap["AFSwitchAudioTuner2"] = 0x00;
	}

	if((u8CountryCode == enPSA_TunerArea_South_America) || (u8CountryCode == enPSA_TunerArea_Brazil) || (enPSA_TunerArea_Asia_China == u8CountryCode ) || (enPSA_TunerArea_Korea == u8CountryCode))
	    {
			TunerKDSConfigMap["AFSwitchAudioTuner1"] = 0x00;
			TunerKDSConfigMap["AFSwitchAudioTuner2"] = 0x00;
	    }

	if((u8CountryCode != enPSA_TunerArea_Europe) && (u8CountryCode != enPSA_TunerArea_South_America) && (u8CountryCode != enPSA_TunerArea_Brazil) && (u8CountryCode != enPSA_TunerArea_Arabia) && (enPSA_TunerArea_Asia_China != u8CountryCode) && (enPSA_TunerArea_Korea != u8CountryCode))
	    {
			TunerKDSConfigMap["RDSSwitchAudioTuner1"] = 0x00;
			TunerKDSConfigMap["RDSSwitchAudioTuner2"] = 0x00;
	    }

}

void clConfigMain::vGetTsuMatrixDabFm(tU8 u8TsuMatrixDabFm[])
{
	for(tU8 u8MatrixIndex = 0; u8MatrixIndex < TUN_DAB_TSU_MATRIX_SIZE ; u8MatrixIndex++)
	{
		u8TsuMatrixDabFm[u8MatrixIndex] = m_u8DabMatrix[u8MatrixIndex];
	}

}

void clConfigMain::vGetTsuMatrixFmDab(tU8 u8TsuMatrixFmDab[])
{
	tU8 u8MatrixIndex = TUN_DAB_TSU_MATRIX_SIZE;
	for(tU8 u8TsuMatrixIndex = 0; u8TsuMatrixIndex < TUN_DAB_TSU_MATRIX_SIZE ; u8TsuMatrixIndex++)
	{
		u8TsuMatrixFmDab[u8TsuMatrixIndex] = m_u8DabMatrix[u8MatrixIndex];
		u8MatrixIndex++;
	}

}

void clConfigMain::vGetEnsemblelabel(tU8 u8LSMConfig_EnsembleLabel[])
{
	tU8 u8MatrixIndex = 2*TUN_DAB_TSU_MATRIX_SIZE;
	for(tU8 u8LabelIndex = 0; u8LabelIndex < TUN_DAB_LABEL_SIZE ; u8LabelIndex++)
	{
		u8LSMConfig_EnsembleLabel[u8LabelIndex] = m_u8DabMatrix[u8MatrixIndex];
	}

}

void clConfigMain::vGetServiceLabel(tU8 u8LSMConfig_ServiceLabel[])
{
	tU8 u8MatrixIndex = (2*TUN_DAB_TSU_MATRIX_SIZE) + TUN_DAB_LABEL_SIZE;
	for(tU8 u8LabelIndex = 0; u8LabelIndex < TUN_DAB_LABEL_SIZE ; u8LabelIndex++)
	{
		u8LSMConfig_ServiceLabel[u8LabelIndex] = m_u8DabMatrix[u8MatrixIndex];
	}

}

void clConfigMain::vGetComponentLabel(tU8 u8LSMConfig_ComponentLabel[])
{
	tU8 u8MatrixIndex = (2*TUN_DAB_TSU_MATRIX_SIZE) + (2*TUN_DAB_LABEL_SIZE);
	for(tU8 u8LabelIndex = 0; u8LabelIndex < TUN_DAB_LABEL_SIZE ; u8LabelIndex++)
	{
		u8LSMConfig_ComponentLabel[u8LabelIndex] = m_u8DabMatrix[u8MatrixIndex];
	}

}

void clConfigMain::vReadCodingData()
{

	int u8CountryCode =  0xFF; // M31TCodingData data

	u8CountryCode = u32GetConfigData("CountryString");

	if(u8CountryCode == 0xFF)
	{
			ETG_TRACE_USR1(( " clConfigMain::M31TCodingDataFromEOL, invalid EOL "));
			return;
	}

	int numberofKDSData = sizeof aTunerFreqStepSizeExt / sizeof(stTunerFreqStepSize);

    for (int u32Index = 0; u32Index < numberofKDSData; u32Index++)
    {
    	if(aTunerFreqStepSizeExt[u32Index].oCountryZone == u8CountryCode)
    	{

    		TunerKDSConfigMap["StepSizeFM"]      	=  aTunerFreqStepSizeExt[u32Index].oStepSizeFM;
    		TunerKDSConfigMap["ManualStepSizeFM"]   =  aTunerFreqStepSizeExt[u32Index].oStepSizeManualFM;
    		TunerKDSConfigMap["LowMW"]      		=  aTunerFreqStepSizeExt[u32Index].oLowMW;
    		TunerKDSConfigMap["HighMW"]      		=  aTunerFreqStepSizeExt[u32Index].oHighMW;
    		TunerKDSConfigMap["StepSizeMW"]      	=  aTunerFreqStepSizeExt[u32Index].oStepSizeMW;
    		TunerKDSConfigMap["ManualStepSizeMW"]   =  aTunerFreqStepSizeExt[u32Index].oStepSizeManualMW;
    		TunerKDSConfigMap["LowLW"]      		=  aTunerFreqStepSizeExt[u32Index].oLowLW;
    		TunerKDSConfigMap["HighLW"]      		=  aTunerFreqStepSizeExt[u32Index].oHighLW;
    		TunerKDSConfigMap["StepSizeLW"]      	=  aTunerFreqStepSizeExt[u32Index].oStepSizeLW;
    		TunerKDSConfigMap["ManualStepSizeLW"]   =  aTunerFreqStepSizeExt[u32Index].oStepSizeManualLW;
    	}
    }/*End updating step size parameters */

    numberofKDSData = sizeof aCHRYReceptionParameter1 / sizeof(stCHRYReceptionParameter1);

    for (int u32Index = 0 ; u32Index < numberofKDSData; u32Index++)
    {
    	if(aCHRYReceptionParameter1[u32Index].oCountryZone == u8CountryCode)
    	{
    		TunerKDSConfigMap["ADRFmChannelSeparation"]    =  aCHRYReceptionParameter1[u32Index].oADRFmChannelSeparation;
    		TunerKDSConfigMap["ADRFmLimiting"]  		   =  aCHRYReceptionParameter1[u32Index].oADRFmLimiting;
    		TunerKDSConfigMap["ADRFmMultipath"]  		   =  aCHRYReceptionParameter1[u32Index].oADRFmMultipath;
    		TunerKDSConfigMap["ADRFmHighCut"]  			   =  aCHRYReceptionParameter1[u32Index].oADRFmHighCut;
    		TunerKDSConfigMap["ADRFmSoftMute"]   		   =  aCHRYReceptionParameter1[u32Index].oADRFmSoftMute;
    		TunerKDSConfigMap["ADRAmSoftMute"]   		   =  aCHRYReceptionParameter1[u32Index].oADRAmSoftMute;
    		TunerKDSConfigMap["ADRFmDeemphasis"]  		   =  aCHRYReceptionParameter1[u32Index].oADRFmDeemphasis;
    		TunerKDSConfigMap["ADRFmFrequencyResponse"]    =  aCHRYReceptionParameter1[u32Index].oADRFmFrequencyResponse;
    		TunerKDSConfigMap["ADRAmFrequencyResponse"]    =  aCHRYReceptionParameter1[u32Index].oADRAmFrequencyResponse;
    		TunerKDSConfigMap["ADRFmMisc"]   			   =  aCHRYReceptionParameter1[u32Index].oADRFmMisc;
    		TunerKDSConfigMap["ADRAmMisc"] 				   =  aCHRYReceptionParameter1[u32Index].oADRAmMisc;
    		TunerKDSConfigMap["ADRFmAmplificationLevel"]   =  aCHRYReceptionParameter1[u32Index].oADRFmAmplificationLevel;
    		TunerKDSConfigMap["ADRAmAmplificationLevel"]   =  aCHRYReceptionParameter1[u32Index].oADRAmAmplificationLevel;
    		TunerKDSConfigMap["ADRAM_Hicut_Configuration"] =  aCHRYReceptionParameter1[u32Index].oADRAM_Hicut_Configuration;
    		TunerKDSConfigMap["ADRAMDeemphasis"]   		   =  aCHRYReceptionParameter1[u32Index].oADRAMDeemphasis;
    		TunerKDSConfigMap["DMQSwitchAudioTuner1"]      =  aCHRYReceptionParameter1[u32Index].oDMQSwitchAudioTuner1;
    	}
    }
    /*End updating Chery reception parameter set 1  */
    /*Includes Demphasis and DMQSwitchAudioTuner1 parameter*/

	numberofKDSData = sizeof aCHRYReceptionParameter2 / sizeof(stCHRYReceptionParameter2);

    for (int u32Index = 0 ; u32Index < numberofKDSData; u32Index++)
    {
    	if(aCHRYReceptionParameter2[u32Index].oCountryZone == u8CountryCode)
    	{
			TunerKDSConfigMap["AMFMHicutExtender"]     					  =  aCHRYReceptionParameter2[u32Index].oAMFMHicutExtender;
    		TunerKDSConfigMap["FMSoftMuteTiming"]  				          =  aCHRYReceptionParameter2[u32Index].oFMSoftMuteTiming;
    		TunerKDSConfigMap["AMFMMisscellaneous2"]  		    		  =  aCHRYReceptionParameter2[u32Index].oAMFMMisscellaneous2;
    		TunerKDSConfigMap["FMHicutExtenderFieldstrengthThreshold"]    =  aCHRYReceptionParameter2[u32Index].oFMHicutExtenderFieldstrengthThreshold;
    		TunerKDSConfigMap["FMHicutExtenderFieldstrengthFilterOffset"] =  aCHRYReceptionParameter2[u32Index].oFMHicutExtenderFieldstrengthFilterOffset;
    		TunerKDSConfigMap["FMChannelSeperationMaximum"]   		      =  aCHRYReceptionParameter2[u32Index].oFMChannelSeperationMaximum;
    		TunerKDSConfigMap["FMChannelSeperationTiming"]		          =  aCHRYReceptionParameter2[u32Index].oFMChannelSeperationTiming;
    		TunerKDSConfigMap["FMHicutFieldstrengthThreshold"]   		  =  aCHRYReceptionParameter2[u32Index].oFMHicutFieldstrengthThreshold;
    		TunerKDSConfigMap["FMHicutTiming"]     						  =  aCHRYReceptionParameter2[u32Index].oFMHicutTiming;
    		TunerKDSConfigMap["FMDMQSensitivity"] 				   		  =  aCHRYReceptionParameter2[u32Index].oFMDMQSensitivity;
    		TunerKDSConfigMap["FMDeviationAdaption"]  					  =  aCHRYReceptionParameter2[u32Index].oFMDeviationAdaption;
    		TunerKDSConfigMap["AMNoiseBlanker228kHzSensitivity"]  		  =  aCHRYReceptionParameter2[u32Index].oAMNoiseBlanker228kHzSensitivity;
    		TunerKDSConfigMap["AMNoiseBlanker45_6kHzSensitivity"]		  =  aCHRYReceptionParameter2[u32Index].oAMNoiseBlanker45_6kHzSensitivity;
    		TunerKDSConfigMap["AMHicutExtenderFieldstrengthThreshold"]    =  aCHRYReceptionParameter2[u32Index].oAMHicutExtenderFieldstrengthThreshold;
    		TunerKDSConfigMap["AMHicutExtenderFieldstrengthFilterOffset"] =  aCHRYReceptionParameter2[u32Index].oAMHicutExtenderFieldstrengthFilterOffset;
    		TunerKDSConfigMap["FMSharxLimit"] 							  =  aCHRYReceptionParameter2[u32Index].oFMSharxLimit;
    	}
    }
    /*End updating Chery reception parameter set 2  */
    /*Includes FMSharxLimit*/

}



