/*
 * drmPlayerUtility.h
 *
 *  Created on: Dec 3, 2015
 *      Author: pmn3kor
 */

#ifndef COMPONENTS_TUNER_DRMPLAYER_DRMPLAYERUTILITY_H_
#define COMPONENTS_TUNER_DRMPLAYER_DRMPLAYERUTILITY_H_


#include "datatypes/tString.h"
#include "datatypes/tVector.h"
#include "datatypes/tCommon.h"
#include "ADRMsg/ADRMsg_if.h"

namespace tuner
{
namespace drm
{
class drmPlayerUtility
{
public:
   /**
    * Contructor
    */
   drmPlayerUtility();
   /**
    * destructor
    */
   ~drmPlayerUtility();

   unsigned int vGetSampleRate(unsigned char TwoBitAudioCoding , unsigned char ThreeBitAudioSamplingRate, unsigned char OneBitSBRFlag);

   unsigned int u32ConvertSampleRateForAAC(unsigned char ThreeBitAudioSamplingRate);

   unsigned int u32GetSampleRateForxHEAAC(unsigned char ThreeBitAudioSamplingRate);

   bool bIsSBRStream(unsigned char OneBitSBRFlag);

   bool bIsDoubleValueCondition(unsigned int SampleRate);

   unsigned int u32GetSampleRateForAAC(unsigned char ThreeBitAudioSamplingRate, unsigned char OneBitSBRFlag);

   bool bIsAACStream(unsigned char TwoBitAudioCoding);

   bool bIsxHEAACStream(unsigned char TwoBitAudioCoding);

   unsigned char  getBitFromByte(unsigned char Value, unsigned char whichBit);

   static bool bGetNonReliabilityStatus();

   static unsigned int u32GetSuperFrameCorruptCount();

   static unsigned int u32GetAudioFrameCorruptCount();

   static bool bGetLastFrameStatus();

   static unsigned int u32GetTotalFrames();

   static unsigned int m_u32SuperFrameCrcFailCount, m_u32AudioFrameCrcFailCount, m_u32TotalFrameCount;

   static bool bLastFrameStatus, bNonReliabilityIndictaion;
};
}
}


#endif /* COMPONENTS_TUNER_DRMPLAYER_DRMPLAYERUTILITY_H_ */
