///////////////////////////////////////////////////////////
//  drmPlayer.cpp
//  Implementation of the Class drmPlayer
//  Created on:      27-Oct-2014 11:43:13
//  Original author: pad1cob
///////////////////////////////////////////////////////////


#include "drmPlayer/drmPlayer.h"
#include "DRMTrace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_DRMPLAYER 
#include "trcGenProj/Header/drmPlayer.cpp.trc.h"
#endif


using namespace tuner::drm;


#define USEPLAYBIN2  0x1


drmPlayer::drmPlayer()
:appSourcePlayer()
{
}


drmPlayer::drmPlayer(const tunerString oSinkName, const unsigned int u32ElementConfig)
: appSourcePlayer()
{
	ETG_TRACE_USR4(("ENTRY_THREAD: u32ElementConfig=%d   SinkName=%s", u32ElementConfig, oSinkName.c_str()));
	tunerVector<tunerString> oElements;
	if (bUsePlayBin(u32ElementConfig))
	{
		oElements.push_back("playbin2");
	}
	else
	{
		oElements.push_back("drm-audio");
		oElements.push_back("queue2");
		oElements.push_back("capsfilter");
	}
	appSourcePlayer::m_SinkName = oSinkName;
	appSourcePlayer::m_gstElements = oElements;
}


drmPlayer::~drmPlayer(){
}


bool drmPlayer::bUsePlayBin(unsigned int u32ElementConfig)
{
	if (u32ElementConfig == USEPLAYBIN2)
	{
		return true;
	}
	return false;
}
