///////////////////////////////////////////////////////////
//  appSourcePlayer.h
//  Implementation of the Class appSourcePlayer
//  Created on:      27-Oct-2014 11:43:09
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_13CB9D3B_F200_400d_9C8A_24883127D2FF__INCLUDED_)
#define EA_13CB9D3B_F200_400d_9C8A_24883127D2FF__INCLUDED_


/**
 * This file is automatically generated from EA.
 * Do not manually change. Please synchronize with EA.
 * 
 * This file is a basic appSourcePlayer. All configurations to be handled in
 * derived class.
 */


#include "glib.h"
#include "gst/gst.h"
#include "gst/app/gstappsrc.h"
#include "datatypes/tString.h"
#include "datatypes/tVector.h"
#include "datatypes/tCommon.h"
#include "ADRMsg/ADRMsg_if.h"
#include <semaphore.h>
#include "drmPlayer/drmPlayerUtility.h"

namespace tuner
{
namespace drm
{
class appSourcePlayer : public tuner::drm::drmPlayerUtility
{

public:
	/**
	 * Contructor
	 */
	appSourcePlayer();
	/**
	 * destructor
	 */
	~appSourcePlayer();
	/**
	 * DRM Gstremer Initialization (create worker threads)
	 */
	void vInit();
	/**
	 * Pause playback
	 */
	void vPause();
	/**
	 * Starts playback of data
	 */
	bool bPlay();
	/**
	 * Stops playback of data
	 */
	void vStop();
	/**
	 * New data feed for playback in push mode
	 */
	void vOnNewData(clCMDRMAudioLogicalFrameStatus* frameData);
	/**
	 * Returns the flag which indicates if Playbin element shuold be used to create gstreamer pipeline
	 */
	bool bUsePlayBin();
	/**
	    * get total logicalframes in buffer
	    */
	int getFrameCount();
	/**
	 * Creates Gstremer Decoder elements
	 */
	void vCreateDecoderElements();
	/**
	 * Plugin requests more data via this callback
	 */
	static void startFeed(GstElement * pipeline, guint size);
	/**
	 * Plugin informs that enough data is available and to stop feed
	 */
	static void stopFeed(GstElement * pipeline, guint size);
	/**
	 * call back from gstreamer based to watch  messages in Bus
	 */
	static gboolean vOnNewStatus(GstBus *bus, GstMessage *msg, gpointer data);
	/**
	 * call back function from gstreamer to get notification when the source is created
	 */
	static void vOnSourceInformation(GstElement *pipeline, GstAppSrc *source);
	/**
	 * call back from gstreamer called by the idle GSource in the mainloop to feed the data into appsrc.
	 */
	static gboolean bReadData();
	/**
	 * call back from gstreamer timer expiry to RampUp audio when new data is recieved.
	 */
	static gboolean bRampUp();
	/**
	 * call back from gstreamer timer expiry to RamDown audio when no data is available.
	 */
	static gboolean bRampDown();
	/**
	    * call back from gstreamer when there is notification from decoder for "last frame" property
	    */
	static void vGetFrameUpdate(GstElement * pipeline, guint size);
	/**
	    * method to update frame related status variables( status is received from decoder)
	    */
	void vGetFrameStatusFromDecoder();
	/**
	 * static pointer used in call back functions
	 */
	static appSourcePlayer* m_poAppSourcePlayer;
	/**
	 * static thread mutex used for sync
	 */
	static pthread_mutex_t lock;
	/**
	    * static thread mutex used for player state (Play, pause, stop)
	    */
	static pthread_mutex_t playerlock;
	/**
	    * static thread mutex used during createpipeline and deletepipeline
	    */
	static pthread_mutex_t CleanPipelineLock;
   /**
       * set player state to PLAY / PAUSE / STOP
       */
   void vSetPlayerState(bool bNewValue);
   /**
       * variables to store sampling rate, audio mode and SBR flag value from ADR
       */
	unsigned int m_AudioSamplingRate, m_AudioMode, m_SBRFlag;

protected:
	/**
	    * The sink name of the code.
	    */
	   tunerString m_SinkName;
	   /**
	    * buffer to hold gstElements name
	    */
	   tunerVector<tunerString> m_gstElements;
private:
	/**
	 * Creates gstreamer elements and setup the pipeline
	 */
	static void* vCreatePipeline(void *);
	/**
	 * Creates gstreamer elements required for playbin application and set up the pipeline
	 */
	static void* vCreatePlayBinPipeLine(void *);
	/**
	 * Creates elements required for playbin application
	 */
	void vCreatePlayBinElements();
	/**
	 * Exits the main decoding loop
	 */
	void vQuitPipeline();
	/**
	 * Creates gStreamer appsrc elements
	 */
	void vCreateElements();
	/**
	 * Sets the initial volume of the volume element to 0
	 */
	void vSetInitialVolumetoZero();
	/**
	 * the sink for ALSA will be set by this function
	 */
	void vSetupSink();
	/**
	 * the sink for ALSA will be set by this function
	 */
	void vSetupFileSink();
	/**
	 * Registers the required call backs
	 */
	void vSetCallBacks();
	/**
	 * Links all gstElements in the pipeline
	 */
	bool bLinkElements();
	/**
	 * Set playbin properties
	 */
	void vLinkSink();
	/**
	 * Initiates the loop (thread) for running the pipeline
	 */
	void vStartLoop();
	/**
	 * Sets pipeline to initial state
	 */
	void vSetupLoop();
	/**
	 * Cleans up pipeline after main loop is exited
	 */
	void vCleanPipeLine();
	/**
	 * Puts the data into the buffer from which appsrc will read
	 */
	gboolean bSendNextFrame();
	/**
	 * Function to read the data size need tobe put into the buffer from which appsrc will read
	 */
	int u32GetReadSize();
	/**
	 * Demutes the audio signal
	 */
	void deMute();
	/**
	 * mutes the audio signal
	 */
	void mute();
	/**
	 * carries out pending activities once mute is completed.
	 */
	void vOnMuteComplete();
	/**
	 * push buffer data into stream.
	 */
	void vPushData(guint bufferSize);
	/**
	    * store player element into variable m_player
	    */
	void vStorePlayerElement();
	/**
	    * store capsfilter element into variable m_capsfilter
	    */
	void vStoreCapsFilter();
	/**
	    * store capsfilter element into variable m_queue2
	    */
	void vStoreQueueElement();
	/**
	    * configure caps filter
	    */
	void vSetCaps();
	/**
	 *
	 */
	GstElement* getVolumeElement();
	/**
	 * Indicates if end of Buffer is reached.
	 */
	gboolean bIsBufferEnd();
	/**
	 * Indicates if buffer overflow is reached.
	 */
	gboolean bIsBufferOverflow();
	/**
	    * Scedule DRM thread to RT priority
	    */
	void SetMaxPriority();

	gboolean bSendFrame;
	
	bool m_bCleanPipelineInProgress, m_bIsPrioChanged;
	/**
       * Get value of clean pipeline state (whether clean completed / not)
       */
	bool bGetCleanPipeLineState();
	/**
       * set value of clean pipeline state (whether clean completed / not)
       */
	void vSetCleanPipeLineState(bool bNewValue);
	/**
	 * Resets the pipeline.
	 */
	void vResetPipeline();
	/**
	 * Send EOS to the pipeline.
	 */
	void vSendEOSEvent();
	/**
	 * Change pipeline to  NULL state
	 */
	void vChangeStateToNull();
	/**
    * read AudioInfoEntity value from ADR
    */
   void vReadAudioInfoEntity(clCMDRMAudioLogicalFrameStatus* frameData);
   /**
       * return value of DRM thread creation
       */
   unsigned int m_pthreadcreate_returnvalue;
   /**
   * re-configure the pipeline with new data from ADR
   */
   void vSetNewConfiguration(unsigned char TwoBitAudioMode , unsigned int u32tempSampleRate, unsigned char OneBitSBRFlag);

   bool vGetPlayerState();

   bool m_bFirstFrame, m_bSetPlayerState;
	/**
	 * pointer to source instance
	 */
	GstAppSrc* m_source;
	/**
	 * pointer to various gstreamer elements
	 */
	GstElement* m_pipeline, *m_player, *m_sink, *m_volume, *m_sinkBin, *m_capsfilter, *m_queue2;
	/**
	 * buffer to hold gstElements
	 */
	tunerVector<GstElement*> m_Elements;
	/**
	 * pointer of the bus instance
	 */
	GstBus *m_bus;
	/**
	 * <not used currently>
	 */
	//guint sourceId;
	/**
	 * timer instance <Currently not used>
	 */
	//GTimer* timer;
	/**
	 * boolean which informs if new data is required or not
	 */
	bool bNeedData;
	/**
	 * boolean which informs if end of stream is reached.
	 */
	bool bIsEndOfStream;
	/**
	 * boolean which informs if mute demute has to be fast mute or ramp mute.
	 */
	bool bApplyAudioRamp;
	/**
	 * informs about a pending action to be taken after mute completion
	 */
	//GstState pendingState;
	/**
	 *informs exactly the amount of bytes requested in the need-data signal
	 */
	//guint requestedBufferSize;
	/**
	 * buffer to hold new application data
	 */
	tunerVector<clCMDRMAudioLogicalFrameStatus*> drmFrames;

	unsigned char m_Action;
	/**
	 * pointer to loop instance
	 */
	GMainLoop *m_loop;

	//GstState beforeBuf_OverflowpipeState;
	bool blIsBufferOverFlow , bIsAppReady;
	sem_t semaphore;
	pthread_t thread;
	tunerVector<unsigned char> audioInfoEntity;
};
}
}
#endif // !defined(EA_13CB9D3B_F200_400d_9C8A_24883127D2FF__INCLUDED_)
