/**************************************************************************//**
* \file     tunerDatatypes.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef tunerDatatypes_h
#define tunerDatatypes_h


namespace tuner
{
   namespace common
   {
      enum enSourceId
      {
         #define TUNER_SOURCE(sourceId)       sourceId,
         #include "tunerDatatypes.dat"
         #undef TUNER_SOURCE
         SOURCEID_LIMIT
      };

      enum enBand
      {
         #define TUNER_BAND(band)       band,
         #include "tunerDatatypes.dat"
         #undef TUNER_BAND
         BAND_LIMIT
      };

      enum enSourceType
      {
         #define TUNER_SOURCETYPES(sourceType)       sourceType,
         #include "tunerDatatypes.dat"
         #undef TUNER_SOURCETYPES
         SOURCETYPE_LIMIT
      };

      enum enMuteState
      {
         #define TUNER_MUTESTATES(muteState)       muteState,
         #include "tunerDatatypes.dat"
         #undef TUNER_MUTESTATES
         MUTESTATE_UNKNOWN
      };

      enum enSrcActivity
      {
         #define TUNER_SRCACTIVITY(srcActivity)       srcActivity,
         #include "tunerDatatypes.dat"
         #undef TUNER_SRCACTIVITY
         SRCACTIVITY_UNKNOWN
      };
		 
      enum enTunerState
      {
         #define TUNER_STATE(tunerState)       tunerState,
         #include "tunerDatatypes.dat"
         #undef TUNER_STATE
         TUNERSTATE_UNKNOWN
      };
	  
	  enum enAnnouncement
      {
         #define TUNER_ANNOUNCEMENTS(announcementId)       announcementId,
         #include "tunerDatatypes.dat"
         #undef TUNER_ANNOUNCEMENTS
         ANNOUNCEMENT_LIMIT
      };

	  enum enTpState
      {
         #define TUNER_TPSTATE(tpState)       tpState,
         #include "tunerDatatypes.dat"
         #undef TUNER_TPSTATE
         TPSTATE_LIMIT
      };
	  enum enStationListBandBit
      {
         #define TUNER_STATIONLIST_BAND_BIT(stationListBandBit)       stationListBandBit,
         #include "tunerDatatypes.dat"
         #undef TUNER_STATIONLIST_BAND_BIT
         STATIONLISTBANDBIT_LIMIT
      };
	  enum enStationListID
      {
         #define TUNER_STATIONLIST_ID(stationListId)       stationListId,
         #include "tunerDatatypes.dat"
         #undef TUNER_STATIONLIST_ID
         STATIONLISTID_LIMIT
      };
	  enum enTunerClient
	  {
		 #define TUNER_CLIENT(tunerClient)  tunerClient,
		 #include "tunerDatatypes.dat"
		 #undef TUNER_CLIENT
		 TUNERCLIENT_LIMIT
	  };
	  enum enTunerClientAvailability
	  {
		 #define TUNER_CLIENT_AVAILABLITY(tunerClientAvailability) tunerClientAvailability,
		 #include "tunerDatatypes.dat"
		 #undef TUNER_CLIENT_AVAILABLITY
		 TUNERCLIENTAVAILABITY_LIMIT
	  };
	  enum enAudioSrcAvailability
	  {
		#define AUDIO_SOURCE_AVAILABILITY(audioSrcAvailability) audioSrcAvailability,
		#include "tunerDatatypes.dat"
		#undef AUDIO_SOURCE_AVAILABILITY
		 AUDIOSOURCEAVAILABILITY__LIMIT
	  };

	  enum enAudioSourceAvailabiltyReason
	  {
		#define AUDIO_SOURCE_AVAILABILITY_REASON(audioSrcAvailabilityReason) audioSrcAvailabilityReason,
		#include "tunerDatatypes.dat"
		#undef AUDIO_SOURCE_AVAILABILITY_REASON
		AUDIOSOURCEAVAILABILITYREASON__LIMIT
	  };

	  enum enSessionState
	  {
		#define TUNER_SESSIONSTATE(sessionState)       sessionState,
		#include "tunerDatatypes.dat"
		#undef TUNER_SESSIONSTATE
		SESSIONSTATE_LIMIT
	  };
}
}


#endif // tunerDatatypes_h
