/**************************************************************************//**
* \file     clFile.cpp
*
*           clFile method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "common/utilities/clFile.h"
using namespace tuner::common::utilities;


/**************************************************************************//**
* Constructor
******************************************************************************/
clFile::clFile()
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clFile::~clFile()
{
}


/**************************************************************************//**
* 
******************************************************************************/
tunerVector< unsigned char> clFile::read(tunerString oFileName )
{
   if (!oFileName.empty())
   {
      FILE* tunerFile = fopen(oFileName.c_str(), "rb");
      if (tunerFile != NULL)
      {
         int u32Size =0;
         fseek(tunerFile, 0, SEEK_END);
         u32Size = (int)ftell( tunerFile );

         try
         {
    		 tunerVector< unsigned char> BinData(u32Size);
        	 if (u32Size > 0 )
    		 {
    				 /*Coverity 29956*/
    				 fseek(tunerFile, 0, SEEK_SET);
    				 size_t iResult = 0;
    				 iResult = fread((&BinData[0]), u32Size, 1, tunerFile);

    				 if (iResult == (size_t)u32Size)
    				 {
    					 fclose(tunerFile);
    					 /*Coverity 29920 , checking returned total number of elements successfully read */
    					 /*If not same empty vector is returned*/
    					 return BinData;
    				 }
    		  }
         }
         catch(std::bad_alloc)
         {

         }
	     fclose(tunerFile);
       }
   }
   tunerVector< unsigned char> EmptyData;
   return EmptyData;
}



/**************************************************************************//**
* 
******************************************************************************/
void clFile::write(tunerString oFileName, tunerVector< tU8> oBinData )
{
   if (!oFileName.empty())
   {
      FILE* tunerFile = fopen(oFileName.c_str(), "wb");
      if (tunerFile == NULL)
      {
        // tunerFile = OSAL_IOCreate(oFileName.c_str(), OSAL_EN_READWRITE);
      }
      if (tunerFile != NULL)
      {
         fwrite((&oBinData[0]), oBinData.size(), 1, tunerFile);
         fclose(tunerFile);
      }
   }
}
