#ifndef _RADIODNSMAP_H
#define _RADIODNSMAP_H

#include <cmath>
#include <string>
#include <cstring>

using namespace std;

#define TWO_CHARACTER 2
#define FIVE_CHARACTER 5
#define FOUR_BYTES 4

struct stCountryCodeMap
{
	short sCountry;
	double latitude;
	double longitude;
	string isoCountryCode;
	string extendedCountryCode;
	string rdsPiCountryCode;
	string neighbourCountryCode;
};

short sGetCountry(double latitude, double longitude);
string strGetExtendedCountryCodeFromCountryCodeMap(short country, string rdsPiCountryCode, double latitude, double logitude);
string strGetProperEccFromNeighbourCountryCode(string rdsPiCountryCode, string neighbourCountryCodes, double latitude, double longitude);
string strGetEccFrom2IsoCountryCode(string rdsPiCountryCode, string neighbourCountryCodes, double latitude, double longitude);

#endif
