#include "radiodnsMap.h"

static stCountryCodeMap astCountryCodeMap[] =
{
   #define COUNTRYCODE_MAP(countryName, latitude, longitude, isoCountryCode, extendedCountryCode, rdsPiCountryCode, neighbourCountryCode) { countryName, latitude, longitude, isoCountryCode, extendedCountryCode, rdsPiCountryCode, neighbourCountryCode},
   #include "radiodnsCountryCodeMap.dat"
   #undef COUNTRYCODE_MAP
};

short sGetCountry(double latitude, double longitude)
{
	/*Calculating minimum distance based on euclidean distance */
	const int mapSize = sizeof astCountryCodeMap / sizeof(stCountryCodeMap);
	int countryNameIndex = 0;
	double currentDistance = 0;
	short country = -1;
	bool bCountryFound = false;
	double previousDistance = sqrt( pow( (astCountryCodeMap[0].longitude-longitude), 2) + pow( (astCountryCodeMap[0].latitude-latitude), 2) );

	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		currentDistance = sqrt( pow( (astCountryCodeMap[u32Index].longitude-longitude), 2) + pow( (astCountryCodeMap[u32Index].latitude-latitude), 2) );
		if(currentDistance < previousDistance)
		{
			countryNameIndex = u32Index;
			previousDistance = currentDistance;
			bCountryFound = true;
		}
	}
	if(bCountryFound)
	{
		country = astCountryCodeMap[countryNameIndex].sCountry;
	}
	return country;
}

string strGetExtendedCountryCodeFromCountryCodeMap(short country, string rdsPiCountryCode, double latitude, double longitude)
{
	string strEccCode = "XXXX";
	const int mapSize = sizeof astCountryCodeMap / sizeof(stCountryCodeMap);
	if((country != -1) && ((int)country <= mapSize))
	{
		if(country == astCountryCodeMap[country-1].sCountry)
		{
			if(rdsPiCountryCode == astCountryCodeMap[country-1].rdsPiCountryCode)
			{
				strEccCode = astCountryCodeMap[country-1].extendedCountryCode;
			}
			else if( strstr(const_cast<char *>(astCountryCodeMap[country-1].rdsPiCountryCode.c_str()), const_cast<char *>(rdsPiCountryCode.c_str())) != NULL)
			{
				strEccCode = astCountryCodeMap[country-1].extendedCountryCode;
			}
			else
			{
				strEccCode = strGetProperEccFromNeighbourCountryCode(rdsPiCountryCode, astCountryCodeMap[country-1].neighbourCountryCode, latitude, longitude);
			}
		}
	}
	return strEccCode;
}

string strGetProperEccFromNeighbourCountryCode(string rdsPiCountryCode, string neighbourCountryCodes, double latitude, double longitude)
{
	string strEccCode = "XXXX";
	const int mapSize = sizeof astCountryCodeMap / sizeof(stCountryCodeMap);
	string strIsoCountryCode = "XX";
	//Fix for NCG3D-145469 & NCG3D-146050
	rdsPiCountryCode += string(":");
	char *pIsoCountryCode = strstr(const_cast<char *>(neighbourCountryCodes.c_str()), const_cast<char *>(rdsPiCountryCode.c_str()));
	if(pIsoCountryCode != nullptr)
	{
		strncpy(const_cast<char *>(strIsoCountryCode.c_str()), pIsoCountryCode+TWO_CHARACTER, 2);
		if(string(pIsoCountryCode).size() > FOUR_BYTES)
		{
			char *pIsoCountryCode2 = strstr(const_cast<char *>(pIsoCountryCode+FIVE_CHARACTER), const_cast<char *>(rdsPiCountryCode.c_str()));
			if(pIsoCountryCode2 != nullptr)
			{
				string strIsoCountryCode2 = "XX";
				strncpy(const_cast<char *>(strIsoCountryCode2.c_str()), pIsoCountryCode2+2, 2);
				return strGetEccFrom2IsoCountryCode(strIsoCountryCode, strIsoCountryCode2, latitude, longitude);
			}
		}
		for (int u32Index = 0; u32Index < mapSize; u32Index++)
		{
			if(strIsoCountryCode == astCountryCodeMap[u32Index].isoCountryCode)
			{
				strEccCode = astCountryCodeMap[u32Index].extendedCountryCode;
				break;
			}
		}
	}
	return strEccCode;
}

string strGetEccFrom2IsoCountryCode(string strIsoCountryCode1, string strIsoCountryCode2, double latitude, double longitude)
{
	string strEccCode = "XXXX";
	if(strIsoCountryCode1 == "XX" || strIsoCountryCode2 == "XX")
	{
		return strEccCode;
	}
	const int mapSize = sizeof astCountryCodeMap / sizeof(stCountryCodeMap);
	int u32Index1 = 0, u32Index2 = 0;
	bool bCountryFound = false;
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if(strIsoCountryCode1 == astCountryCodeMap[u32Index].isoCountryCode)
		{
			u32Index1 = u32Index;
			bCountryFound = true;
			break;
		}
	}
	double distance1 = 0;
	if(bCountryFound)
	{
		distance1 = sqrt( pow( (astCountryCodeMap[u32Index1].latitude-latitude), 2) + pow( (astCountryCodeMap[u32Index1].longitude-longitude), 2) );
	}
	bCountryFound = false;
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if(strIsoCountryCode2 == astCountryCodeMap[u32Index].isoCountryCode)
		{
			u32Index2 = u32Index;
			bCountryFound = true;
			break;
		}
	}
	double distance2 = 0;
	if(bCountryFound)
	{
		distance2 = sqrt( pow( (astCountryCodeMap[u32Index2].latitude-latitude), 2) + pow( (astCountryCodeMap[u32Index2].longitude-longitude), 2) );
	}

	if(distance1 < distance2)
	{
		strEccCode = astCountryCodeMap[u32Index1].extendedCountryCode;
	}
	else
	{
		strEccCode = astCountryCodeMap[u32Index2].extendedCountryCode;
	}
	return strEccCode;
}
