#include "clExtCountryCode.h"

#include "../tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_SESSIONMANAGEMENT
#include "trcGenProj/Header/clExtCountryCode.cpp.trc.h"
#endif

using namespace tuner::common::radiodnsecc;

clExtCountryCode* clExtCountryCode::m_poExtCountryCode = NULL;

clExtCountryCode::clExtCountryCode()
{
	m_currentPosition.latitude = 0.0;
	m_currentPosition.longitude = 0.0;
	m_currentCountry = -1;
	m_currentExtendedCountryCode = "XXXX";
	m_currentRdsPiCountryCode = 0xff;
}

clExtCountryCode* clExtCountryCode::instance()
{
	if (m_poExtCountryCode == 0)
	{
		m_poExtCountryCode = new clExtCountryCode();
	}
	return m_poExtCountryCode;
}

string clExtCountryCode::strGetExtendedCountryCode(double latitude, double longitude, char rdsPiCountryCode)
{
	ETG_TRACE_USR4(("clExtCountryCode::strGetExtendedCountryCode() (Latest) Latitude : %f, Longitude: %f, PiCode: %c", (tFloat)latitude, (tFloat)longitude, rdsPiCountryCode));
//	printf("clExtCountryCode::strGetExtendedCountryCode() (Latest) Latitude : %f, Longitude: %f, PiCode: %c", latitude, longitude, rdsPiCountryCode);
	ETG_TRACE_USR4(("clExtCountryCode::strGetExtendedCountryCode() (Previous) Latitude : %f, Longitude : %f m_currentRdsPiCountryCode : %c", (tFloat)m_currentPosition.latitude, (tFloat)m_currentPosition.longitude, m_currentRdsPiCountryCode));
	/*Fix for NCG3D-88479, check for change in RDS country code to evaluate ECC*/
	if(m_currentPosition.latitude  == latitude && m_currentPosition.longitude == longitude && rdsPiCountryCode == m_currentRdsPiCountryCode)
	{
		return m_currentExtendedCountryCode;
	}
	m_currentPosition.latitude  = latitude;
	m_currentPosition.longitude = longitude;
	short sLatestCountry = sGetCountry(latitude, longitude);
	if(isalpha(rdsPiCountryCode))
	{
		rdsPiCountryCode = (char)toupper(rdsPiCountryCode);
	}
	if(m_currentCountry == sLatestCountry && rdsPiCountryCode == m_currentRdsPiCountryCode)
	{
		return m_currentExtendedCountryCode;
	}
	if(sLatestCountry != -1)
	{
		ETG_TRACE_USR4(("clExtCountryCode::strGetExtendedCountryCode() Country name for latitude: %f longitude: %f is near to central location of %d\n", (tFloat)latitude,(tFloat) longitude, sLatestCountry ));
//		printf("clExtCountryCode::strGetExtendedCountryCode() Country name for latitude: %f longitude: %f is near to central location of %d\n", latitude, longitude, sLatestCountry );
		m_currentCountry = sLatestCountry;
		m_currentExtendedCountryCode = strGetExtendedCountryCodeFromCountryCodeMap(sLatestCountry, string(1, rdsPiCountryCode), latitude, longitude);
		m_currentRdsPiCountryCode = rdsPiCountryCode;
	}
	return m_currentExtendedCountryCode;
}

#if 0
int main (int argc, char* argv[]) {

  if(argc < 4)
  {
	  cout << "Usage: ./a.out Latitude Longitude PiCountryCode" << endl;
	  return 1;
  }

  clExtCountryCode* pobjExtCountryCode = clExtCountryCode::instance();
  if(pobjExtCountryCode == NULL)
  {
	  return 2;
  }
  int start_s=clock();
  string str = pobjExtCountryCode->strGetExtendedCountryCode(strtod(argv[1], NULL), strtod(argv[2], NULL), *argv[3]);
  int stop_s=clock();
  cout << "extended country code : "  << str << endl;
  cout << "time: " << (stop_s-start_s)/double(CLOCKS_PER_SEC)*1000 << endl;
  return 0;
}
#endif
