/**************************************************************************//**
* \file     clServerProperty.h
*
*           See .cpp file for description.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clServerProperty_h
#define clServerProperty_h


#include "CcaApp/clFunction.h"

#include <vector>


#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "common_fi_if.h"

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

namespace tuner
{
   namespace CcaApp
   {
      class clServerProperty : public tuner::CcaApp::clFunction
      {
      public:
         virtual ~clServerProperty();
         clServerProperty(tU16 u16FunctionID, tuner::CcaApp::clCCAhandler* poCCAhandler);
         virtual tVoid vHandleMessage(amt_tclServiceData* poInMsg);
         virtual tVoid vConstructSelfPostMessage(unsigned char* puchData);

      protected:
         virtual tVoid vGet(amt_tclServiceData* poInMsg) = 0;
         virtual tVoid vSet(amt_tclServiceData* poInMsg) = 0;
         virtual tVoid vUpreg(amt_tclServiceData* poInMsg) = 0;
         tVoid vStatus(fi_tclTypeBase& oPayload);
         tVoid vStatus(fi_tclTypeBase& oPayload,tU16 u16AppID);
         tVoid vError(tU16 u16FunctionID,tU16 u16ErrorCode);
         virtual tVoid vSendMessage( tU16             u16DestAppID,
                                   fi_tclTypeBase&  oOutData,
                                   tU16             u16Fid,
                                   tU8              u8OpCode,
                                   tU16             u16CmdCtr,
                                   tU16             u16RegId);

      private:
         /* +++ Enter your internal Data here */
         ahl_tclNotificationTable* m_poNotificationTable;
         tU16 m_u16DestAppID;
         tU16 m_u16RequestCmdCtr;
         tU32 m_u32RequestType;
         tU16 m_u16RegisterId;
         tVoid vAddToNotificationTable(amt_tclServiceData* poInMessage);
         tVoid vRemoveFromNotificationTable(amt_tclServiceData* poInMessage);
         tVoid vStatusToRegisteredClients(fi_tclTypeBase& oOutData);
         tVoid vStatusToRegisteredClientID(fi_tclTypeBase& oOutData , tU16 u16ClientID);
         tVoid vSaveResponseParameters(amt_tclServiceData* poInMessage);
         clServerProperty(const clServerProperty& oclServerProperty);
         clServerProperty& operator=(const clServerProperty& oclServerProperty);

      };
   }
}


#endif
