/**************************************************************************//**
* \file     clFunction.h
*
*           Base class for CCA functions.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clFunction_h
#define clFunction_h

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif


namespace tuner
{
   namespace CcaApp
   {
      class clCCAhandler;


      class clFunction
      {
      public:
         virtual ~clFunction();
         clFunction(tU16 u16FunctionID, tuner::CcaApp::clCCAhandler* poCCAhandler);
         virtual tVoid vHandleMessage(amt_tclServiceData* poInMsg) = 0;
         tU16 u16GetFunctionID(tVoid);

      protected:
         tuner::CcaApp::clCCAhandler* m_poCCAhandler;

      private:
         tU16 m_u16FunctionID;
      };
   }
}

#endif 
