/**************************************************************************//**
* \file     clClientProperty.h
*
*           See .cpp file for description.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clPropertyClient_h
#define clPropertyClient_h


#include "CcaApp/clFunction.h"

#include <vector>


#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "common_fi_if.h"


namespace tuner
{
   namespace CcaApp
   {
      class clClientPropertyObserver;


      class clClientProperty : public tuner::CcaApp::clFunction
      {
      public:
         virtual ~clClientProperty();
         clClientProperty(tU16 u16FunctionID, clCCAhandler* poCCAhandler);
         virtual tVoid vHandleMessage(amt_tclServiceData* poInMsg);
         tVoid vRegisterObserver(tuner::CcaApp::clClientPropertyObserver* poObserver);

      protected:
         virtual tVoid vStatus(amt_tclServiceData* poInMsg) = 0;
         virtual tVoid vError(amt_tclServiceData* poInMsg);
         tVoid vSet(fi_tclTypeBase& oPayload);
         tVoid vNotifyObservers();

      private:
         std::vector<tuner::CcaApp::clClientPropertyObserver* > m_observers;
      };
   }
}

#endif
