/*****************************************************************************
* FILE:         clCCAhandler.cpp
* PROJECT:      G3G project
* SW-COMPONENT: __COMPONENT__
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) __YEAR__ Robert Bosch GmbH, Hildesheim
*****************************************************************************/


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#include "midw_fi_if.h"

#include "CcaApp/clCCAhandler.h"
#include "CcaApp/clFunction.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "tuner_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_CCA_HANDLER
#include "trcGenProj/Header/clCCAhandler.cpp.trc.h"
#endif

using namespace tuner::CcaApp;

/*******************************************************************************
*
*
*******************************************************************************/
clCCAhandler::clCCAhandler(ail_tclAppInterface *poMainApp, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16TargetAppID, tU16 u16SourceAppID)
{
   m_u16MajorVersion = u16ServiceMajorVersion;
   m_u16MinorVersion = u16ServiceMinorVersion;
   m_u16ServiceID = u16ServiceID;
   m_poMainApp = poMainApp;
   m_u16TargetAppID = u16TargetAppID;
   m_u16SourceAppID = u16SourceAppID;
   m_u16InvalidOpCodeError = 0xFF;
   m_u16RegisterId = 0;
}

/*******************************************************************************
*
*
*******************************************************************************/
clCCAhandler::~clCCAhandler(tVoid)
{
   m_poMainApp = NULL;
   tU32 u32VecSize = (tU32)m_VectorFunction.size();
   for (tU32 u32VecCount = 0; u32VecCount < u32VecSize; u32VecCount++)
   {
      OSAL_DELETE m_VectorFunction.at(u32VecCount);
   }
   m_VectorFunction.clear();
}



/*******************************************************************************
*
*******************************************************************************/
tVoid clCCAhandler::vStartInitSequence(tU16 /*u16FunctionId */) 
{

}



/*******************************************************************************
*
*******************************************************************************/
tVoid clCCAhandler::vHandleCCAErrorMessage(amt_tclServiceData* poInMsg) 
{
   amt_tclServiceDataError oErrorMsg( poInMsg );
   tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
   /* Trace CCA Error message */
   tU16 u16TargetAppId = u16GetM_TARGET_CCA_APP();
   tU16 u16ServiceId = u16GetM_TARGET_CCA_SRV();

   /* ERROR Trace */
   ETG_TRACE_ERR(("Error received: app 0x%x, service 0x%x, fid 0x%x, error 0x%x", u16TargetAppId, u16ServiceId , poInMsg->u16GetFunctionID(), u16ErrorCode ));

   if (AMT_C_U8_CCAMSG_OPCODE_ERROR == poInMsg->u8GetOpCode())
   {
       if ((poInMsg->u16GetCmdCounter() == TPEG_UPREG_CMD_COUNTER) || (poInMsg->u16GetCmdCounter() == AHL_UPREG_CMD_COUNTER))
       {
           // seems that UPREG failed, so try again
           ETG_TRACE_ERR(("UpReg Failed, FunctionID 0x%x, ErrorCode 0x%x", poInMsg->u16GetFunctionID(), u16ErrorCode));
           oFiRegHelper.vSetRetValForRegister(poInMsg->u16GetFunctionID(), FALSE);
       }
   }
}


/*******************************************************************************
*
*******************************************************************************/
tVoid clCCAhandler::vSendEmptyMessage(tU16 /*u16DestAppID*/,
                                      tU16 u16CmdCtr,
                                      tU16 u16RegID,
                                      tU16 u16Fid,
                                      tU8 u8Opcode)
{
   gm_tclEmptyMessage oOutMessage
      (
      m_u16SourceAppID,           /*  AppID of this application-HMI  */
      u16GetM_TARGET_CCA_APP(),        /*  AppID of target - VC FC */
      u16RegID,                        /*  RegId for the service */
      u16CmdCtr,                       /*  Command counter */
      u16GetM_TARGET_CCA_SRV(),        /*  the SID of the service  */
      u16Fid,                          /*  the u16Fid to register for   */
      u8Opcode                         /*  OPCODE */
      );
   vTraceCCAMessage(&oOutMessage);

   if (AIL_EN_N_NO_ERROR == m_poMainApp->enPostMessage( &oOutMessage, TRUE ))
   {
      ETG_TRACE_USR4(("vSendEmptyMessage: Empty Message sending passed for function ID: 0x%x", u16Fid));
   }
   else
   {
      ETG_TRACE_ERR(("vSendEmptyMessage: Empty Message sending failed for function ID: 0x%x", u16Fid));
   }
}


/*******************************************************************************
*
*******************************************************************************/
tVoid clCCAhandler::vTpegSendErrorMessage(tU16 u16FunctionId, tU16 u16ErrorId) 
{
   vSendErrorMessage(u16FunctionId, u16ErrorId);
}


/*******************************************************************************
*
*******************************************************************************/
tVoid clCCAhandler::vSendErrorMessage( tU16 u16Fid , tU16 u16ErrorCode )
{
   gm_tclU16Message  oSendErrorMessage( 
      m_u16SourceAppID,                /* tU16 u16Source      */
      u16GetM_TARGET_CCA_APP(),            /* tU16 u16Target      */
      u16GetRegID(),                      /* tU16 u16RegID       */
      0,                               /* tU16 u16CmdCounter  */
      u16GetM_TARGET_CCA_SRV(),            /* tU16 u16SvcID       */
      u16Fid ,                         /* tU16 u16Fid         */
      AMT_C_U8_CCAMSG_OPCODE_ERROR );  /* tU8  u8OpCode       */
   
   /* Set the error code */
   oSendErrorMessage.vSetWord ( u16ErrorCode );
   
   if (oSendErrorMessage.bIsClientMessage())
   {
      oSendErrorMessage.vSetSourceSubID(AMT_C_U16_DEFAULT_NULL);
   }

   /* Enpost the message and check the return value */
   /* all the other error conditions are handled in enPostMyMessage function */
   if ( AIL_EN_N_NO_ERROR == m_poMainApp->enPostMessage( &oSendErrorMessage, TRUE ) )
   {
      ETG_TRACE_USR4(("vSendErrorMessage: Error Message sending passed for function ID: 0x%x  and Errorcode : 0x%x", u16Fid, u16ErrorCode));
   }
   else
   {
      ETG_TRACE_ERR(("vSendErrorMessage: Error Message sending failed for function ID: 0x%x  and Errorcode : 0x%x", u16Fid, u16ErrorCode));
   }
}






/*************************************************************************//**
* \brief This function converts Amt message to visitor class and get the data
*        from visitor to the Fi class
*****************************************************************************/
tVoid clCCAhandler::vSendMessage(tU16 u16DestAppID,
                                 tU16 u16CmdCtr,
                                 tU16 u16RegId,
                                 fi_tclTypeBase& oOutData,
                                 tU16 u16Fid,
                                 tU8 u8OpCode)
{
   /* Create the Visitor Message */

   /*Check code here*//* check the 2nd parameter */
   fi_tclVisitorMessage oOutVisitorMsg(oOutData,m_u16MajorVersion);

   /* Set the CCA message information */
   oOutVisitorMsg.vInitServiceData(
      m_u16SourceAppID,                  /* Source app-ID */
      u16DestAppID,                      /* Dest. app-ID */
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, /* stream type*/
      0,                                 /* stream counter*/
      u16RegId,                          /* Registry ID */
      u16CmdCtr,                         /* Command counter */
      u16GetM_TARGET_CCA_SRV(),          /* Service-ID */
      u16Fid,                            /* Function-ID */
      u8OpCode,                          /* OpCode */
      0,                                 /* ACT */
      0,                                 /* Source sub-ID */
      0 );                               /* Dest. sub-ID */

   vTraceCCAMessage(&oOutVisitorMsg);

   if ( AIL_EN_N_NO_ERROR == m_poMainApp->enPostMessage( &oOutVisitorMsg, TRUE ) )
   {
      ETG_TRACE_USR4(("vSendMessage sending passed for function ID: 0x%x  and u8OpCode : 0x%x", u16Fid, u8OpCode));
   }
   else
   {
      ETG_TRACE_ERR(("vSendMessage sending failed for function ID: 0x%x  and u8OpCode : 0x%x", u16Fid, u8OpCode));
   }

}




/**************************************************************************//**
* 
******************************************************************************/
tVoid clCCAhandler::vTpegSendErrorMessage(tU16 u16DestAppID,
                                         tU16 u16CmdCounter,
                                         tU16 u16RegId,
                                         tU16 u16Fid,
                                         tU16 u16ErrorCode)
{
   gm_tclU16Message  oSendErrorMessage( 
      m_u16SourceAppID,               /* tU16 u16Source    */
      u16DestAppID,                   /* tU16 u16Target    */
      u16RegId,                       /* tU16 u16RegID     */
      u16CmdCounter,                  /* tU16 u16CmdCounter*/
      u16GetM_TARGET_CCA_SRV(),       /* tU16 u16SvcID     */
      u16Fid ,                        /* tU16 u16Fid       */
      AMT_C_U8_CCAMSG_OPCODE_ERROR ); /* tU8  u8OpCode     */
   
   /* Set the error code */
   oSendErrorMessage.vSetWord ( u16ErrorCode );

   vTraceCCAMessage(&oSendErrorMessage);
   
   /* Enpost the message and check the return value */
   /* all the other error conditions are handled in enPostMyMessage function */
   if ( AIL_EN_N_NO_ERROR == m_poMainApp->enPostMessage( &oSendErrorMessage, TRUE ) )
   {
      ETG_TRACE_USR4(("vTpegSendErrorMessage sending passed for function ID: 0x%x  and Errorcode : 0x%x", u16Fid, u16ErrorCode));
   }
   else
   {
      ETG_TRACE_ERR(("vTpegSendErrorMessage sending failed for function ID: 0x%x  and Errorcode : 0x%x", u16Fid, u16ErrorCode));
   }
}


/*******************************************************************************
*
*******************************************************************************/
tBool clCCAhandler::bTpegSendCCAMessage(tU16 u16FunctionId, tU8 u8OpCode) 
{
   tBool bRetVal = FALSE;
   tU16  u16CmdCounter = 0;
   if (u8OpCode == AMT_C_U8_CCAMSG_OPCODE_UPREG)
   {
      u16CmdCounter = TPEG_UPREG_CMD_COUNTER;
   }
   gm_tclEmptyMessage oOutMessage
      (
      m_u16SourceAppID,
      u16GetM_TARGET_CCA_APP(),
      u16GetRegID(),
      u16CmdCounter,
      u16GetM_TARGET_CCA_SRV(),
      u16FunctionId,
      u8OpCode
      );

   if (AIL_EN_N_NO_ERROR == m_poMainApp->enPostMessage( &oOutMessage, TRUE ))
   {
      ETG_TRACE_USR4(("bTpegSendCCAMessage sending passed for function ID: 0x%x", u16FunctionId));
      bRetVal = TRUE;
   }
   else
   {
      ETG_TRACE_ERR(("bTpegSendCCAMessage sending failed for function ID: 0x%x", u16FunctionId));
   }

   return bRetVal;
}

/*******************************************************************************
*
*******************************************************************************/
tBool clCCAhandler::bTpegSendCCAMessage(tU16 u16Fid,
                               tU8  u8OpCode,
                               fi_tclTypeBase& oOutData,
                               tU8  u8StreamType,
                               tU8  u8StreamCounter) 
{
   tBool bRetVal = FALSE;
   tU16  u16CmdCounter = 0;

   if (u8OpCode == AMT_C_U8_CCAMSG_OPCODE_UPREG)
   {
      u16CmdCounter = TPEG_UPREG_CMD_COUNTER;
   }
   fi_tclVisitorMessage oMessage(oOutData, m_u16MajorVersion);
   
   /* Set the CCA message information */
   oMessage.vInitServiceData(  
      m_u16SourceAppID,         /* u16Source */
      u16GetM_TARGET_CCA_APP(), /* u16Target */
      u8StreamType,             /* u8StreamType */
      u8StreamCounter,          /* u8StreamCounter */
      u16GetRegID(),       /* u16RegisterID */
      u16CmdCounter,            /* tU16 u16CmdCounter  */
      u16GetM_TARGET_CCA_SRV(), /* u16ServiceID */
      u16Fid,                   /* u16FunctionID */
      u8OpCode,                 /* u8OpCode */
      0,                        /* tU8 u8ACT = 0 */
      AMT_C_U16_DEFAULT_NULL,   /* tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL*/
      AMT_C_U16_DEFAULT_NULL,   /* u16TargetSub = AMT_C_U16_DEFAULT_NULL */
      AMT_C_U32_DEFAULT_NULL ); /* tU32 u32Timestamp = AMT_C_U32_DEFAULT_NULL*/

   vTraceCCAMessage(&oMessage);

   if (AIL_EN_N_NO_ERROR == m_poMainApp->enPostMessage(&oMessage, TRUE))
   {
      ETG_TRACE_USR4(("bTpegSendCCAMessage sending passed for function ID: 0x%x ", u16Fid));
      bRetVal = TRUE;
   }
   else
   {
      ETG_TRACE_USR4(("bTpegSendCCAMessage sending failed for function ID: 0x%x", u16Fid));
   }

   return bRetVal;
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clCCAhandler::vAddFunction(clFunction* poFunction)
{
   if (NULL == poFunction)
   {
      NORMAL_M_ASSERT_ALWAYS();
      return;
   }
   m_VectorFunction.push_back(poFunction);
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clCCAhandler::vHandleMessage(amt_tclServiceData* poInMsg)
{
   if (poInMsg != NULL)
   {
      clFunction* poFunction = poGetFunction(poInMsg->u16GetFunctionID());
      if (poFunction)
      {
         vTraceCCAMessage(poInMsg);
         poFunction->vHandleMessage(poInMsg);
      }
   }
}


/**************************************************************************//**
* 
******************************************************************************/
clFunction* clCCAhandler::poGetFunction(tU16 u16FunctionID)
{
   clFunction* poFunction = NULL;

   for (tU32 u32Index = 0; u32Index < m_VectorFunction.size(); u32Index++)
   {
      if ( u16FunctionID == m_VectorFunction.at(u32Index)->u16GetFunctionID() )
      {
         poFunction = m_VectorFunction.at(u32Index);
         break;
      }
   }

   return poFunction;
}


/*************************************************************************
*  FUNCTION:    clCCAhandlerGeneral::bRegisterForAllFID()
*
*  DESCRIPTION: register for all function with upreg. called by FI upon 
*               only once during start up upon service availability 
*
*  PARAMETER:   NONE
*
*  RETURNVALUE: TRUE == NO_ERROR, FALSE == ERROR
* Note this function is a direct takeover from LCN2Kai HMI, 
* Some logic related to bUsePort is not used
*************************************************************************/
tBool clCCAhandler::bRegisterForAllFID( )
{
   /* return value of the function */
   tBool bRetVal = TRUE;
   
   /* registration invalid */
   if ( u16GetRegID() == AMT_C_U16_REGID_INVALID )
   {
      /* if regID is invalid then return FALSE */
      bRetVal= FALSE;
      
      /* ERROR trace */
      ETG_TRACE_ERR(("Invalid register ID for app [0x%x] in function register for FID", m_u16SourceAppID));
   }
   
   /* if the registration ID is OK */
   else
   {
      /** Register for all the FIDs Individually by calling bRegisterForFID() with the Resp FID */
      tU16 u16FunctionID = 0;
      tBool bUsePort = FALSE;
      tBool bTemp = FALSE;
      
      /* if the function id in the list is not registered */
      if ( oFiRegHelper.bAreAllPropertiesRegistered() == FALSE )
      {
         /* register for all FID's until everythin complete */
         // loop through all fids and try to register only once
          for (tU32 u32Idx = 0; u32Idx < oFiRegHelper.getFidToRegisterCount(); u32Idx++)
         {
            /* obtain the function ID for the vector list */
#ifndef GTEST_x86LINUX_BUILD
             u16FunctionID = oFiRegHelper.u16GetFunctionIDToRegister(u32Idx, &bUsePort);
#endif
            if ( u16FunctionID != 0 )
            {
               /* register for individual function ID's */
               bTemp = bRegisterForFID(u16FunctionID);
               /* store the return value in the vector */
               oFiRegHelper.vSetRetValForRegister(u16FunctionID, bTemp);             
               if (!bTemp)
               {
                  ETG_TRACE_USR4(("Registration of FID 0x%x of service 0x%x failed", u16FunctionID, m_u16ServiceID));
               }
               else
               {
                  ETG_TRACE_USR4(("Registration of FID 0x%x of service 0x%x succeeded", u16FunctionID, m_u16ServiceID));
               }
                                             
            }     // end of if ( u16FunctionID != NULL )
         }
      }     // end of if all function ID's registered 
      
      /* return the function ID registration value */
      bRetVal = oFiRegHelper.bAreAllPropertiesRegistered();
   } 
   /* return value to the called function */
   return bRetVal ;
}

/*************************************************************************
*  FUNCTION:   bRegisterForFID(tU16 u16FID)
*
* DESCRIPTION: register for a function of a service
*
* PARAMETER:   u16FID: FID of the function 
*
* RETURNVALUE: TRUE == NO_ERROR, FALSE == ERROR
*
* History: InitialVersion
*
*************************************************************************/
tBool clCCAhandler::bRegisterForFID( tU16 u16FID )
{
   /* return value of the function */
   tBool bRetVal = TRUE;
   
   /* registration invalid */
   if ( u16GetRegID() == AMT_C_U16_REGID_INVALID )/*Additional check*/
   {
      /* if regID is invalid then return FALSE */
      bRetVal= FALSE;
      
      /* ERROR trace */
      ETG_TRACE_ERR(("Invalid register ID for app 0x%x, service 0x%x", m_u16SourceAppID , m_u16ServiceID ));
   }
   
   /* if the registration ID is OK */
   else
   {
      /* form an empty CCA msg for FID Registration */
      bRetVal = bSendCCAMessage( u16FID , AMT_C_U8_CCAMSG_OPCODE_UPREG );
   }
   
   if (bRetVal == FALSE)
   { 
      ETG_TRACE_ERR(("Registration failed for app 0x%x, service 0x%x, fid 0x%x", CCA_C_U16_APP_FC_TPEG , m_u16ServiceID, u16FID ));
   }

   /* return the status of registration as TRUE or FALSE */
   return ( bRetVal );
}

/*************************************************************************
* FUNCTION   : bSendCCAMessage
*
* DESCRIPTION: Function creates an empty generic data message with the
*              opcode parameter and posts it to CCA
*
* PARAMETER  : u16DestAppID : 16 bit destination application ID
*              u16Fid       : 16 bit Function ID value
*              u16OpCode    : 16 bit CCA message opcode value
*
* RETURNVALUE: BOOL  : TRUE  -> indicates cca msg posted successfuly
*                      FALSE -> indicates cca msg posted successfuly   
*
*************************************************************************/
tBool clCCAhandler::bSendCCAMessage(  tU16 u16Fid, tU8 u8OpCode )
{
   tBool bRetVal = FALSE;
   tU16  u16CmdCounter = 0;
   if (u8OpCode == AMT_C_U8_CCAMSG_OPCODE_UPREG)
   {
      u16CmdCounter = TPEG_UPREG_CMD_COUNTER;
   }

   gm_tclEmptyMessage oOutMessage
      (
      m_u16SourceAppID,
      u16GetM_TARGET_CCA_APP(),
      u16GetRegID(),
      u16CmdCounter,
      u16GetM_TARGET_CCA_SRV(),
      u16Fid,
      u8OpCode
      );

   if (oOutMessage.bIsClientMessage())
   {
      oOutMessage.vSetSourceSubID(0);
   }

   if (AIL_EN_N_NO_ERROR == m_poMainApp->enPostMessage( &oOutMessage, TRUE ))
   {
      ETG_TRACE_USR4(("bSendCCAMessage sending passed for function ID: 0x%x", u16Fid));
      bRetVal = TRUE;
   }
   else
   {
      ETG_TRACE_ERR(("bSendCCAMessage sending failed for function ID: 0x%x", u16Fid));
   }

   return bRetVal;
}


/**************************************************************************//**
*
******************************************************************************/
tU16 clCCAhandler::u16GetM_TARGET_CCA_APP()
{
   return m_u16TargetAppID;
}


/**************************************************************************//**
*
******************************************************************************/
tU16 clCCAhandler::u16GetM_TARGET_CCA_SRV()
{
   return m_u16ServiceID;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clCCAhandler::vTraceCCAMessage(amt_tclServiceData* poInMsg)
{
   if (poInMsg != NULL)
   {
      amt_tclServiceData oMessage( poInMsg );
   }
   else
   {
      ETG_TRACE_ERR(("poInMsg pointer is not valid"));
   }
}


///**************************************************************************//**
//* 
//******************************************************************************/
//const mm_tMsgMap* clCCAhandler::GetMsgMap() const
//{
//   return &m_msgMap;
//}


/**************************************************************************//**
* 
******************************************************************************/
tU16 clCCAhandler::u16GetRegID() 
{
   return m_u16RegisterId;
}

/**************************************************************************//**
* 
******************************************************************************/
tVoid clCCAhandler::vSetRegisterId(tU16 u16RegisterId) 
{
   m_u16RegisterId = u16RegisterId;
}

/**************************************************************************//**
* 
******************************************************************************/
tVoid clCCAhandler::vGetDataFromAmt( amt_tclServiceData* poFIMsg , 
                                            fi_tclTypeBase &oFIData )
{
   /* Create Visitor message object for incoming message*/
   fi_tclVisitorMessage oInVisitorMsg( poFIMsg );
   
   /* Get the data in FI class from Vistor class*/   
   /*Check code here*//* check the 2nd parameter */
   if (OSAL_ERROR == oInVisitorMsg.s32GetData( oFIData , m_u16MajorVersion ) )
   {
      /* ERROR trace */
     ETG_TRACE_ERR(("Error from AMT app 0x%x, service 0x%x", m_u16SourceAppID , m_u16ServiceID));
   }
}


//EOF
