///////////////////////////////////////////////////////////
//  clClientMethod.h
//  Implementation of the Class clClientMethod
//  Created on:      14-Jan-2015 13:42:39
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_971FB48E_5CB1_4b26_B4CB_15C2306E95D9__INCLUDED_)
#define EA_971FB48E_5CB1_4b26_B4CB_15C2306E95D9__INCLUDED_

#include "clFunction.h"
#include "datatypes/tVector.h"
#include "ADRMsg/ADRMsg_if.h"

namespace tuner
{
	namespace AarsApp
	{
		/**
		 * @author pad1cob
		 * @version 1.0
		 * @created 14-Jan-2015 13:42:39
		 */
      class clAarsHandler;
		class clClientMethod : public tuner::AarsApp::clFunction
		{

		public:
			clClientMethod();
			virtual ~clClientMethod();

			/**
			 * handler for incoming ADR messages
			 * 
			 * @param bitStream
			 */
			virtual void vHandleMessage(tunerVector<unsigned char> & bitStream);
			/**
			 * 
			 * @param poAarsHandler
			 * @param functionID    u16FunctionID
			 * @param ClientID
			 * @param FBlockID
			 * @param InstanceID
			 */
			clClientMethod(tuner::AarsApp::clAarsHandler* poAarsHandler, unsigned short functionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID);

		protected:
			/**
			 * 
			 * @param bitStream
			 */
			virtual void vError(tunerVector<unsigned char> bitStream);
			/**
			 * 
			 * @param bitStream
			 */
			virtual void vMethodResult(tunerVector<unsigned char> bitStream);
			/**
			 * 
			 * @param oPayload
			 */
			void vMethodStart(clADRMsgPayload & oPayload);
			/**
			 *
			 * @param oPayload
			 */
			void vMethodStartResult(clADRMsgPayload & oPayload);

		};

	}

}
#endif // !defined(EA_971FB48E_5CB1_4b26_B4CB_15C2306E95D9__INCLUDED_)
