///////////////////////////////////////////////////////////
//  clClientMethod.cpp
//  Implementation of the Class clClientMethod
//  Created on:      14-Jan-2015 13:42:40
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clClientMethod.h"
#include "clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"

using tuner::AarsApp::clClientMethod;


clClientMethod::clClientMethod(){

}



clClientMethod::~clClientMethod(){

}



void clClientMethod::vError(tunerVector<unsigned char> /*bitStream*/){

}


void clClientMethod::vHandleMessage(tunerVector<unsigned char> & bitStream){
   clADRInMsg oMsg(bitStream);
   switch (oMsg.getHeader().getu8OpCode())
   {
      case ADR_MSG_U8_RESULT:
         vMethodResult(bitStream);
         break;

      case ADR_MSG_U8_ERROR:
         vError(bitStream);
         break;

      default:
         break;
   }
}


void clClientMethod::vMethodResult(tunerVector<unsigned char> /*bitStream*/){

}


void clClientMethod::vMethodStart(clADRMsgPayload & oPayload){

	clADRMsgHeader oHeader;
	oHeader.setu16ClientId(getu16ClientID());
	oHeader.setu16FBlockId(getu16FBlockID());
	oHeader.setu16FunctionId(getu16FunctionID());
	oHeader.setu8InstanceId(getu8InstanceID());
	oHeader.setu8OpCode(ADR_MSG_U8_START);
	clADROutMsg oMsg(oHeader, &oPayload);
	tunerVector<unsigned char> msgData = oMsg.oSerialize();
	m_poAarsHandler->vWaitOnMessageQue(&(msgData[0]), msgData.size());
}

void clClientMethod::vMethodStartResult(clADRMsgPayload & oPayload){

	clADRMsgHeader oHeader;
	oHeader.setu16ClientId(getu16ClientID());
	oHeader.setu16FBlockId(getu16FBlockID());
	oHeader.setu16FunctionId(getu16FunctionID());
	oHeader.setu8InstanceId(getu8InstanceID());
	oHeader.setu8OpCode(ADR_MSG_U8_STARTRESULT);
	clADROutMsg oMsg(oHeader, &oPayload);
	tunerVector<unsigned char> msgData = oMsg.oSerialize();
	m_poAarsHandler->vWaitOnMessageQue(&(msgData[0]), msgData.size());
}



clClientMethod::clClientMethod(tuner::AarsApp::clAarsHandler* poAarsHandler,unsigned short functionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID)
 : clFunction(poAarsHandler, functionID ,ClientID, FBlockID, InstanceID){

}
