///////////////////////////////////////////////////////////
//  clAarsHandler.cpp
//  Implementation of the Class clAarsHandler
//  Created on:      14-Jan-2015 10:19:34
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clAarsHandler.h"
#include "clFunction.h"
#include "ADRMsg/ADRMsg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
#include "tun_MsgToADR.h"
#endif

using tuner::AarsApp::clAarsHandler;
using namespace tuner::AarsApp;

#include "tuner_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAarsHandler.cpp.trc.h"
#endif



clAarsHandler::clAarsHandler(){

}



clAarsHandler::~clAarsHandler(){

}



void clAarsHandler::vAddFunction(clFunction* poFunction)
{
   if (0 == poFunction)
   {
      return;
   }
   m_VectorFunction.push_back(poFunction);
}


void clAarsHandler::vHandleMessage(tunerVector<unsigned char> & InMsg)
{
   if (!InMsg.empty())
   {
      clADRInMsg oMsg(InMsg, true);
	  ETG_TRACE_COMP(("clAarsHandler::vHandleMessage %04X", oMsg.getHeader().getu16FunctionId()));
      clFunction* poFunction = poGetFunction(oMsg.getHeader().getu16FunctionId());
      if(poFunction == 0)
      {
    	  poFunction =  poGetFunctionBasedOnRange(oMsg.getHeader().getu16FunctionId());
      }
      if (poFunction)
      {
         poFunction->vHandleMessage(InMsg);
      }
   }
}


clFunction* clAarsHandler::poGetFunction(unsigned short u16FunctionID)
{
   clFunction* poFunction = 0;
   for (unsigned int u32Index = 0; u32Index < m_VectorFunction.size(); u32Index++)
   {
      if ( u16FunctionID == m_VectorFunction.at(u32Index)->getu16FunctionID() )
      {
         poFunction = m_VectorFunction.at(u32Index);
         break;
      }
   }
   return poFunction;
}
clFunction* clAarsHandler::poGetFunctionBasedOnRange(unsigned short u16FunctionID)
{
   clFunction* poFunction = 0;
   for (unsigned int u32Index = 0; u32Index < m_VectorFunction.size(); u32Index++)
   {
		unsigned short u16StartFunctionID=m_VectorFunction.at(u32Index)->getStartFunctionID();
		unsigned short u16EndFunctionID=m_VectorFunction.at(u32Index)->getEndFunctionID();
		if((u16StartFunctionID==0 ) || (u16EndFunctionID==0))
		{
			//Do nothing
		}
	   else if (u16FunctionID >= u16StartFunctionID && u16FunctionID <= u16EndFunctionID )
		{
			poFunction = m_VectorFunction.at(u32Index);
			break;
		}
   }
	return poFunction;
}

/*In Gen4, virtual function is not getting called. To be checked: Temporariy added explicit function call */

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY

void clAarsHandler::vWaitOnMessageQue(unsigned char * pu8Message, unsigned long u32MessageLen, unsigned char /*bSendAlways*/)
{
	tun_MsgToADR::instance()->vWaitOnMessageQue(pu8Message, u32MessageLen, true);
}

#else

void clAarsHandler::vWaitOnMessageQue(unsigned char * /*pu8Message*/, unsigned long /*u32MessageLen*/, unsigned char /*bSendAlways*/)
{

}

#endif

void clAarsHandler::vOnServiceAvailable()
{
   clFunction* poFunction = 0;
   for (unsigned int u32Index = 0; u32Index < m_VectorFunction.size(); u32Index++)
   {
        poFunction = m_VectorFunction.at(u32Index);
        poFunction->vOnServiceAvailable();
   }
}
