///////////////////////////////////////////////////////////
//  clCMErrorTypes.h
//  Implementation of the Class clCMErrorCode and clCMErrorInfo
//  Created on:      12-Feb-2015 21:03:15
//  Implementation of error types
///////////////////////////////////////////////////////////

#ifndef _clCMErrorTypes_h
#define _clCMErrorTypes_h

class clCMErrorCodes
{
public:
	enum ErrorCode
	{
		No_Error                                                   = 0x00, // No Error
		FblockID_not_available                                     = 0x01, //FblockID_not_available
		InstanceID_not_available                                   = 0x02, //InstanceID_not_available
		FktID_not_available                                        = 0x03, //FktID_not_available
		OPType_not_available                                       = 0x04, //OPType_not_available
		Invalid_length                                             = 0x05, //Invalid_length
		Parameter_wrong                                            = 0x06, //Parameter_wrong
		Parameter_not_available                                    = 0x07, //Parameter_not_available
		Device_malfunction                                         = 0x0B, //Device_malfunction
		Function_is_supported_but_currently_occupied               = 0x40, //Function_is_supported_but_currently_occupied
		Function_is_supported_but_currently_not_available          = 0x41, //Function_is_supported_but_currently_not_available
		Method_aborted                                             = 0x43, //Method_aborted
		No_more_registrations_possible                             = 0xf0, //No_more_registrations_possible
		Function_supported_but_currently_not_available_because_of_running_UDS_session	= 0xf5 	//Function_supported_but_currently_not_available_because_of_running_UDS_session
	};
	ErrorCode enType;
	clCMErrorCodes () { enType = No_Error; }
	short getSize() const { return 1; }
};

class clCMErrorInfo
{
public:
	enum ErrorInfo
	{
		No_Info                                      = 0x00,
		Invalid_OPType                               = 0x04, //Invalid OPType
		Index_of_first_byte_that_contains_wrong_data = 0x06 //Index of first byte that contains wrong data
	};
	ErrorInfo enType;
	clCMErrorInfo () { enType = No_Info; }
	short getSize() const { return 1; }
};

#endif