///////////////////////////////////////////////////////////
//  clCMEnumTypes.h
//  Implementation of the Class clCMEnum_*
//  Created on:      12-Feb-2015 20:45:03
//  Implementation of enum types
///////////////////////////////////////////////////////////

#ifndef _clCMEnumTypes_h
#define _clCMEnumTypes_h

class clCMEnum_Band
{
public:
	enum enBand
	{
		FM = 0,
		LW,
		MW,
		KW_SUB_1,
		KW_SUB_2,
		KW_SUB_3,
		KW_SUB_4,
		KW_SUB_5,
		KW_SUB_6,
		KW_SUB_7,
		KW_SUB_8,
		KW_SUB_9,
		KW_SUB_10,
		KW_SUB_11,
		KW_SUB_12,
		KW_SUB_13,
		KW_SUB_14,
		TRF,
		WB,
		TBD,
		CB1,
		GetCurrentBand = 0xff
	};
	enBand enType;
	clCMEnum_Band() { enType = FM; }
	/* sizeof object is 4 (system dependent)
	 * use getSize() function */
	short getSize() const { return 1; }
};

class clCMEnum_HDAudioService
{
public:
	enum enHDAudioService
	{
		AudioService1 = 0,
		AudioService2,
		AudioService3,
		AudioService4,
		AudioService5,
		AudioService6,
		AudioService7,
		AudioService8
	};
	enHDAudioService enType;
	clCMEnum_HDAudioService() { enType = AudioService1; }
	short getSize() const { return 1; }
};

class clCMEnum_ATHDAudioProgram
{
public:
	enum enATHDAudioProgram
	{
		MPS = 0,
		Audioprogram2,	//SPS
		Audioprogram3,
		Audioprogram4,
		Audioprogram5,
		Audioprogram6,
		Audioprogram7,
		Audioprogram8
	};
	enATHDAudioProgram enType;
	clCMEnum_ATHDAudioProgram() { enType = MPS; }
	short getSize() const { return 1; }
};

class clCMEnum_DRMServiceShortId
{
public:
	enum enDRMServiceShortId
	{
		DRMAudioProgram1 = 0,
		DRMAudioProgram2,
		DRMAudioProgram3,
		DRMAudioProgram4
	};
	enDRMServiceShortId enType;
	clCMEnum_DRMServiceShortId () { enType = DRMAudioProgram1; }
	short getSize() const { return 1; }
};

class clCMEnum_AMFMTunerMsg
{
public:
	enum enAmFmTunerMsg
	{
		Msg_CM_Startup                     = 0xFFF4,
		Msg_CM_Ping                        = 0x0F0D,
		Msg_CM_PrepareShutdown             = 0x0F11,
		Msg_CM_Shutdown                    = 0x0F12,
		Msg_CM_VersionInfo                 = 0x0F13,
		Msg_CM_AdditionalVersionInfo       = 0x0fd2,
		Msg_FktIds                         = 0x0000,
		Msg_Notification                   = 0x0001,
		Msg_NotificationCheck              = 0x0002,
		Msg_CM_AudioSource                 = 0x0F01,
		Msg_CM_ATBand                      = 0x0F00,
		Msg_ATFrequency                    = 0x0206,
		Msg_ATSeek                         = 0x0204,
		Msg_CM_ATSeek                      = 0x0F92,
		Msg_ATPI                           = 0x0205,
		Msg_CM_Autostore                   = 0x0F90,
		Msg_CM_TuningActionConfiguration   = 0x0F0B,
		Msg_CM_ActiveConfiguration         = 0x0F60,
		Msg_CM_AreaFeatures                = 0x0F61,
		Msg_CM_AvailableBands              = 0x0F62,
		Msg_CM_CombibandConfiguration      = 0x0F63,
		Msg_CM_BandConfiguration           = 0x0F64,
		Msg_CM_DefaultSetting              = 0x0F65,
		Msg_CM_AcceptAf                    = 0x0F80,
		Msg_ATStationInfo                  = 0x0201,
		Msg_CM_ATStationInfo               = 0x0F70,
		Msg_CM_ATStationInfoConfig         = 0x0F71,
		Msg_CM_ATTunerState                = 0x0F72,
		Msg_TPSwitch                       = 0x0450,
		Msg_AFBestSwitch                   = 0x0F02,
		Msg_RDSSwitch                      = 0x0451,
		Msg_CM_MonoStereo                  = 0x0F81,
		Msg_REG                            = 0x0452,
		Msg_CM_DDASwitch                   = 0x0F0C,
		Msg_TAEscape                       = 0x0453,
		Msg_CM_PersistentStorage           = 0x0F10,
		Msg_TAMessage                      = 0x0456,
		Msg_CM_DateAndTime                 = 0x0F03,
		Msg_CurrentRadiotext               = 0x0C20,
		Msg_CM_CurrentRadiotext            = 0x0F16,
		Msg_RadiotextMetaData              = 0x0C30,
		Msg_CM_RadiotextMetaData           = 0x0C31,
		Msg_CM_ReceptionParameter          = 0x0F0A,
		Msg_CM_UpdateLandscape             = 0x0F14,
		Msg_CM_AtPiSearch				   = 0x0FA0,
		Msg_CM_SurveilTp                   = 0x0FAA,
		Msg_CM_SurveillanceConfiguration   = 0x0FA2,
		Msg_TaInfo                         = 0x0455,
		Msg_CM_TaInfo                      = 0x0F15,
		Msg_CM_ATPresetList_00             = 0x0F20,
		Msg_CM_ATPresetList_01             = 0x0F21,
		Msg_CM_ATPresetList_02             = 0x0F22,
		Msg_CM_ATPresetList_03             = 0x0F23,
		Msg_CM_ATPresetList_04             = 0x0F24,
		Msg_CM_ATPresetList_05             = 0x0F25,
		Msg_CM_ATPresetList_06             = 0x0F26,
		Msg_CM_ATPresetList_07             = 0x0F27,
		Msg_CM_ATPresetList_08             = 0x0F28,
		Msg_CM_ATPresetList_09             = 0x0F29,
		Msg_CM_ATPresetList_10             = 0x0F2A,
		Msg_CM_ATPresetList_11             = 0x0F2B,
		Msg_CM_ATPresetList_12             = 0x0F2C,
		Msg_CM_ATPresetList_13             = 0x0F2D,
		Msg_CM_ATPresetList_14             = 0x0F2E,
		Msg_CM_ATPresetList_15             = 0x0F2F,
		Msg_CM_ATPresetList_16             = 0x0F30,
		Msg_CM_ATPresetList_17             = 0x0F31,
		Msg_CM_ATPresetList_18             = 0x0F32,
		Msg_CM_ATPresetList_19             = 0x0F33,
		Msg_CM_ATPresetList_20             = 0x0F34,
		Msg_CM_ATPresetList_21             = 0x0F35,
		Msg_CM_ATPresetList_22             = 0x0F36,
		Msg_CM_ATPresetList_23             = 0x0F37,
		Msg_CM_ATPresetList_24             = 0x0F38,
		Msg_CM_ATPresetList_25             = 0x0F39,
		Msg_CM_ATPresetList_26             = 0x0F3A,
		Msg_CM_ATPresetList_27             = 0x0F3B,
		Msg_CM_ATPresetList_28             = 0x0F3C,
		Msg_CM_ATPresetList_29             = 0x0F3D,
		Msg_CM_ATPresetList_30             = 0x0F3E,
		Msg_CM_ATPresetList_31             = 0x0F3F,
		Msg_CM_ATPresetSave                = 0x0F40,
		Msg_CM_SystemPresets               = 0x0F42,
		Msg_CM_ATPresetListSetActive       = 0x0F43,
		Msg_CM_ATPresetListConfig          = 0x0F41,
		Msg_CM_ATPresetListResetAll        = 0x0F44,
		Msg_CM_StationListConfig           = 0x0F08,
		Msg_CM_StationListRelease          = 0x0F0E,
		Msg_CM_StationsList                = 0x0F17,
		Msg_CM_Container                   = 0xFFF1,
		Msg_CM_SpecialDiagnosisMode        = 0xFFF5,
		Msg_CM_SnapshotMode                = 0xFFFB,
		Msg_CM_EnhancedTestMode            = 0x0FCA,
		Msg_CM_TestMode					   = 0xFFF6,
		Msg_CM_ATAfList                    = 0xFFF7,
		Msg_CM_ATEnhancedAfList            = 0x0FCB,
		Msg_CM_TestTunerSwitches           = 0xFFF8,
		Msg_CM_SetConfiguration            = 0xFFF9,
		Msg_CM_GetConfigurationInfo        = 0xFFFA,
		Msg_CM_CalibrationData             = 0xFFFC,
		Msg_CM_TMCSelectionFilter          = 0x0F00,
		Msg_CM_TMCMonitoredStationsUpdate  = 0x0F01,
		Msg_CM_TMCTrafficInfos             = 0x0F02,
		Msg_CM_TMCDataGroup				   = 0x0F03,
		Msg_CM_TMCStations                 = 0x0F04,
		Msg_CM_ATLsmSetup				   = 0x0FC0,
		Msg_CM_Commit                      = 0x0FC2,
		Msg_CM_StationNameFix              = 0x0F04,
		Msg_CM_SetEngineeringParameter     = 0x0FCC,
		Msg_CM_ATTestTuneFrequency		   = 0x0FCD,
		/** Announcement related FIDs */
		Msg_CM_AnnouncementSwitch		   = 0x0FBA,
		Msg_CM_AnnouncementMessage		   = 0x0FBB,
		Msg_CM_AnnouncementInfo			   = 0x0FBC,
		Msg_CM_AnnouncementEscape		   = 0x0FBD,
		/** -------------------------- */
		Msg_CM_AtVolumeInfo				   = 0x0FCE,
		Msg_CM_PiPsRelation				   = 0x0FD0,
		Msg_CM_ATPreparePresetStorage	   = 0x0F45,
		Msg_CM_SpeedInformation			   = 0x0FDA,
		Msg_CM_EvaluationParameter		   = 0x0FCF,
		Msg_CM_UpdateLandscapeProgress     = 0x0FD1,
		Msg_CM_CancelAutostore		       = 0x0F91,
		/* debug messages in 1st version of ADR3 from CF42 */
		Msg_Unknown_Message_0x0002         = 0x0002,
		Msg_Unknown_Message_0xFFF2         = 0xFFF2,
		Msg_Unknown_Message_0xFFF3         = 0xFFF3,
		Msg_Unknown_Message_0x0000         = 0x0000
	};
	enAmFmTunerMsg enType;
};

class clCMEnum_Control
{
public:
	enum enControl
	{
		SetAll=0,
		SetFunction,
		ClearAll,
		ClearFunction
	};
	enControl enType;
	clCMEnum_Control () { enType = SetAll; }
	short getSize() const { return 1; }
};

class clCMEnum_ATSeekMode
{
public:
	enum enATSeekMode
	{
		ATSeekMode_Off                                    =  0,
		ATSeekMode_Up_auto                                =  1,
		ATSeekMode_Up_scan_current_preset_list            =  2,
		ATSeekMode_Up_scan_frequency                      =  3,
		ATSeekMode_Up_continuous_manual_step_unmuted      =  4,
		ATSeekMode_Up_preset                              =  5,
		ATSeekMode_Up_current_station_list                =  6,
		ATSeekMode_Down_auto                              =  7,
		ATSeekMode_Down_scan_current_preset_list          =  8,
		ATSeekMode_Down_scan_frequency                    =  9,
		ATSeekMode_Down_continuous_manual_step_unmuted    = 10,
		ATSeekMode_Down_preset                            = 11,
		ATSeekMode_Down_current_station_list              = 12,
		ATSeekMode_Up_auto_RDS_only                       = 13,
		ATSeekMode_Down_auto_RDS_only                     = 14,
		ATSeekMode_Up_auto_RDS_only_PTY_mask              = 15,
		ATSeekMode_Down_auto_RDS_only_PTY_mask            = 16,
		ATSeekMode_TP_up                                  = 17,
		ATSeekMode_TP_down                                = 18,
		ATSeekMode_SELF_TP_up                             = 19,
		ATSeekMode_SELF_TP_down                           = 20,
		ATSeekMode_TP_up_with_PTY_mask                    = 21,
		ATSeekMode_TP_down_with_PTY_mask                  = 22,
		ATSeekMode_SELF_TP_up_with_PTY_mask               = 23,
		ATSeekMode_SELF_TP_down_with_PTY_mask             = 24,
		ATSeekMode_Up_continuous_manual_step_muted        = 25,
		ATSeekMode_Down_continuous_manual_step_muted      = 26,
		ATSeekMode_Up_scan_PI                             = 27,
		ATSeekMode_Down_scan_PI                           = 28,
		ATSeekMode_Up_scan_Sorted_PS                      = 29,
		ATSeekMode_Down_scan_Sorted_PS                    = 30,
		ATSeekMode_Up_Scan_in_Active_Station_List         = 31,
		ATSeekMode_Down_Scan_in_Active_Station_List       = 32
	};
	enATSeekMode enType;
	clCMEnum_ATSeekMode () { enType = ATSeekMode_Off; }
	short getSize() const { return 1; }
};

class clCMEnum_PDSFrameSubFieldDataType
{
public:
	enum enSubFieldDataType
	{
		_8_BIT_CHAR_ISO_IEC_8859_1_1998 = 0,
		_16_BIT_CHAR_ISO_IEC_10646_1_2000 = 1,
		BINARY_OR_NOEXPLICIT_TYPE = 0XFF
	};
	enSubFieldDataType enType;
	clCMEnum_PDSFrameSubFieldDataType () { enType = _8_BIT_CHAR_ISO_IEC_8859_1_1998; }
	short getSize() const { return 1; }
};

class clCMEnum_TestmodeActivity
{
public:
	enum enTestmodeActivity
	{
		Testmode_auto_notifications_are_switched_off = 0x00,
		Testmode_auto_notifications_are_switched_on  = 0x01,
		Testmode_auto_notifications_are_switched_on_for_audiotuner  = 0x02
	};
	enTestmodeActivity enType;
	clCMEnum_TestmodeActivity () { enType = Testmode_auto_notifications_are_switched_off; }
	short getSize() const { return 1; }
};

class clCMEnum_ActivateStatusResponse
{
public:
	enum enActivateStatusResponse
	{
		DEACTIVATE_STATUS=0,
		ACTIVATE_STATUS
	};
	enActivateStatusResponse enType;
	clCMEnum_ActivateStatusResponse () { enType = DEACTIVATE_STATUS; }
	short getSize() const { return 1; }
};

class clCMEnum_PiSearchStatus
{
public:
	enum enPiSearchStatus
	{
		Pi_search_started = 0,
		Pi_search_ended_and_PI_found,
		Pi_search_ended_and_PI_not_found
	};
	enPiSearchStatus enType;
	clCMEnum_PiSearchStatus () { enType = Pi_search_started; }
	short getSize() const { return 1; }
};

class clCMEnum_TPSeekStrategy
{
public:
	enum enTPSeekStrategy
	{
		Strategy_1 = 0,
		Strategy_2,
		Strategy_n
	};
	enTPSeekStrategy enType;
	clCMEnum_TPSeekStrategy () { enType = Strategy_1; }
	short getSize() const { return 1; }
};

class clCMEnum_AnalogFilter
{
public:
	enum enAnalogFilter
	{
		ALL = 0,
		RDS_only,
		RDS_and_NON_RDS,
		TP_station_both_Self_TP_and_EON_TP_only,
		TP_Self_station_only,
		TMC_station_only,
		rfu,
		None
	};
	enAnalogFilter enType;
	clCMEnum_AnalogFilter () { enType = ALL; }
	short getSize() const { return 1; }
};

class clCMEnum_Sorting
{
public:
	enum enSorting
	{
		PS_ASCENDING = 0,
		PI_ASCENDING,
		FIELDSTRENGTH_ASCENDING,
		FREQUENCY_ASCENDING,
		PS_DESCENDING,
		PI_DESCENDING,
		FIELDSTRENGTH_DESCENDING,
		FREQUENCY_DESCENDING
	};
	enSorting enType;
	clCMEnum_Sorting () { enType = PS_ASCENDING; }
	short getSize() const { return 1; }
};

class clCMEnum_ModulationType
{
public:
	enum enModulationType
	{
		Analogue_AM_FM = 0,
		HD,
		DRM
	};
	enModulationType enType;
	clCMEnum_ModulationType () { enType = Analogue_AM_FM; }
	short getSize() const { return 1; }
};

class clCMEnum_RdsStationnameInfo
{
public:
	enum enRdsStationnameInfo
	{
		NON_RDS_Station = 0,
		Station_name_is_first_received_PS,
		Station_name_is_last_received_PS,
		Name_assigned_by_customer
	};
	enRdsStationnameInfo enType;
	clCMEnum_RdsStationnameInfo () { enType = NON_RDS_Station; }
	short getSize() const { return 1; }
};

class clCMEnum_ATStationTmcInfo
{
public:
	enum enATStationTmcInfo
	{
		TMC_status_of_station_is_unknown = 0,
		Station_is_NO_TMC_station,
		Station_is_TMC_station
	};
	enATStationTmcInfo enType;
	clCMEnum_ATStationTmcInfo () { enType = TMC_status_of_station_is_unknown; }
	short getSize() const { return 1; }
};

class clCMEnum_ATStationTpInfo
{
public:
	enum enATStationTpInfo
	{
		TP_status_of_station_is_unknown = 0,
		Station_is_NO_TP_station,
		Station_is_SELF_TP_station,
		Station_is_EON_TP_station,
		Station_is_TP_station_but_TP_synchronisation_is_lost
	};
	enATStationTpInfo enType;
	clCMEnum_ATStationTpInfo () { enType = TP_status_of_station_is_unknown; }
	short getSize() const { return 1; }
};

class clCMEnum_HDActiveAudioProgram
{
public:
	enum enHDActiveAudioProgram
	{
		MPS = 0,
		AudioProgram2,
		AudioProgram3,
		AudioProgram4,
		AudioProgram5,
		AudioProgram6,
		AudioProgram7,
		AudioProgram8
	};
	enHDActiveAudioProgram enType;
	clCMEnum_HDActiveAudioProgram() { enType = MPS; }
	short getSize() const { return 1; }
};

class clCMEnum_SystemPresetType
{
public:
	enum enSystemPresetType
	{
		Las_tuning_preset = 0,
		Last_user_preset
	};
	enSystemPresetType enType;
	clCMEnum_SystemPresetType() { enType = Las_tuning_preset; }
	short getSize() const { return 1; }
};

class clCMEnum_StationNameInfo
{
public:
	enum enStationNameInfo
	{
		NON_RDS_Station = 0,
		Station_name_is_first_received_PS,
		Station_name_is_last_received_PS,
		Name_assigned_by_customer
	};
	enStationNameInfo enType;
	clCMEnum_StationNameInfo() { enType = NON_RDS_Station; }
	short getSize() const { return 1; }
};

class clCMEnum_Mode
{
public:
	enum enMode
	{
		Freeze = 0,
		Unfreeze
	};
	enMode enType;
	clCMEnum_Mode() { enType = Freeze; }
	short getSize() const { return 1; }
};

class clCMEnum_DefaultSettingOption
{
public:
	enum enDefaultSettingOption
	{
		RESET_ALL_FOR_ALL_USERS = 0,
		RESET_ALL_FOR_CURRENT_USERS
	};
	enDefaultSettingOption enType;
	clCMEnum_DefaultSettingOption() { enType = RESET_ALL_FOR_ALL_USERS; }
	short getSize() const { return 1; }
};

class clCMEnum_EncryptionFlag
{
public:
	enum enEncryptionFlag
	{
		Not_encrypted = 0,
		Encrypted
	};
	enEncryptionFlag enType;
	clCMEnum_EncryptionFlag() { enType = Not_encrypted; }
	short getSize() const { return 1; }
};

class clCMEnum_ListState
{
public:
	enum enListState
	{
		List_released = 0,
		List_in_use
	};
	enListState enType;
	clCMEnum_ListState() { enType = List_released; }
	short getSize() const { return 1; }
};

class clCMEnum_Selected
{
public:
	enum enSelected
	{
		Not_active = 0,
		active
	};
	enSelected enType;
	clCMEnum_Selected() { enType = Not_active; }
	short getSize() const { return 1; }
};

class clCMEnum_SendernameInfo
{
public:
	enum enSendernameInfo
	{
		NON_RDS_Station = 0,
		Station_name_is_first_received_PS,
		Station_name_is_last_received_PS,
		not_supported3,
		Name_assigned_by_customer,
		not_supported5
	};
	enSendernameInfo enType;
	clCMEnum_SendernameInfo() { enType = NON_RDS_Station; }
	short getSize() const { return 1; }
};

class clCMEnum_TMC
{
public:
	enum enTMC
	{
		TMC_undecoded = 0,
		TMC_lost,
		TMC_no,
		TMC_free,
		TMC_pay
	};
	enTMC enType;
	clCMEnum_TMC() { enType = TMC_undecoded; }
	short getSize() const { return 1; }
};

class clCMEnum_TuningState
{
public:
	enum enTuningState
	{
		Idle = 0,
		Tuning_action_started,
		Audio_tuner_is_not_heard_source
	};
	enTuningState enType;
	clCMEnum_TuningState() { enType = Idle; }
	short getSize() const { return 1; }
};

class clCMEnum_AfBestSwitch
{
public:
	enum enAfBestSwitch
	{
		AFBest_Off = 0,
		AFBest_On,
		AFBest_Off_temporary
	};
	enAfBestSwitch enType;
	clCMEnum_AfBestSwitch() { enType = AFBest_Off; }
	short getSize() const { return 1; }
};

class clCMEnum_StartStop
{
public:
	enum enStartStop
	{
		Start = 0,
		Stop
	};
	enStartStop enType;
	clCMEnum_StartStop() { enType = Stop; }
	short getSize() const { return 1; }
};

class clCMEnum_Strategy
{
public:
	enum enStrategy
	{
		Strategy1 = 0,
		Strategy2,
		Strategyn
	};
	enStrategy enType;
	clCMEnum_Strategy() { enType = Strategy1; }
	short getSize() const { return 1; }
};

class clCMEnum_AnnouncementType
{
public:
	enum enAnnouncementType
	{
		TP = 0,
		PTY31
	};
	enAnnouncementType enType;
	clCMEnum_AnnouncementType() { enType = TP; }
	short getSize() const { return 1; }
};

class clCMEnum_Result
{
public:
	enum enResult
	{
		OK = 0,
		NOT_OK
	};
	enResult enType;
	clCMEnum_Result() { enType = OK; }
	short getSize() const { return 1; }
};

class clCMEnum_AudioStreamType
{
public:
	enum enAudioStreamType
	{
		DRM_AAC = 0,
		rfu1,
		rfu2,
		DRM_xHE_AAC
	};
	enAudioStreamType enType;
	clCMEnum_AudioStreamType() { enType = DRM_AAC; }
	short getSize() const { return 1; }
};

class clCMEnum_Action
{
public:
	enum enAction
	{
		INTERMEDIATE_FRAME = 0,
		START_OF_STREAM,
		END_OF_STREAM
	};
	enAction enType;
	clCMEnum_Action() { enType = INTERMEDIATE_FRAME; }
	short getSize() const { return 1; }
};

class clCMEnum_NonReliabilityIndication
{
public:
	enum enNonReliabilityIndication
	{
		Reliabile = 0,
		NonReliabile
	};
	enNonReliabilityIndication enType;
	clCMEnum_NonReliabilityIndication() { enType = Reliabile; }
	short getSize() const { return 1; }
};

class clCMEnum_OutputEnabled
{
public:
	enum enOutputEnabled
	{
		Output_Disabled = 0,
		Output_Enabled
	};
	enOutputEnabled enType;
	clCMEnum_OutputEnabled() { enType = Output_Disabled; }
	short getSize() const { return 1; }
};

class clCMEnum_MuteStatus
{
public:
	enum enMuteStatus
	{
		Audio_not_muted = 0,
		Audio_muted,
		Audio_fading_in, //towards non-muted state
		Audio_fading_out //towards muted state
	};
	enMuteStatus enType;
	clCMEnum_MuteStatus() { enType = Audio_not_muted; }
	short getSize() const { return 1; }
};

class clCMEnum_SpecialDiagnosisMode
{
public:
	enum enMode
	{
		Normal_Mode = 0,
		Measure_Mode,
		Single_Tuner_Mode
	};
	enMode enType;
	clCMEnum_SpecialDiagnosisMode() { enType = Normal_Mode; }
	short getSize() const { return 1; }
};

class clCMEnum_Modulation
{
public:
	enum enModulation
	{
		UNKNOWN = 0,
		FM,
		FM_NON_RDS,
		AM,
		DRM,
		HD,
		DAB
	};
	enModulation enType;
	clCMEnum_Modulation() { enType = UNKNOWN; }
	short getSize() const { return 1; }
};

class clCMEnum_ScrollPSStatus
{
public:
	enum enScrollPSStatus
	{
		Fix_PS_detected = 0,
		Scrolling_PS_detected
	};
	enScrollPSStatus enType;
	clCMEnum_ScrollPSStatus() { enType = Fix_PS_detected; }
	short getSize() const { return 1; }
};

class clCMEnum_AfStatus
{
public:
	enum enAfStatus
	{
		AF_best_off = 0,
		AF_best_on
	};
	enAfStatus enType;
	clCMEnum_AfStatus() { enType = AF_best_off; }
	short getSize() const { return 1; }
};

class clCMEnum_DiversityState
{
public:
	enum enDiversityState
	{
		No_diversity_feature = 0,
		DMQ,
		DDS,
		DDA
	};
	enDiversityState enType;
	clCMEnum_DiversityState() { enType = No_diversity_feature; }
	short getSize() const { return 1; }
};

class clCMEnum_AntennaPathSwitch1
{
public:
	enum enAntennaPathSwitch1
	{
		DDS_off = 0,
		Antenna_1_selected,
		Antenna_2_selected,
		DDS_active
	};
	enAntennaPathSwitch1 enType;
	clCMEnum_AntennaPathSwitch1() { enType = DDS_off; }
	short getSize() const { return 1; }
};

class clCMEnum_AntennaPathSwitch2
{
public:
	enum enAntennaPathSwitch2
	{
		No_antenna_selected = 0,
		Antenna_1_selected,
		Antenna_2_selected
	};
	enAntennaPathSwitch2 enType;
	clCMEnum_AntennaPathSwitch2() { enType = No_antenna_selected; }
	short getSize() const { return 1; }
};

class clCMEnum_ConfigurationResult
{
public:
	enum enConfigurationResult
	{
		Configuration_finished = 0,
		Configuration_failed
	};
	enConfigurationResult enType;
	clCMEnum_ConfigurationResult() { enType = Configuration_finished; }
	short getSize() const { return 1; }
};

class clCMEnum_HDImageType
{
public:
	enum enHDImageType
	{
		Station_Logo_Or_Service_Logo = 0,
		Primary_Image,
		All_Image_Types = 0xff  //For Set message only
	};
	enHDImageType enType;
	clCMEnum_HDImageType() { enType = Station_Logo_Or_Service_Logo; }
	short getSize() const { return 1; }
};

class clCMEnum_HDImageCoding
{
public:
	enum enHDImageCoding
	{
		jpg_format = 0,
		png_format
	};
	enHDImageCoding enType;
	clCMEnum_HDImageCoding() { enType = jpg_format; }
	short getSize() const { return 1; }
};

class clCMEnum_DrmlanguageCode
{
public:
	enum enDrmlanguageCode
	{
		ISO_639_2_UNDEFINED = 0,
		ISO_639_2_AAR = 0x616172,
		ISO_639_2_ABK = 0X61626B,
		ISO_639_2_ACE = 0X616365,
		ISO_639_2_ACH = 0X616368,
		ISO_639_2_ADA = 0X616461,
		ISO_639_2_ADY = 0X616479,
		ISO_639_2_AFA = 0X616661,
		ISO_639_2_AFH = 0X616668,
		ISO_639_2_AFR = 0X616672,
		ISO_639_2_AIN = 0X61696E,
		ISO_639_2_AKA = 0X616B61,
		ISO_639_2_AKK = 0X616B6B,
		ISO_639_2_ALB = 0X616C62,
		ISO_639_2_SQI = 0X737169,
		ISO_639_2_ALE = 0X616C65,
		ISO_639_2_ALG = 0X616C67,
		ISO_639_2_ALT = 0X616C74,
		ISO_639_2_AMH = 0X616D68,
		ISO_639_2_ANG = 0X616E67,
		ISO_639_2_ANP = 0X616E70,
		ISO_639_2_APA = 0X617061,
		ISO_639_2_ARA = 0X617261,
		ISO_639_2_ARC = 0X617263,
		ISO_639_2_ARG = 0X617267,
		ISO_639_2_ARM = 0X61726D,
		ISO_639_2_HYE = 0X687965,
		ISO_639_2_ARN = 0X61726E,
		ISO_639_2_ARP = 0X617270,
		ISO_639_2_ART = 0X617274,
		ISO_639_2_ARW = 0X617277,
		ISO_639_2_ASM = 0X61736D,
		ISO_639_2_AST = 0X617374,
		ISO_639_2_ATH = 0X617468,
		ISO_639_2_AUS = 0X617573,
		ISO_639_2_AVA = 0X617661,
		ISO_639_2_AVE = 0X617665,
		ISO_639_2_AWA = 0X617761,
		ISO_639_2_AYM = 0X61796D,
		ISO_639_2_AZE = 0X617A65,
		ISO_639_2_BAD = 0X626164,
		ISO_639_2_BAI = 0X626169,
		ISO_639_2_BAK = 0X62616B,
		ISO_639_2_BAL = 0X62616C,
		ISO_639_2_BAM = 0X62616D,
		ISO_639_2_BAN = 0X62616E,
		ISO_639_2_BAQ = 0X626171,
		ISO_639_2_EUS = 0X657573,
		ISO_639_2_BAS = 0X626173,
		ISO_639_2_BAT = 0X626174,
		ISO_639_2_BEJ = 0X62656A,
		ISO_639_2_BEL = 0X62656C,
		ISO_639_2_BEM = 0X62656D,
		ISO_639_2_BEN = 0X62656E,
		ISO_639_2_BER = 0X626572,
		ISO_639_2_BHO = 0X62686F,
		ISO_639_2_BIH = 0X626968,
		ISO_639_2_BIK = 0X62696B,
		ISO_639_2_BIN = 0X62696E,
		ISO_639_2_BIS = 0X626973,
		ISO_639_2_BLA = 0X626C61,
		ISO_639_2_BNT = 0X626E74,
		ISO_639_2_TIB = 0X746962,
		ISO_639_2_BOD = 0X626F64,
		ISO_639_2_BOS = 0X626F73,
		ISO_639_2_BRA = 0X627261,
		ISO_639_2_BRE = 0X627265,
		ISO_639_2_BTK = 0X62746B,
		ISO_639_2_BUA = 0X627561,
		ISO_639_2_BUG = 0X627567,
		ISO_639_2_BUL = 0X62756C,
		ISO_639_2_BUR = 0X627572,
		ISO_639_2_MYA = 0X6D7961,
		ISO_639_2_BYN = 0X62796E,
		ISO_639_2_CAD = 0X636164,
		ISO_639_2_CAI = 0X636169,
		ISO_639_2_CAR = 0X636172,
		ISO_639_2_CAT = 0X636174,
		ISO_639_2_CAU = 0X636175,
		ISO_639_2_CEB = 0X636562,
		ISO_639_2_CEL = 0X63656C,
		ISO_639_2_CZE = 0X637A65,
		ISO_639_2_CES = 0X636573,
		ISO_639_2_CHA = 0X636861,
		ISO_639_2_CHB = 0X636862,
		ISO_639_2_CHE = 0X636865,
		ISO_639_2_CHG = 0X636867,
		ISO_639_2_CHI = 0X636869,
		ISO_639_2_ZHO = 0X7A686F,
		ISO_639_2_CHK = 0X63686B,
		ISO_639_2_CHM = 0X63686D,
		ISO_639_2_CHN = 0X63686E,
		ISO_639_2_CHO = 0X63686F,
		ISO_639_2_CHP = 0X636870,
		ISO_639_2_CHR = 0X636872,
		ISO_639_2_CHU = 0X636875,
		ISO_639_2_CHV = 0X636876,
		ISO_639_2_CHY = 0X636879,
		ISO_639_2_CMC = 0X636D63,
		ISO_639_2_COP = 0X636F70,
		ISO_639_2_COR = 0X636F72,
		ISO_639_2_COS = 0X636F73,
		ISO_639_2_CPE = 0X637065,
		ISO_639_2_CPF = 0X637066,
		ISO_639_2_CPP = 0X637070,
		ISO_639_2_CRE = 0X637265,
		ISO_639_2_CRH = 0X637268,
		ISO_639_2_CRP = 0X637270,
		ISO_639_2_CSB = 0X637362,
		ISO_639_2_CUS = 0X637573,
		ISO_639_2_DAK = 0X64616B,
		ISO_639_2_DAN = 0X64616E,
		ISO_639_2_DAR = 0X646172,
		ISO_639_2_DAY = 0X646179,
		ISO_639_2_DEL = 0X64656C,
		ISO_639_2_DEN = 0X64656E,
		ISO_639_2_DGR = 0X646772,
		ISO_639_2_DIN = 0X64696E,
		ISO_639_2_DIV = 0X646976,
		ISO_639_2_DOI = 0X646F69,
		ISO_639_2_DRA = 0X647261,
		ISO_639_2_DSB = 0X647362,
		ISO_639_2_DUA = 0X647561,
		ISO_639_2_DUM = 0X64756D,
		ISO_639_2_DYU = 0X647975,
		ISO_639_2_DZO = 0X647A6F,
		ISO_639_2_EFI = 0X656669,
		ISO_639_2_EGY = 0X656779,
		ISO_639_2_EKA = 0X656B61,
		ISO_639_2_GRE = 0X677265,
		ISO_639_2_ELL = 0X656C6C,
		ISO_639_2_ELX = 0X656C78,
		ISO_639_2_ENG = 0X656E67,
		ISO_639_2_ENM = 0X656E6D,
		ISO_639_2_EPO = 0X65706F,
		ISO_639_2_EST = 0X657374,
		ISO_639_2_EWE = 0X657765,
		ISO_639_2_EWO = 0X65776F,
		ISO_639_2_FAN = 0X66616E,
		ISO_639_2_FAO = 0X66616F,
		ISO_639_2_FAT = 0X666174,
		ISO_639_2_FIJ = 0X66696A,
		ISO_639_2_FIL = 0X66696C,
		ISO_639_2_FIN = 0X66696E,
		ISO_639_2_FIU = 0X666975,
		ISO_639_2_FON = 0X666F6E,
		ISO_639_2_FRE = 0X667265,
		ISO_639_2_FRA = 0X667261,
		ISO_639_2_FRM = 0X66726D,
		ISO_639_2_FRO = 0X66726F,
		ISO_639_2_FRR = 0X667272,
		ISO_639_2_FRS = 0X667273,
		ISO_639_2_FRY = 0X667279,
		ISO_639_2_FUL = 0X66756C,
		ISO_639_2_FUR = 0X667572,
		ISO_639_2_GAA = 0X676161,
		ISO_639_2_GAY = 0X676179,
		ISO_639_2_GBA = 0X676261,
		ISO_639_2_GEM = 0X67656D,
		ISO_639_2_GER = 0X676572,
		ISO_639_2_DEU = 0X646575,
		ISO_639_2_GEZ = 0X67657A,
		ISO_639_2_GIL = 0X67696C,
		ISO_639_2_GLA = 0X676C61,
		ISO_639_2_GLE = 0X676C65,
		ISO_639_2_GLG = 0X676C67,
		ISO_639_2_GLV = 0X676C76,
		ISO_639_2_GMH = 0X676D68,
		ISO_639_2_GOH = 0X676F68,
		ISO_639_2_GON = 0X676F6E,
		ISO_639_2_GOR = 0X676F72,
		ISO_639_2_GOT = 0X676F74,
		ISO_639_2_GRB = 0X677262,
		ISO_639_2_GRC = 0X677263,
		ISO_639_2_GRN = 0X67726E,
		ISO_639_2_GSW = 0X677377,
		ISO_639_2_GUJ = 0X67756A,
		ISO_639_2_GWI = 0X677769,
		ISO_639_2_HAI = 0X686169,
		ISO_639_2_HAT = 0X686174,
		ISO_639_2_HAU = 0X686175,
		ISO_639_2_HAW = 0X686177,
		ISO_639_2_HEB = 0X686562,
		ISO_639_2_HER = 0X686572,
		ISO_639_2_HIL = 0X68696C,
		ISO_639_2_HIM = 0X68696D,
		ISO_639_2_HIN = 0X68696E,
		ISO_639_2_HIT = 0X686974,
		ISO_639_2_HMN = 0X686D6E,
		ISO_639_2_HMO = 0X686D6F,
		ISO_639_2_HRV = 0X687276,
		ISO_639_2_HSB = 0X687362,
		ISO_639_2_HUN = 0X68756E,
		ISO_639_2_HUP = 0X687570,
		ISO_639_2_IBA = 0X696261,
		ISO_639_2_IBO = 0X69626F,
		ISO_639_2_ICE = 0X696365,
		ISO_639_2_ISL = 0X69736C,
		ISO_639_2_IDO = 0X69646F,
		ISO_639_2_III = 0X696969,
		ISO_639_2_IJO = 0X696A6F,
		ISO_639_2_IKU = 0X696B75,
		ISO_639_2_ILE = 0X696C65,
		ISO_639_2_ILO = 0X696C6F,
		ISO_639_2_INA = 0X696E61,
		ISO_639_2_INC = 0X696E63,
		ISO_639_2_IND = 0X696E64,
		ISO_639_2_INE = 0X696E65,
		ISO_639_2_INH = 0X696E68,
		ISO_639_2_IPK = 0X69706B,
		ISO_639_2_IRA = 0X697261,
		ISO_639_2_IRO = 0X69726F,
		ISO_639_2_ITA = 0X697461,
		ISO_639_2_JAV = 0X6A6176,
		ISO_639_2_JBO = 0X6A626F,
		ISO_639_2_JPN = 0X6A706E,
		ISO_639_2_JPR = 0X6A7072,
		ISO_639_2_JRB = 0X6A7262,
		ISO_639_2_KAA = 0X6B6161,
		ISO_639_2_KAB = 0X6B6162,
		ISO_639_2_KAC = 0X6B6163,
		ISO_639_2_KAL = 0X6B616C,
		ISO_639_2_KAM = 0X6B616D,
		ISO_639_2_KAN = 0X6B616E,
		ISO_639_2_KAR = 0X6B6172,
		ISO_639_2_KAS = 0X6B6173,
		ISO_639_2_GEO = 0X67656F,
		ISO_639_2_KAT = 0X6B6174,
		ISO_639_2_KAU = 0X6B6175,
		ISO_639_2_KAW = 0X6B6177,
		ISO_639_2_KAZ = 0X6B617A,
		ISO_639_2_KBD = 0X6B6264,
		ISO_639_2_KHA = 0X6B6861,
		ISO_639_2_KHI = 0X6B6869,
		ISO_639_2_KHM = 0X6B686D,
		ISO_639_2_KHO = 0X6B686F,
		ISO_639_2_KIK = 0X6B696B,
		ISO_639_2_KIN = 0X6B696E,
		ISO_639_2_KIR = 0X6B6972,
		ISO_639_2_KMB = 0X6B6D62,
		ISO_639_2_KOK = 0X6B6F6B,
		ISO_639_2_KOM = 0X6B6F6D,
		ISO_639_2_KON = 0X6B6F6E,
		ISO_639_2_KOR = 0X6B6F72,
		ISO_639_2_KOS = 0X6B6F73,
		ISO_639_2_KPE = 0X6B7065,
		ISO_639_2_KRC = 0X6B7263,
		ISO_639_2_KRL = 0X6B726C,
		ISO_639_2_KRO = 0X6B726F,
		ISO_639_2_KRU = 0X6B7275,
		ISO_639_2_KUA = 0X6B7561,
		ISO_639_2_KUM = 0X6B756D,
		ISO_639_2_KUR = 0X6B7572,
		ISO_639_2_KUT = 0X6B7574,
		ISO_639_2_LAD = 0X6C6164,
		ISO_639_2_LAH = 0X6C6168,
		ISO_639_2_LAM = 0X6C616D,
		ISO_639_2_LAO = 0X6C616F,
		ISO_639_2_LAT = 0X6C6174,
		ISO_639_2_LAV = 0X6C6176,
		ISO_639_2_LEZ = 0X6C657A,
		ISO_639_2_LIM = 0X6C696D,
		ISO_639_2_LIN = 0X6C696E,
		ISO_639_2_LIT = 0X6C6974,
		ISO_639_2_LOL = 0X6C6F6C,
		ISO_639_2_LOZ = 0X6C6F7A,
		ISO_639_2_LTZ = 0X6C747A,
		ISO_639_2_LUA = 0X6C7561,
		ISO_639_2_LUB = 0X6C7562,
		ISO_639_2_LUG = 0X6C7567,
		ISO_639_2_LUI = 0X6C7569,
		ISO_639_2_LUN = 0X6C756E,
		ISO_639_2_LUO = 0X6C756F,
		ISO_639_2_LUS = 0X6C7573,
		ISO_639_2_MAC = 0X6D6163,
		ISO_639_2_MKD = 0X6D6B64,
		ISO_639_2_MAD = 0X6D6164,
		ISO_639_2_MAG = 0X6D6167,
		ISO_639_2_MAH = 0X6D6168,
		ISO_639_2_MAI = 0X6D6169,
		ISO_639_2_MAK = 0X6D616B,
		ISO_639_2_MAL = 0X6D616C,
		ISO_639_2_MAN = 0X6D616E,
		ISO_639_2_MAO = 0X6D616F,
		ISO_639_2_MRI = 0X6D7269,
		ISO_639_2_MAP = 0X6D6170,
		ISO_639_2_MAR = 0X6D6172,
		ISO_639_2_MAS = 0X6D6173,
		ISO_639_2_MAY = 0X6D6179,
		ISO_639_2_MSA = 0X6D7361,
		ISO_639_2_MDF = 0X6D6466,
		ISO_639_2_MDR = 0X6D6472,
		ISO_639_2_MEN = 0X6D656E,
		ISO_639_2_MGA = 0X6D6761,
		ISO_639_2_MIC = 0X6D6963,
		ISO_639_2_MIN = 0X6D696E,
		ISO_639_2_MIS = 0X6D6973,
		ISO_639_2_MKH = 0X6D6B68,
		ISO_639_2_MLG = 0X6D6C67,
		ISO_639_2_MLT = 0X6D6C74,
		ISO_639_2_MNC = 0X6D6E63,
		ISO_639_2_MNI = 0X6D6E69,
		ISO_639_2_MNO = 0X6D6E6F,
		ISO_639_2_MOH = 0X6D6F68,
		ISO_639_2_MON = 0X6D6F6E,
		ISO_639_2_MOS = 0X6D6F73,
		ISO_639_2_MUL = 0X6D756C,
		ISO_639_2_MUN = 0X6D756E,
		ISO_639_2_MUS = 0X6D7573,
		ISO_639_2_MWL = 0X6D776C,
		ISO_639_2_MWR = 0X6D7772,
		ISO_639_2_MYN = 0X6D796E,
		ISO_639_2_MYV = 0X6D7976,
		ISO_639_2_NAH = 0X6E6168,
		ISO_639_2_NAI = 0X6E6169,
		ISO_639_2_NAP = 0X6E6170,
		ISO_639_2_NAU = 0X6E6175,
		ISO_639_2_NAV = 0X6E6176,
		ISO_639_2_NBL = 0X6E626C,
		ISO_639_2_NDE = 0X6E6465,
		ISO_639_2_NDO = 0X6E646F,
		ISO_639_2_NDS = 0X6E6473,
		ISO_639_2_NEP = 0X6E6570,
		ISO_639_2_NEW = 0X6E6577,
		ISO_639_2_NIA = 0X6E6961,
		ISO_639_2_NIC = 0X6E6963,
		ISO_639_2_NIU = 0X6E6975,
		ISO_639_2_DUT = 0X647574,
		ISO_639_2_NLD = 0X6E6C64,
		ISO_639_2_NNO = 0X6E6E6F,
		ISO_639_2_NOB = 0X6E6F62,
		ISO_639_2_NOG = 0X6E6F67,
		ISO_639_2_NON = 0X6E6F6E,
		ISO_639_2_NOR = 0X6E6F72,
		ISO_639_2_NQO = 0X6E716F,
		ISO_639_2_NSO = 0X6E736F,
		ISO_639_2_NUB = 0X6E7562,
		ISO_639_2_NWC = 0X6E7763,
		ISO_639_2_NYA = 0X6E7961,
		ISO_639_2_NYM = 0X6E796D,
		ISO_639_2_NYN = 0X6E796E,
		ISO_639_2_NYO = 0X6E796F,
		ISO_639_2_NZI = 0X6E7A69,
		ISO_639_2_OCI = 0X6F6369,
		ISO_639_2_OJI = 0X6F6A69,
		ISO_639_2_ORI = 0X6F7269,
		ISO_639_2_ORM = 0X6F726D,
		ISO_639_2_OSA = 0X6F7361,
		ISO_639_2_OSS = 0X6F7373,
		ISO_639_2_OTA = 0X6F7461,
		ISO_639_2_OTO = 0X6F746F,
		ISO_639_2_PAA = 0X706161,
		ISO_639_2_PAG = 0X706167,
		ISO_639_2_PAL = 0X70616C,
		ISO_639_2_PAM = 0X70616D,
		ISO_639_2_PAN = 0X70616E,
		ISO_639_2_PAP = 0X706170,
		ISO_639_2_PAU = 0X706175,
		ISO_639_2_PEO = 0X70656F,
		ISO_639_2_PER = 0X706572,
		ISO_639_2_FAS = 0X666173,
		ISO_639_2_PHI = 0X706869,
		ISO_639_2_PHN = 0X70686E,
		ISO_639_2_PLI = 0X706C69,
		ISO_639_2_POL = 0X706F6C,
		ISO_639_2_PON = 0X706F6E,
		ISO_639_2_POR = 0X706F72,
		ISO_639_2_PRA = 0X707261,
		ISO_639_2_PRO = 0X70726F,
		ISO_639_2_PUS = 0X707573,
		//ISO_639_2_QAA_QTZ = 0X71616171747A,
		ISO_639_2_QUE = 0X717565,
		ISO_639_2_RAJ = 0X72616A,
		ISO_639_2_RAP = 0X726170,
		ISO_639_2_RAR = 0X726172,
		ISO_639_2_ROA = 0X726F61,
		ISO_639_2_ROH = 0X726F68,
		ISO_639_2_ROM = 0X726F6D,
		ISO_639_2_RUM = 0X72756D,
		ISO_639_2_RON = 0X726F6E,
		ISO_639_2_RUN = 0X72756E,
		ISO_639_2_RUP = 0X727570,
		ISO_639_2_RUS = 0X727573,
		ISO_639_2_SAD = 0X736164,
		ISO_639_2_SAG = 0X736167,
		ISO_639_2_SAH = 0X736168,
		ISO_639_2_SAI = 0X736169,
		ISO_639_2_SAL = 0X73616C,
		ISO_639_2_SAM = 0X73616D,
		ISO_639_2_SAN = 0X73616E,
		ISO_639_2_SAS = 0X736173,
		ISO_639_2_SAT = 0X736174,
		ISO_639_2_SCN = 0X73636E,
		ISO_639_2_SCO = 0X73636F,
		ISO_639_2_SEL = 0X73656C,
		ISO_639_2_SEM = 0X73656D,
		ISO_639_2_SGA = 0X736761,
		ISO_639_2_SGN = 0X73676E,
		ISO_639_2_SHN = 0X73686E,
		ISO_639_2_SID = 0X736964,
		ISO_639_2_SIN = 0X73696E,
		ISO_639_2_SIO = 0X73696F,
		ISO_639_2_SIT = 0X736974,
		ISO_639_2_SLA = 0X736C61,
		ISO_639_2_SLO = 0X736C6F,
		ISO_639_2_SLK = 0X736C6B,
		ISO_639_2_SLV = 0X736C76,
		ISO_639_2_SMA = 0X736D61,
		ISO_639_2_SME = 0X736D65,
		ISO_639_2_SMI = 0X736D69,
		ISO_639_2_SMJ = 0X736D6A,
		ISO_639_2_SMN = 0X736D6E,
		ISO_639_2_SMO = 0X736D6F,
		ISO_639_2_SMS = 0X736D73,
		ISO_639_2_SNA = 0X736E61,
		ISO_639_2_SND = 0X736E64,
		ISO_639_2_SNK = 0X736E6B,
		ISO_639_2_SOG = 0X736F67,
		ISO_639_2_SOM = 0X736F6D,
		ISO_639_2_SON = 0X736F6E,
		ISO_639_2_SOT = 0X736F74,
		ISO_639_2_SPA = 0X737061,
		ISO_639_2_SRD = 0X737264,
		ISO_639_2_SRN = 0X73726E,
		ISO_639_2_SRP = 0X737270,
		ISO_639_2_SRR = 0X737272,
		ISO_639_2_SSA = 0X737361,
		ISO_639_2_SSW = 0X737377,
		ISO_639_2_SUK = 0X73756B,
		ISO_639_2_SUN = 0X73756E,
		ISO_639_2_SUS = 0X737573,
		ISO_639_2_SUX = 0X737578,
		ISO_639_2_SWA = 0X737761,
		ISO_639_2_SWE = 0X737765,
		ISO_639_2_SYC = 0X737963,
		ISO_639_2_SYR = 0X737972,
		ISO_639_2_TAH = 0X746168,
		ISO_639_2_TAI = 0X746169,
		ISO_639_2_TAM = 0X74616D,
		ISO_639_2_TAT = 0X746174,
		ISO_639_2_TEL = 0X74656C,
		ISO_639_2_TEM = 0X74656D,
		ISO_639_2_TER = 0X746572,
		ISO_639_2_TET = 0X746574,
		ISO_639_2_TGK = 0X74676B,
		ISO_639_2_TGL = 0X74676C,
		ISO_639_2_THA = 0X746861,
		ISO_639_2_TIG = 0X746967,
		ISO_639_2_TIR = 0X746972,
		ISO_639_2_TIV = 0X746976,
		ISO_639_2_TKL = 0X746B6C,
		ISO_639_2_TLH = 0X746C68,
		ISO_639_2_TLI = 0X746C69,
		ISO_639_2_TMH = 0X746D68,
		ISO_639_2_TOG = 0X746F67,
		ISO_639_2_TON = 0X746F6E,
		ISO_639_2_TPI = 0X747069,
		ISO_639_2_TSI = 0X747369,
		ISO_639_2_TSN = 0X74736E,
		ISO_639_2_TSO = 0X74736F,
		ISO_639_2_TUK = 0X74756B,
		ISO_639_2_TUM = 0X74756D,
		ISO_639_2_TUP = 0X747570,
		ISO_639_2_TUR = 0X747572,
		ISO_639_2_TUT = 0X747574,
		ISO_639_2_TVL = 0X74766C,
		ISO_639_2_TWI = 0X747769,
		ISO_639_2_TYV = 0X747976,
		ISO_639_2_UDM = 0X75646D,
		ISO_639_2_UGA = 0X756761,
		ISO_639_2_UIG = 0X756967,
		ISO_639_2_UKR = 0X756B72,
		ISO_639_2_UMB = 0X756D62,
		ISO_639_2_UND = 0X756E64,
		ISO_639_2_URD = 0X757264,
		ISO_639_2_UZB = 0X757A62,
		ISO_639_2_VAI = 0X766169,
		ISO_639_2_VEN = 0X76656E,
		ISO_639_2_VIE = 0X766965,
		ISO_639_2_VOL = 0X766F6C,
		ISO_639_2_VOT = 0X766F74,
		ISO_639_2_WAK = 0X77616B,
		ISO_639_2_WAL = 0X77616C,
		ISO_639_2_WAR = 0X776172,
		ISO_639_2_WAS = 0X776173,
		ISO_639_2_WEN = 0X77656E,
		ISO_639_2_WLN = 0X776C6E,
		ISO_639_2_WOL = 0X776F6C,
		ISO_639_2_XAL = 0X78616C,
		ISO_639_2_XHO = 0X78686F,
		ISO_639_2_YAO = 0X79616F,
		ISO_639_2_YAP = 0X796170,
		ISO_639_2_YID = 0X796964,
		ISO_639_2_YOR = 0X796F72,
		ISO_639_2_YPK = 0X79706B,
		ISO_639_2_ZAP = 0X7A6170,
		ISO_639_2_ZBL = 0X7A626C,
		ISO_639_2_ZEN = 0X7A656E,
		ISO_639_2_ZGH = 0X7A6768,
		ISO_639_2_ZHA = 0X7A6861,
		ISO_639_2_ZND = 0X7A6E64,
		ISO_639_2_ZUL = 0X7A756C,
		ISO_639_2_ZUN = 0X7A756E,
		ISO_639_2_ZXX = 0X7A7878,
		ISO_639_2_ZZA = 0X7A7A61

	};
	enDrmlanguageCode enType;
	clCMEnum_DrmlanguageCode() { enType = ISO_639_2_UNDEFINED; }
	short getSize() const { return 3; } // DrmlanguageCode size is 3 bytes length
};

class clCMEnum_DrmCountryCode
{
public:
	enum enDrmCountryCode
	{
		ISO_ALPHA_3_UNDEFINED = 0UL,
		ISO_ALPHA_3_AFG = 1223UL,
		ISO_ALPHA_3_ALB = 1410UL,
		ISO_ALPHA_3_DZA = 4929UL,
		ISO_ALPHA_3_ASM = 1645UL,
		ISO_ALPHA_3_AND = 1476UL,
		ISO_ALPHA_3_AGO = 1263UL,
		ISO_ALPHA_3_AIA = 1313UL,
		ISO_ALPHA_3_ATG = 1671UL,
		ISO_ALPHA_3_ARG = 1607UL,
		ISO_ALPHA_3_ARM = 1613UL,
		ISO_ALPHA_3_ABW = 1111UL,
		ISO_ALPHA_3_AUS = 1715UL,
		ISO_ALPHA_3_AUT = 1716UL,
		ISO_ALPHA_3_AZE = 1861UL,
		ISO_ALPHA_3_BHS = 2323UL,
		ISO_ALPHA_3_BHR = 2322UL,
		ISO_ALPHA_3_BGD = 2276UL,
		ISO_ALPHA_3_BRB = 2626UL,
		ISO_ALPHA_3_BLR = 2450UL,
		ISO_ALPHA_3_BEL = 2220UL,
		ISO_ALPHA_3_BLZ = 2458UL,
		ISO_ALPHA_3_BEN = 2222UL,
		ISO_ALPHA_3_BMU = 2485UL,
		ISO_ALPHA_3_BTN = 2702UL,
		ISO_ALPHA_3_BOL = 2540UL,
		ISO_ALPHA_3_BIH = 2344UL,
		ISO_ALPHA_3_BWA = 2785UL,
		ISO_ALPHA_3_BRA = 2625UL,
		ISO_ALPHA_3_BRN = 2638UL,
		ISO_ALPHA_3_BGR = 2290UL,
		ISO_ALPHA_3_BFA = 2241UL,
		ISO_ALPHA_3_BDI = 2185UL,
		ISO_ALPHA_3_KHM = 11533UL,
		ISO_ALPHA_3_CMR = 3506UL,
		ISO_ALPHA_3_CAN = 3118UL,
		ISO_ALPHA_3_CPV = 3606UL,
		ISO_ALPHA_3_CYM = 3885UL,
		ISO_ALPHA_3_CAF = 3110UL,
		ISO_ALPHA_3_TCD = 20580UL,
		ISO_ALPHA_3_CHL = 3340UL,
		ISO_ALPHA_3_CHN = 3342UL,
		ISO_ALPHA_3_COL = 3564UL,
		ISO_ALPHA_3_COM = 3565UL,
		ISO_ALPHA_3_COG = 3559UL,
		ISO_ALPHA_3_COD = 3556UL,
		ISO_ALPHA_3_COK = 3563UL,
		ISO_ALPHA_3_CRI = 3657UL,
		ISO_ALPHA_3_CIV = 3382UL,
		ISO_ALPHA_3_HRV = 8790UL,
		ISO_ALPHA_3_CUB = 3746UL,
		ISO_ALPHA_3_CYP = 3888UL,
		ISO_ALPHA_3_CZE = 3909UL,
		ISO_ALPHA_3_DNK = 4555UL,
		ISO_ALPHA_3_DJI = 4425UL,
		ISO_ALPHA_3_DMA = 4513UL,
		ISO_ALPHA_3_DOM = 4589UL,
		ISO_ALPHA_3_ECU = 5237UL,
		ISO_ALPHA_3_EGY = 5369UL,
		ISO_ALPHA_3_SLV = 19862UL,
		ISO_ALPHA_3_GNQ = 7633UL,
		ISO_ALPHA_3_ERI = 5705UL,
		ISO_ALPHA_3_EST = 5748UL,
		ISO_ALPHA_3_ETH = 5768UL,
		ISO_ALPHA_3_FLK = 6539UL,
		ISO_ALPHA_3_FRO = 6735UL,
		ISO_ALPHA_3_FJI = 6473UL,
		ISO_ALPHA_3_FIN = 6446UL,
		ISO_ALPHA_3_FRA = 6721UL,
		ISO_ALPHA_3_GUF = 7846UL,
		ISO_ALPHA_3_PYF = 17190UL,
		ISO_ALPHA_3_GAB = 7202UL,
		ISO_ALPHA_3_GMB = 7586UL,
		ISO_ALPHA_3_GEO = 7343UL,
		ISO_ALPHA_3_DEU = 4277UL,
		ISO_ALPHA_3_GHA = 7425UL,
		ISO_ALPHA_3_GIB = 7458UL,
		ISO_ALPHA_3_GRC = 7747UL,
		ISO_ALPHA_3_GRL = 7756UL,
		ISO_ALPHA_3_GRD = 7748UL,
		ISO_ALPHA_3_GLP = 7568UL,
		ISO_ALPHA_3_GUM = 7853UL,
		ISO_ALPHA_3_GTM = 7821UL,
		ISO_ALPHA_3_GIN = 7470UL,
		ISO_ALPHA_3_GNB = 7618UL,
		ISO_ALPHA_3_GUY = 7865UL,
		ISO_ALPHA_3_HTI = 8841UL,
		ISO_ALPHA_3_VAT = 22580UL,
		ISO_ALPHA_3_HND = 8644UL,
		ISO_ALPHA_3_HKG = 8551UL,
		ISO_ALPHA_3_HUN = 8878UL,
		ISO_ALPHA_3_ISL = 9836UL,
		ISO_ALPHA_3_IND = 9668UL,
		ISO_ALPHA_3_IDN = 9358UL,
		ISO_ALPHA_3_INT = 9684UL,
		ISO_ALPHA_3_IRN = 9806UL,
		ISO_ALPHA_3_IRQ = 9809UL,
		ISO_ALPHA_3_IRL = 9804UL,
		ISO_ALPHA_3_ISR = 9842UL,
		ISO_ALPHA_3_ITA = 9857UL,
		ISO_ALPHA_3_JAM = 10285UL,
		ISO_ALPHA_3_JPN = 10766UL,
		ISO_ALPHA_3_JOR = 10738UL,
		ISO_ALPHA_3_KAZ = 11322UL,
		ISO_ALPHA_3_KEN = 11438UL,
		ISO_ALPHA_3_KIR = 11570UL,
		ISO_ALPHA_3_PRK = 16971UL,
		ISO_ALPHA_3_KOR = 11762UL,
		ISO_ALPHA_3_KWT = 12020UL,
		ISO_ALPHA_3_KGZ = 11514UL,
		ISO_ALPHA_3_LAO = 12335UL,
		ISO_ALPHA_3_LVA = 12993UL,
		ISO_ALPHA_3_LBN = 12366UL,
		ISO_ALPHA_3_LSO = 12911UL,
		ISO_ALPHA_3_LBR = 12370UL,
		ISO_ALPHA_3_LBY = 12377UL,
		ISO_ALPHA_3_LIE = 12581UL,
		ISO_ALPHA_3_LTU = 12949UL,
		ISO_ALPHA_3_LUX = 12984UL,
		ISO_ALPHA_3_MAC = 13347UL,
		ISO_ALPHA_3_MKD = 13668UL,
		ISO_ALPHA_3_MDG = 13447UL,
		ISO_ALPHA_3_MWI = 14057UL,
		ISO_ALPHA_3_MYS = 14131UL,
		ISO_ALPHA_3_MDV = 13462UL,
		ISO_ALPHA_3_MLI = 13705UL,
		ISO_ALPHA_3_MLT = 13716UL,
		ISO_ALPHA_3_MHL = 13580UL,
		ISO_ALPHA_3_MTQ = 13969UL,
		ISO_ALPHA_3_MRT = 13908UL,
		ISO_ALPHA_3_MUS = 14003UL,
		ISO_ALPHA_3_MYT = 14132UL,
		ISO_ALPHA_3_MEX = 13496UL,
		ISO_ALPHA_3_FSM = 6765UL,
		ISO_ALPHA_3_MDA = 13441UL,
		ISO_ALPHA_3_MCO = 13423UL,
		ISO_ALPHA_3_MNG = 13767UL,
		ISO_ALPHA_3_MNE = 13765UL,
		ISO_ALPHA_3_MSR = 13938UL,
		ISO_ALPHA_3_MAR = 13362UL,
		ISO_ALPHA_3_MOZ = 13818UL,
		ISO_ALPHA_3_MMR = 13746UL,
		ISO_ALPHA_3_NAM = 14381UL,
		ISO_ALPHA_3_NRU = 14933UL,
		ISO_ALPHA_3_NPL = 14860UL,
		ISO_ALPHA_3_NLD = 14724UL,
		ISO_ALPHA_3_ANT = 1492UL,
		ISO_ALPHA_3_NCL = 14444UL,
		ISO_ALPHA_3_NZL = 15180UL,
		ISO_ALPHA_3_NIC = 14627UL,
		ISO_ALPHA_3_NER = 14514UL,
		ISO_ALPHA_3_NGA = 14561UL,
		ISO_ALPHA_3_NIU = 14645UL,
		ISO_ALPHA_3_NFK = 14539UL,
		ISO_ALPHA_3_MNP = 13776UL,
		ISO_ALPHA_3_NOR = 14834UL,
		ISO_ALPHA_3_PSE = 16997UL,
		ISO_ALPHA_3_OMN = 15790UL,
		ISO_ALPHA_3_PAK = 16427UL,
		ISO_ALPHA_3_PLW = 16791UL,
		ISO_ALPHA_3_PAN = 16430UL,
		ISO_ALPHA_3_PNG = 16839UL,
		ISO_ALPHA_3_PRY = 16985UL,
		ISO_ALPHA_3_PER = 16562UL,
		ISO_ALPHA_3_PHL = 16652UL,
		ISO_ALPHA_3_PCN = 16494UL,
		ISO_ALPHA_3_POL = 16876UL,
		ISO_ALPHA_3_PRT = 16980UL,
		ISO_ALPHA_3_PRI = 16969UL,
		ISO_ALPHA_3_QAT = 17460UL,
		ISO_ALPHA_3_REU = 18613UL,
		ISO_ALPHA_3_ROU = 18933UL,
		ISO_ALPHA_3_RUS = 19123UL,
		ISO_ALPHA_3_RWA = 19169UL,
		ISO_ALPHA_3_KNA = 11713UL,
		ISO_ALPHA_3_LCA = 12385UL,
		ISO_ALPHA_3_VCT = 22644UL,
		ISO_ALPHA_3_WSM = 24173UL,
		ISO_ALPHA_3_SMR = 19890UL,
		ISO_ALPHA_3_STP = 20112UL,
		ISO_ALPHA_3_SAU = 19509UL,
		ISO_ALPHA_3_SEN = 19630UL,
		ISO_ALPHA_3_SRB = 20034UL,
		ISO_ALPHA_3_SYC = 20259UL,
		ISO_ALPHA_3_SLE = 19845UL,
		ISO_ALPHA_3_SGP = 19696UL,
		ISO_ALPHA_3_SVK = 20171UL,
		ISO_ALPHA_3_SVN = 20174UL,
		ISO_ALPHA_3_SLB = 19842UL,
		ISO_ALPHA_3_SOM = 19949UL,
		ISO_ALPHA_3_ZAF = 26662UL,
		ISO_ALPHA_3_ESP = 5744UL,
		ISO_ALPHA_3_LKA = 12641UL,
		ISO_ALPHA_3_SHN = 19726UL,
		ISO_ALPHA_3_SPM = 19981UL,
		ISO_ALPHA_3_SDN = 19598UL,
		ISO_ALPHA_3_SUR = 20146UL,
		ISO_ALPHA_3_SJM = 19789UL,
		ISO_ALPHA_3_SWZ = 20218UL,
		ISO_ALPHA_3_SWE = 20197UL,
		ISO_ALPHA_3_CHE = 3333UL,
		ISO_ALPHA_3_SYR = 20274UL,
		ISO_ALPHA_3_TWN = 21230UL,
		ISO_ALPHA_3_TJK = 20811UL,
		ISO_ALPHA_3_TZA = 21313UL,
		ISO_ALPHA_3_THA = 20737UL,
		ISO_ALPHA_3_TLS = 20883UL,
		ISO_ALPHA_3_TGO = 20719UL,
		ISO_ALPHA_3_TKL = 20844UL,
		ISO_ALPHA_3_TON = 20974UL,
		ISO_ALPHA_3_TTO = 21135UL,
		ISO_ALPHA_3_TUN = 21166UL,
		ISO_ALPHA_3_TUR = 21170UL,
		ISO_ALPHA_3_TKM = 20845UL,
		ISO_ALPHA_3_TCA = 20577UL,
		ISO_ALPHA_3_TUV = 21174UL,
		ISO_ALPHA_3_UGA = 21729UL,
		ISO_ALPHA_3_UKR = 21874UL,
		ISO_ALPHA_3_ARE = 1605UL,
		ISO_ALPHA_3_GBR = 7250UL,
		ISO_ALPHA_3_USA = 22113UL,
		ISO_ALPHA_3_URY = 22105UL,
		ISO_ALPHA_3_UZB = 22338UL,
		ISO_ALPHA_3_VUT = 23220UL,
		ISO_ALPHA_3_VEN = 22702UL,
		ISO_ALPHA_3_VNM = 22989UL,
		ISO_ALPHA_3_VGB = 22754UL,
		ISO_ALPHA_3_VIR = 22834UL,
		ISO_ALPHA_3_WLF = 23942UL,
		ISO_ALPHA_3_ESH = 5736UL,
		ISO_ALPHA_3_YEM = 25773UL,
		ISO_ALPHA_3_YUG = 26279UL,
		ISO_ALPHA_3_ZMB = 27042UL,
		ISO_ALPHA_3_ZWE = 27365UL
	};
	enDrmCountryCode enType;
	clCMEnum_DrmCountryCode() { enType = ISO_ALPHA_3_UNDEFINED; }
	short getSize() const { return 2; } // DrmCountryCode size is 2 bytes length
};

class clCMEnum_DigitalModulation
{
public:
	enum enDigitalModulation
	{
		No_Digital_Modulation = 0,
		HD_Radio,
		DRM
	};
	enDigitalModulation enType;
	clCMEnum_DigitalModulation() { enType = No_Digital_Modulation; }
	short getSize() const { return 1; }
};

class clCMEnum_PtyFilter
{
public:
	enum enPtyFilter
	{
		PtyFilter_None =				0x00000000,
		PtyFilter_NoPTY =				0x00000001,
		PtyFilter_News =				0x00000002,
		PtyFilter_CurrentAffairs =		0x00000004,
		PtyFilter_Information =			0x00000008,
		PtyFilter_Sport =				0x00000010,
		PtyFilter_Education =			0x00000020,
		PtyFilter_Drama =				0x00000040,
		PtyFilter_Culture =				0x00000080,
		PtyFilter_Science =				0x00000100,
		PtyFilter_Varied =				0x00000200,
		PtyFilter_PopMusic =			0x00000400,
		PtyFilter_RockMusic =			0x00000800,
		PtyFilter_EasyListening =		0x00001000,
		PtyFilter_LightClassical =		0x00002000,
		PtyFilter_SeriousClassical =	0x00004000,
		PtyFilter_OtherMusic =			0x00008000,
		PtyFilter_Weather =				0x00010000,
		PtyFilter_Finance =				0x00020000,
		PtyFilter_ForChildren =			0x00040000,
		PtyFilter_SocialAffairs =		0x00080000,
		PtyFilter_Religion =			0x00100000,
		PtyFilter_PhoneIn =				0x00200000,
		PtyFilter_Leisure =				0x00400000,
		PtyFilter_JazzMusic =			0x00800000,
		PtyFilter_CountryMusic =		0x01000000,
		PtyFilter_NationalMusic =		0x02000000,
		PtyFilter_OldiesMusic =			0x04000000,
		PtyFilter_FolkMusic =			0x08000000,
		PtyFilter_Documentary =			0x10000000,
		PtyFilter_AlarmTest =			0x20000000,
		PtyFilter_Alarm =				0x40000000
	};
	enPtyFilter enType;
	clCMEnum_PtyFilter() { enType = PtyFilter_None; }
	short getSize() const { return 1; }
};

class clCMEnum_AudioSource
{
public:
	enum enAudioSource
	{
		No_Audio = 0,
		User_Audio,
		TA_Audio,
		PTY_Audio,
		WeatherAlert_Audio
	};
	enAudioSource enType;
	clCMEnum_AudioSource() { enType = No_Audio; }
	short getSize() const { return 1; }
};


class clCMEnum_MTCAudioSource
{
public:
	enum enMTCAudioSource
	{
		NotHeardSource = 0,
		User_audio_FM,
		User_audio_DAB,
		User_audio_LW,
		User_audio_MW,
		User_audio_TRF,
		User_audio_WB,
		User_audio_CB1 = 21,
		User_audio_CB2 = 22,
		Anno_audio_RDS = 30,
		PTY31_audio_RDS,
		Alarm_audio_DAB = 40,
		Road_traffic_flash_audio_DAB,
		Transport_flash_audio_DAB,
		Warning_flash_audio_DAB,
		News_flash_audio_DAB,
		Weather_flash_audio_DAB,
		Event_announcement_audio_DAB,
		Special_event_audio_DAB,
		Programme_information_audio_DAB,
		Sport_report_audio_DAB,
		Financial_report_audio_DAB,
		Audio_last_source = 255
	};
	enMTCAudioSource enType;
	clCMEnum_MTCAudioSource() { enType = NotHeardSource; }
	short getSize() const { return 1; }
};


#endif
